/*
 * LibrePCB - Professional EDA for everyone!
 * Copyright (C) 2013 LibrePCB Developers, see AUTHORS.md for contributors.
 * https://librepcb.org/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBREPCB_EDITOR_MOVEALIGNDIALOG_H
#define LIBREPCB_EDITOR_MOVEALIGNDIALOG_H

/*******************************************************************************
 *  Includes
 ******************************************************************************/
#include <librepcb/core/types/point.h>
#include <optional/tl/optional.hpp>

#include <QtCore>
#include <QtWidgets>

/*******************************************************************************
 *  Namespace / Forward Declarations
 ******************************************************************************/
namespace librepcb {
namespace editor {

namespace Ui {
class MoveAlignDialog;
}

/*******************************************************************************
 *  Class MoveAlignDialog
 ******************************************************************************/

/**
 * @brief The MoveAlignDialog class
 */
class MoveAlignDialog final : public QDialog {
  Q_OBJECT

  typedef tl::optional<PositiveLength> Interval;

public:
  // Constructors / Destructor
  MoveAlignDialog() = delete;
  MoveAlignDialog(const MoveAlignDialog& other) = delete;
  MoveAlignDialog(const QList<Point>& positions, const QString& settingsPrefix,
                  QWidget* parent = nullptr) noexcept;
  ~MoveAlignDialog() noexcept;

  // Getters
  const QList<Point>& getNewPositions() const noexcept { return mNewPositions; }

  // Operator Overloadings
  MoveAlignDialog& operator=(const MoveAlignDialog& rhs) = delete;

signals:
  void positionsChanged(const QList<Point>& positions);

private:  // Methods
  virtual bool eventFilter(QObject* watched, QEvent* event) noexcept override;
  void updateNewPositions() noexcept;
  static Point calcCenter(const QList<Point>& p) noexcept;

private:  // Data
  QScopedPointer<Ui::MoveAlignDialog> mUi;
  const QString mSettingsPrefix;
  const QList<Point> mPositions;
  QList<Point> mPositionsOrdered;  ///< Unique; First item = reference position;
  Point mDefaultInterval;
  QList<Point> mNewPositions;
};

/*******************************************************************************
 *  End of File
 ******************************************************************************/

}  // namespace editor
}  // namespace librepcb

#endif
