/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#ifndef FamilyEditor_H
#include "FamilyEditor.h"
#endif

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif
 
#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif


#include <Tab.h>
#include "Log.h"

#ifndef FamilyHelper_H
#include "FamilyHelper.h"
#endif


FamilyEditor::FamilyEditor(const IconClass& name,const string& kind):
	XEditor<UIFamilyEditor_c>(name,kind),
	helper_(FamilyHelper::find(name))
{	
	Request r(name.name().c_str());
	makeTabs(tab_,0,r);
}

FamilyEditor::~FamilyEditor()
{
}

void FamilyEditor::makeTabs(Widget w,int n,Request& r)
{
	const vector<string>& p = helper_.params();
	if(n == p.size()) return;

	const vector<string>& v = helper_.values(p[n]);
	const vector<string>& b = helper_.beau(p[n]);

	for(int i = 0; i < v.size(); i++)
	{
		r(p[n].c_str()) = v[i].c_str();
		Widget q;

		if(n == p.size() - 1)
		{

			Request s = class_.language().expand(r);
			const char * type = s(helper_.keyword().c_str());

			//-- This one was a problem on AIX/xlC: (Dec01/vk)
			//-   although panels_[type] returns a reference,
			//-   on xlC it returns a reference to a copy,
			//-   and we have to put it back to the map!

			Panel  pan = panels_[type];

			pan.panel_ = new RequestPanel(IconClass::find(type), w, type);
			pan.first_ = r;
			pan.tab_   = w;

			panels_[type] = pan; //-- put the copy back (AIX/xlC req!)

			q = pan.panel_->main();

		}
		else
		{
			Widget t = CreateTab(w,(char*)v[i].c_str(),0,0);
			XtAddCallback(t, XmNvalueChangedCallback, &UIFamilyEditor_c::familyCB, 
				(XtPointer) dynamic_cast<UIFamilyEditor_c*>(this));

			makeTabs(t,n+1,r);

			XtManageChild(t);
			q = t;
		}
		TabSetName(w,q,b[i].c_str());
	}

}


void FamilyEditor::apply()
{
	for(map<string, Panel>::iterator j = panels_.begin(); j != panels_.end(); ++j)
	  {
	    if( (*j).second.panel_ )
	      (*j).second.panel_->apply();
	    else
              cout << ">>> FamilyEditor::apply (*j).second.panel_ is NULL => skipping!" 
	           << endl;
	  }

	current_->request(frontPanel().panel_->request());
}

void FamilyEditor::reset()
{	
	for(map<string,Panel>::iterator j = panels_.begin(); j != panels_.end(); ++j)
	{
		const string& n = (*j).first;
		Panel& panel    = (*j).second;
		panel.temp_     = IconFactory::create(current_,Request(n));
	}

	Request r  = current_->request();
	string  s  = r.getVerb();
	if(panels_.find(s) != panels_.end())
		panels_[s].temp_->request(r);

	map<string,Panel>::iterator j = panels_.begin();
	while( j != panels_.end() )
	{
		Panel& panel = (*j).second;
		++j;
		if( panel.panel_ )
		    panel.panel_->reset(panel.temp_);
		else
		    cout << ">>> FamilyEditor::reset(): panel.panel_ is NULL => skipping!" 
		         << endl;
	}

#ifndef MV_EXT_PANEL
	Widget w = panels_[s].panel_->main();
#else
	Panel myPanel = panels_[s];
        if( ! myPanel.panel_ )
          {
            Log::error("MetviewUI") << "ALERT: broken " 
				    << kind().c_str() 
				    << " icon!" 
				    << endl;
            return;
          }

	Widget w = myPanel.panel_->main();
#endif

	TabSetCurrent(XtParent(w),w, False);     	
}


void FamilyEditor::close()
{      
	for(map<string, Panel>::iterator j = panels_.begin(); j != panels_.end(); ++j)
	  {
	    RequestPanel* panel = (*j).second.panel_;
	    if( panel )
	       panel->close();
	  }
}

void FamilyEditor::replace(IconObject* o)
{
	frontPanel().panel_->replace(o);
}

void FamilyEditor::merge(IconObject* o)
{
	frontPanel().panel_->merge(o); 
}


IconObject* FamilyEditor::copy(const string& name)
{
	IconObject* o = IconFactory::create(name, class_);
	frontPanel().panel_->apply();
	o->request(frontPanel().panel_->request());
	return o;
}

void FamilyEditor::familyCB(Widget, XtPointer data)
{
//	TabCallbackStruct *cb =(TabCallbackStruct*) data;
//	const char *name = XtName(cb->widget);
}


string FamilyEditor::choice()
{
	Widget w = tab_;
	string result;

	do
	{
		w = TabGetCurrent(w);
		result = XtName(w);
	} while(XtIsTab(w));

	cout << "CHOICEis " << result << endl;
	return result;
}

#ifdef MV_EXT_PANEL
  Panel&               FamilyEditor::frontPanel()
#else
  FamilyEditor::Panel& FamilyEditor::frontPanel()
#endif
{
 	return panels_[choice()];	
}


static EditorMaker<FamilyEditor> editorMaker("FamilyEditor");
