/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "PlotModInteractive.h"

#include "MvApplication.h"
#include "PlotModConst.h"
#include "uPlotBase.h"

#include <QDebug>
#include <QMessageBox>

PlotModInteractive::PlotModInteractive()
{
    isInteractive_   = true;
    isWindow_        = true;
    plotDestination_ = MVSCREEN;
    printerName_     = "";
}

void PlotModInteractive::showInfoMessagePopup(const string& message)
{
    QString str = QString::fromStdString(message);
    QMessageBox::information(plotApplication_, "uPlot", str);
}

void PlotModInteractive::showWarningMessagePopup(const string& message)
{
    QString str = QString::fromStdString(message);
    QMessageBox::warning(plotApplication_, "uPlot", str);
}

void PlotModInteractive::showErrorMessagePopup(const string& message)
{
    QString str = QString::fromStdString(message);
    QMessageBox::critical(plotApplication_, "uPlot", str);
}

//void PlotModInteractive::progressMessage(const string& message)
//{
//    if (plotApplication_)
//        plotApplication_->progressMessage(message);
//


// Print a message to the log window or the output; if 'priority', then
// it will be visible without '-slog'
void PlotModInteractive::printMessage(const string& msg, PlotMod::MessageLevel level, bool priority)
{
    if (priority) {
        sendMessageToService(msg);
    }
    writeToLog(msg, level);
}


void PlotModInteractive::SystemError(const string& message, const string& title)
{
    // Call the MetviewError method to get output to the user
    string fullMessage = title + ": " + message;
    MetviewError(fullMessage, "ERROR");

#if 0
      string titleText ( "PlotMod System Error" );
      if ( title.length() )
	titleText = titleText + ": " + title;
      InfoDialogManager::Instance().post( titleText.c_str(), message.c_str());
  
  MvRequest reqst("USER_MESSAGE");
  reqst("INFO") = message.c_str(); 
  send_message(PlotModApp::Instance().getService(),(request*)reqst);
#endif
}


#if 0
void
PlotMod::InternalError ( const string & message, const string & title )
{
     string titleText ( "PlotMod Internal Error" );
      if ( title.length() )
	titleText = titleText + ": " + title;
      InfoDialogManager::Instance().post( titleText.c_str(), message.c_str());

  MvRequest reqst("USER_MESSAGE");
  reqst("INFO") = message.c_str(); 

  send_message(PlotModApp::Instance().getService(),(request*)reqst);
}

#endif
