//------------------------------------------------------------------------------
// <copyright file="MembershipAdapter.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

namespace System.Web.Security {
    using System;
    using System.Web.Configuration;

    // NOTE: This type exists solely for System.Web.ApplicationServices.dll which creates and calls 
    // it dynamically using Reflection. DO NOT rename, or change the namespace of this class without
    // updating the associated code in ndp\fx\src\xsp\System\AppServices\Util\SystemWebProxy.cs.
    internal class MembershipAdapter : IMembershipAdapter {
        
        public MembershipAdapter() {
        }

        public MembershipProviderCollection Providers {
            get { return Membership.Providers; }
        }

        public int UserIsOnlineTimeWindow {
            get { return Membership.UserIsOnlineTimeWindow; }
        }

        public bool IsDecryptionKeyAutogenerated {
            get { return MachineKeySection.IsDecryptionKeyAutogenerated; }
        }

        public bool UsingCustomEncryption {
            get { return MachineKeySection.UsingCustomEncryption; }
        }

        public byte[] EncryptOrDecryptData(bool encrypt, byte[] buffer, bool useLegacyMode) {

            // DevDiv Bugs 137864: Use IVType.None for compatibility with stored passwords even after SP20 compat mode enabled.
            // This is the ONLY case IVType.None should be used.

            // We made changes to how encryption takes place in response to MSRC 10405. Membership needs to opt-out of
            // these changes (by setting signData to false) to preserve back-compat with existing databases.

#pragma warning disable 618 // calling obsolete methods
            return MachineKeySection.EncryptOrDecryptData(encrypt, buffer, (byte[])null, 0, buffer.Length, false /* useValidationSymAlgo */, useLegacyMode, IVType.None, false /*Sign*/);
#pragma warning restore 618 // calling obsolete methods
        }
    }
}
