//
// ButtonBackendGtk3.cs
//
// Author:
//       Vsevolod Kukol <v.kukol@rubologic.de>
//
// Copyright (c) 2014 Vsevolod Kukol
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
using System;
using Xwt.CairoBackend;

namespace Xwt.GtkBackend
{
	public partial class ButtonBackend
	{
		void SetMiniModeGtk (bool miniMode)
		{
			if (miniMode) {
				Widget.Drawn += HandleDrawn;
				int w, h;
				Widget.Child.GetSizeRequest (out w, out h);
				Widget.SetSizeRequest (w, h);
			}
		}

		[GLib.ConnectBefore]
		void HandleDrawn (object o, Gtk.DrawnArgs args)
		{
			var gc = Widget.StyleContext.GetBackgroundColor (Widget.StateFlags);
			args.Cr.Rectangle (0, 0, Widget.Allocation.Width, Widget.Allocation.Height);
			args.Cr.SetSourceColor (gc.ToCairoColor ());
			args.Cr.Fill ();
		}
	}
}

