/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * WsimportOptionsPanel.java
 *
 * Created on Sep 15, 2008, 10:02:05 AM
 */
package org.netbeans.modules.websvc.customization.jaxwssettings.panel;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.openide.util.NbBundle;

/**
 *
 * @author rico
 */
public class WsimportOptionsPanel extends javax.swing.JPanel {

    private List<WsimportOption> wsimportOptions;
    private List<WsimportOption> jaxbOptions;
    private List<String> reservedOptions;
    private String[] columnNames;
    private WsimportOptions wsimportOptionParent;

    /** Creates new form WsimportOptionsPanel */
    public WsimportOptionsPanel(List<WsimportOption> wsimportOptions, List<WsimportOption> jaxbOptions, WsimportOptions wsimportOptionParent, String jvmOptions) {

        this.wsimportOptions = wsimportOptions;
        this.jaxbOptions = jaxbOptions;
        this.wsimportOptionParent = wsimportOptionParent;
        columnNames = new String[] {
            NbBundle.getMessage(WsimportOptionsPanel.class,"HEADING_OPTION"),
            NbBundle.getMessage(WsimportOptionsPanel.class,"HEADING_VALUE")
        };
        reservedOptions = getReservedOptions();
        initComponents();
        jvmTextField.setText(jvmOptions);
        
    }

    private List<String> getReservedOptions() {
        if (reservedOptions == null) {
            reservedOptions = new ArrayList<String>();
            reservedOptions.add("destdir"); //NOI18N
            reservedOptions.add("wsdl"); //NOI18N
            reservedOptions.add("sourcedestdir"); //NOI18N
            reservedOptions.add("catalog"); //NOI18N
        }
        return reservedOptions;
    }

    public List<WsimportOption> getWsimportOptions(){
        return wsimportOptionsPanel.getOptions();
    }

    public List<WsimportOption> getJaxbOptions(){
        return jaxbOptionsPanel.getOptions();
    }
    
    public String getJvmOptions(){
        return jvmTextField.getText().trim();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        wsimportOptionsPanel = new OptionsPanel(columnNames, wsimportOptions, reservedOptions, wsimportOptionParent);
        jaxbOptionsPanel = new OptionsPanel(columnNames, jaxbOptions, null, wsimportOptionParent);
        wsimportLabel = new javax.swing.JLabel();
        jaxbLabel = new javax.swing.JLabel();
        jvmLabel = new javax.swing.JLabel();
        jvmDescriptionLabel = new javax.swing.JLabel();
        jvmTextField = new javax.swing.JTextField();

        wsimportLabel.setLabelFor(wsimportOptionsPanel);
        org.openide.awt.Mnemonics.setLocalizedText(wsimportLabel, org.openide.util.NbBundle.getMessage(WsimportOptionsPanel.class, "LBL_WSIMPORT_OPTIONS")); // NOI18N

        jaxbLabel.setLabelFor(jaxbOptionsPanel);
        org.openide.awt.Mnemonics.setLocalizedText(jaxbLabel, org.openide.util.NbBundle.getMessage(WsimportOptionsPanel.class, "Label_JAXB_OPTIONS")); // NOI18N

        jvmLabel.setLabelFor(jvmTextField);
        org.openide.awt.Mnemonics.setLocalizedText(jvmLabel, org.openide.util.NbBundle.getMessage(WsimportOptionsPanel.class, "WsimportOptionsPanel.jvmLabel.text")); // NOI18N

        jvmDescriptionLabel.setText(org.openide.util.NbBundle.getMessage(WsimportOptionsPanel.class, "WsimportOptionsPanel.jvmDescriptionLabel.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jaxbOptionsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 563, Short.MAX_VALUE)
                    .addComponent(wsimportOptionsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(wsimportLabel)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jvmLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jvmDescriptionLabel)
                                    .addComponent(jvmTextField))))
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jaxbLabel)
                        .addGap(0, 0, Short.MAX_VALUE))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(wsimportLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(wsimportOptionsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 183, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jvmLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 17, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jvmTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jvmDescriptionLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jaxbLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jaxbOptionsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
                .addGap(18, 18, 18))
        );

        jvmTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(WsimportOptionsPanel.class, "WsimportOptionsPanel.jvmTextField.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jaxbLabel;
    private org.netbeans.modules.websvc.customization.jaxwssettings.panel.OptionsPanel jaxbOptionsPanel;
    private javax.swing.JLabel jvmDescriptionLabel;
    private javax.swing.JLabel jvmLabel;
    private javax.swing.JTextField jvmTextField;
    private javax.swing.JLabel wsimportLabel;
    private org.netbeans.modules.websvc.customization.jaxwssettings.panel.OptionsPanel wsimportOptionsPanel;
    // End of variables declaration//GEN-END:variables
}
