# All projects using JSS

## Integrations

[React-JSS](./react-jss.md) - HOC interface for React with theming support.

[Styled-JSS](https://github.com/cssinjs/styled-jss) - styled components interface for React.

[Aphrodite-JSS](https://github.com/cssinjs/aphrodite-jss) - aphrodite like API.

[glamor-jss](https://github.com/dan-lee/glamor-jss) - glamor like API.

[Aesthetic](https://github.com/milesj/aesthetic) - a React style abstraction layer with theme support.

[CSSX](https://github.com/krasimir/cssx) CSS syntax which can use JSS for rendering.

[vue-jss](https://github.com/BestVue3/vue-jss) - a JSS integration for Vue

## Examples

[Examples repository](https://github.com/cssinjs/examples)

## UI libs

[Material-UI](https://github.com/callemall/material-ui) React Components that Implement Google's Material Design

[Arwes](https://arwes.romelperez.com) Futuristic Sci-Fi and Cyberpunk Graphical User Interface Framework for Web Apps

[react-modal-dialog](https://github.com/qimingweng/react-modal-dialog) A modal dialog for ReactJS

## Plugins

[jss-legacy-browsers](https://github.com/moliver-bb/jss-legacy-browsers) JSS plugin that handles legacy browser support

[jss-color-rebeccapurple](https://github.com/joshgillies/jss-color-rebeccapurple) JSS plugin to transform the W3C CSS rebeccapurple color to rgb.

[jss-rtl](https://github.com/alitaheri/jss-rtl) JSS plugin to convert the layout from ltr to rtl.

[jss-plugin-rem-em-to-px](https://github.com/JoeDuncko/jss-plugin-rem-em-to-px) JSS plugin for converting all em and rem values to px.

[jss-plugin-all-important](https://github.com/JoeDuncko/jss-plugin-all-important) JSS plugin for making all possible values !important.

## Convenience

[jss-simple](https://github.com/ashaffer/jss-simple) Thin wrapper around jss that simplifies its interface and restricts you to a single, global stylesheet.

[jss-css](https://github.com/alexkuz/jss-css) This is a convenience module for JSS that converts CSS string into JSS object. It allows to describe style classes for components in a habitual and little less verbose way.

[PreJSS](https://github.com/axept/prejss) Fast, scoped, component-friendly and fully customizable PostCSS-to-JSS adapter which allows to use plain CSS, PostCSS, SCSS, CSS Modules, Stylus and LESS styles as JSS objects "on-the-fly" through using Tagged Template Strings.

## Style helpers

[normalize-jss](https://github.com/cssinjs/normalize-jss) JSS port of normalize.css

[perdido](https://github.com/wldcordeiro/perdido) JSS fractional grid system built with calc(), based on Lost PostCSS grid. Supports masonry, vertical, and waffle grids.

## Build tools

[babel-plugin-jss-simple](https://github.com/ashaffer/babel-plugin-jss-simple) Add filename keys to your jss-simple declarations to help with hot reloading.

[babel-plugin-jss-css](https://github.com/alexkuz/babel-plugin-jss-css) Babel plugin for [jss-css](https://github.com/alexkuz/jss-css) module.

[jss-loader](https://github.com/cssinjs/jss-loader) Webpack loader - use JavaScript as your CSS preprocessor!

[jss-sheet-Loader](https://github.com/wellguimaraes/jss-sheet-loader) Webpack loader for JSS to simplify styles creation and usage.

[gulp-jss](https://github.com/gooy/gulp-jss) Gulp plugin

## Editor integrations

[Atom snippets](https://atom.io/packages/jss-atom-snippets) Snippets for Atom

[VS Code snippets](https://marketplace.visualstudio.com/items?itemName=visioncan.vscode-jss-snippets) Snippets for Visual Studio Code

[JSS Codemorphs](https://codemodsquad.github.io/jss-codemorphs/) Comprehensive CSS to JS styles converter

[VS JSS Codemorphs](https://marketplace.visualstudio.com/items?itemName=vscodeshift.jss-codemorphs) Visual Studio Code command for converting CSS to JS styles

[Atom CSS to JS converter](https://atom.io/packages/css-in-js) Atom plugin for converting CSS to JS styles and vice versa

## Linters

[ESLint plugin for React JSS](https://github.com/dashxhq/eslint-plugin-react-jss) ESLint plugin for React JSS
