Index: node-rollup-plugin-node-resolve/rollup.config.js
===================================================================
--- node-rollup-plugin-node-resolve.orig/rollup.config.js
+++ node-rollup-plugin-node-resolve/rollup.config.js
@@ -1,8 +1,34 @@
-import buble from 'rollup-plugin-buble';
+var plugins = [];
+
+switch(process.env.TRANSPILE) {
+case 'babel6':
+    var babel=require('rollup-plugin-babel');
+    const plugins_babel6 = [
+      babel({
+	babelrc: false,
+	presets: [[process.env.BABEL_PRESET, { modules: false }]],
+    }),
+    ];
+    plugins = plugins_babel6; break;
+case 'babel7':
+    var babel=require('rollup-plugin-babel');
+    const plugins_babel7 = [
+      babel(),
+    ];
+    plugins = plugins_babel7; break;
+case 'none':
+    plugins = []; break;
+default:
+    var buble=require('rollup-plugin-buble');
+    const plugins_buble = [
+    buble()
+    ];
+    plugins = plugins_buble;
+}
 
 export default {
 	input: 'src/index.js',
-	plugins: [ buble() ],
+	plugins: plugins,
 	external: [ 'path', 'fs', 'builtin-modules', 'resolve', 'browser-resolve', 'is-module' ],
 	output: [
 		{ file: 'dist/rollup-plugin-node-resolve.cjs.js', format: 'cjs' },
