'use strict';

// Tests multiple profiles generated by --heap-prof-interval are valid.

const common = require('../common');

const fixtures = require('../common/fixtures');
common.skipIfInspectorDisabled();

const assert = require('assert');
const fs = require('fs');
const path = require('path');
const { spawnSync } = require('child_process');

const tmpdir = require('../common/tmpdir');

const {
  getHeapProfiles,
  findFirstFrame,
  kHeapProfInterval,
  env
} = require('../common/prof');

{
  tmpdir.refresh();
  const output = spawnSync(process.execPath, [
    '--heap-prof-interval',
    kHeapProfInterval,
    '--heap-prof-dir',
    'prof',
    '--heap-prof',
    fixtures.path('workload', 'allocation-worker.js'),
  ], {
    cwd: tmpdir.path,
    env
  });
  if (output.status !== 0) {
    console.log(output.stderr.toString());
  }
  assert.strictEqual(output.status, 0);
  const dir = path.join(tmpdir.path, 'prof');
  assert(fs.existsSync(dir));
  const profiles = getHeapProfiles(dir);
  assert.strictEqual(profiles.length, 2);
  const profile1 = findFirstFrame(profiles[0], 'runAllocation');
  const profile2 = findFirstFrame(profiles[1], 'runAllocation');
  if (!profile1.frame && !profile2.frame) {
    // Show native debug output and the profile for debugging.
    console.log(output.stderr.toString());
    console.log('heap path: ', profiles[0]);
    console.log(profile1.roots);
    console.log('heap path: ', profiles[1]);
    console.log(profile2.roots);
  }
  assert(profile1.frame || profile2.frame);
}
