/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.plugin.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.chefproject.core.Realm;
import org.chefproject.core.Role;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.plugin.RealmProvider;
import org.chefproject.util.Abilities;
import org.chefproject.util.StringUtil;
import org.chefproject.util.UmiacClient;

public class UnivOfMichRealmProvider
implements RealmProvider {
    protected UmiacClient m_umiac = UmiacClient.getInstance();

    public Abilities getAbilities(Realm realm, String id, String user) {
        Abilities abilities = new Abilities();
        try {
            Role role;
            String[] ids = this.unpackId(id);
            Map map = this.m_umiac.getGroupRoles(ids);
            String roleId = (String)map.get(user);
            if (roleId != null && (role = realm.getRole(roleId)) != null) {
                abilities.add(role);
            }
        }
        catch (IdUnusedException e) {
            // empty catch block
        }
        return abilities;
    }

    public Map getAbilities(Realm realm, String id) {
        HashMap<String, Abilities> rv = new HashMap<String, Abilities>();
        try {
            String[] ids = this.unpackId(id);
            Map map = this.m_umiac.getGroupRoles(ids);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String userId = (String)entry.getKey();
                String roleId = (String)entry.getValue();
                roleId = "Instructor".equals(roleId) ? "maintain" : "access";
                Role role = realm.getRole(roleId);
                if (role == null) continue;
                Abilities abilities = new Abilities();
                abilities.add(role);
                rv.put(userId, abilities);
            }
        }
        catch (IdUnusedException e) {
            // empty catch block
        }
        return rv;
    }

    protected String[] unpackId(String id) {
        Vector<String> returnVector = new Vector<String>();
        String[] first = this.unpackIdFull(id);
        int i = 0;
        while (i < first.length) {
            String[] second = this.unpackIdSections(first[i]);
            int s = 0;
            while (s < second.length) {
                returnVector.add(second[s]);
                ++s;
            }
            ++i;
        }
        String[] rv = returnVector.toArray(new String[returnVector.size()]);
        return rv;
    }

    protected String[] unpackIdFull(String id) {
        String[] rv = null;
        int pos = id.indexOf(43);
        rv = pos == -1 ? new String[]{id} : StringUtil.split(id, "+");
        return rv;
    }

    protected String[] unpackIdSections(String id) {
        String[] rv = null;
        int leftPos = id.indexOf(91);
        int rightPos = id.indexOf(93);
        if (leftPos == -1 || rightPos == -1 || rightPos - leftPos <= 1) {
            rv = new String[]{id};
        } else {
            String root = id.substring(0, leftPos);
            String sectionString = id.substring(leftPos + 1, rightPos);
            String[] sections = StringUtil.split(sectionString, ",");
            if (sections == null || sections.length == 0) {
                rv = new String[]{id};
            } else {
                rv = new String[sections.length];
                int i = 0;
                while (i < sections.length) {
                    rv[i] = root + sections[i];
                    ++i;
                }
            }
        }
        return rv;
    }
}

