/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.plugin.component;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.UserEdit;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.plugin.CompleteUdp;
import org.chefproject.util.UmiacClient;

public class UnivOfMichUserDirectoryProvider
implements CompleteUdp {
    protected UmiacClient m_umiac = UmiacClient.getInstance();

    public boolean userExists(String userId) {
        if (this.m_umiac.userExists(userId)) {
            return true;
        }
        return this.userKnownToKerberos(userId);
    }

    public boolean getUser(UserEdit edit) {
        if (!this.userExists(edit.getId())) {
            return false;
        }
        try {
            this.m_umiac.setUserNames(edit);
        }
        catch (IdUnusedException e) {
            edit.setLastName(edit.getId());
        }
        edit.setEmail(edit.getId() + "@umich.edu");
        return true;
    }

    public boolean findUserByEmail(UserEdit edit, String email) {
        int pos = email.indexOf("@umich.edu");
        if (pos != 0) {
            String id = email.substring(0, pos);
            edit.setId(id);
            return this.getUser(edit);
        }
        return false;
    }

    public boolean authenticateUser(String userId, String password) {
        JetspeedRunDataService runDataService;
        JetspeedRunData data;
        boolean containerAuthentication = "true".equals(JetspeedResources.getString((String)"container.auth"));
        if (containerAuthentication && userId.equals((data = (runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService")).getCurrentRunData()).getRequest().getRemoteUser())) {
            return true;
        }
        return this.authenticateKerberos(userId, password);
    }

    protected boolean authenticateKerberos(String user, String pw) {
        if (pw == null || pw.length() == 0) {
            return false;
        }
        LoginContext lc = null;
        try {
            ChefCallbackHandler t = new ChefCallbackHandler();
            t.setId(user);
            t.setPw(pw);
            lc = new LoginContext("JaasAuthentication", t);
        }
        catch (LoginException le) {
            Log.warn("chef", this + ".authenticateKerberos(): " + le.toString());
            return false;
        }
        catch (SecurityException se) {
            Log.warn("chef", this + ".authenticateKerberos(): " + se.toString());
            return false;
        }
        try {
            lc.login();
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".authenticateKerberos(" + user + ", pw): kerberos success!");
            }
            return true;
        }
        catch (LoginException le) {
            Log.warn("chef", this + ".authenticateKerberos(" + user + ", pw): kerberos failed: " + le.toString());
            return false;
        }
    }

    private boolean userKnownToKerberos(String user) {
        String pw = "dummy";
        LoginContext lc = null;
        try {
            ChefCallbackHandler t = new ChefCallbackHandler();
            t.setId(user);
            t.setPw(pw);
            lc = new LoginContext("JaasAuthentication", t);
        }
        catch (LoginException le) {
            Log.warn("chef", this + ".useKnownToKerberos(): " + le.toString());
            return false;
        }
        catch (SecurityException se) {
            Log.warn("chef", this + ".useKnownToKerberos(): " + se.toString());
            return false;
        }
        try {
            lc.login();
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".useKnownToKerberos(" + user + "): kerberos success!");
            }
            return true;
        }
        catch (LoginException le) {
            String msg = le.getMessage();
            if (msg.equals("Pre-authentication information was invalid (24) - Preauthentication failed")) {
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", this + ".useKnownToKerberos(" + user + "): kerberos user exists!");
                }
                return true;
            }
            Log.warn("chef", this + ".userKnownToKerberos(" + user + "): kerberos user does not exist!");
            return false;
        }
    }

    protected class ChefCallbackHandler
    implements CallbackHandler {
        private String m_id = new String("");
        private String m_pw = new String("");

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Object confirmation = null;
            int i = 0;
            while (i < callbacks.length) {
                if (callbacks[i] instanceof TextOutputCallback) {
                    if (Log.getLogger("chef").isDebugEnabled()) {
                        Log.debug("chef", "ChefCallbackHandler: TextOutputCallback");
                    }
                } else if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    String result = this.getId();
                    if (result.equals("")) {
                        result = nc.getDefaultName();
                    }
                    nc.setName(result);
                } else if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(this.getPw());
                } else if (callbacks[i] instanceof ConfirmationCallback) {
                    if (Log.getLogger("chef").isDebugEnabled()) {
                        Log.debug("chef", "ChefCallbackHandler: ConfirmationCallback");
                    }
                } else {
                    throw new UnsupportedCallbackException(callbacks[i], "ChefCallbackHandler: Unrecognized Callback");
                }
                ++i;
            }
        }

        void setId(String id) {
            this.m_id = id;
        }

        private String getId() {
            return this.m_id;
        }

        void setPw(String pw) {
            this.m_pw = pw;
        }

        private char[] getPw() {
            return this.m_pw.toCharArray();
        }
    }
}

