/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.Realm;
import org.chefproject.core.RealmEdit;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.Role;
import org.chefproject.core.Site;
import org.chefproject.core.SiteEdit;
import org.chefproject.core.SitePage;
import org.chefproject.core.SitePageEdit;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.core.ToolRegistration;
import org.chefproject.core.User;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.IdService;
import org.chefproject.service.RealmService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.util.Email;
import org.chefproject.util.EventObservingCourier;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;
import org.chefproject.util.TimeBreakdown;
import org.chefproject.util.UmiacClient;

public class SiteAction
extends VelocityPortletPaneledAction {
    protected static final String[] TEMPLATE = new String[]{"-list", "-type", "-courseContact", "-courseClass", "-courseFeatures", "-dissertationContact", "-dissertationProgram", "-dissertationFeatures", "-projectContact", "-projectInformation", "-projectFeatures", "-courseInformation", "-coursePublish", "-otherInvite", "-otherPublish", "-customize", "-basicInformation", "-addRemoveParticipant", "-addRemoveSection", "-sectionInformation", "-deleteSection", "-addRemoveFeature", "-customLayout", "-customLink", "-customPage", "-roster", "-customFeatures", "-listParticipants", "-addParticipant", "-removeParticipants", "-changeRoles", "-confirmSiteDelete", "-makePublic"};
    private UmiacClient umiacClient = UmiacClient.getInstance();
    private boolean siteInState = false;
    private static final String STATE_SITE_INSTANCE = "site.instance";
    private static final String STATE_SITE_INFO = "site.info";
    private static final String STATE_SITE_TYPE = "CTNG:site-type";
    private static final String PROP_EXTERNAL_ID = "CTNG:external-id";
    private static final String PROP_SITE_CONTACT_INSTITUTION = "CTNG:contact-institution";
    private static final String PROP_SITE_CONTACT_AFFILIATION = "CTNG:contact-affiliation";
    private static final String PROP_SITE_CONTACT_EMAIL = "CTNG:contact-email";
    private static final String PROP_SITE_CONTACT_HONORIFIC = "CTNG:contact-honorific";
    private static final String PROP_SITE_CONTACT_OFFICE = "CTNG:contact-office";
    private static final String PROP_SITE_CONTACT_PHONE = "CTNG:contact-phone";
    private static final String PROP_SITE_TYPE = "CTNG:site-type";
    private static final String PROP_SITE_TITLE = "CTNG:title";
    private static final String PROP_SITE_DESCRIPTION = "CTNG:description";
    private static final String PROP_SITE_TERM = "CTNG:term";
    private static final String PROP_SITE_SUBJECT = "CTNG:subject";
    private static final String PROP_SITE_COURSE = "CTNG:course";
    private static final String PROP_SITE_SECTIONS = "CTNG:sections";
    private static final String PROP_SITE_REUSE = "CTNG:reuse";
    private static final String PROP_SITE_RELATED_CLASS = "CTNG:related-class";
    private static final String PROP_SITE_RELATED_PROJECT = "CTNG:related-project";
    private static final String PROP_SITE_ICON_URL = "CTNG:site-icon-url";
    private static final String PROP_SITE_SITE_INFO_URL = "CTNG:site-info-url";
    private static final String PROP_SITE_ADDITIONAL = "CTNG:additional";
    private static final int FALL_2003 = 0;
    private static final int WINTER_2004 = 1;
    private static final int SPRING_2004 = 2;
    private static final int SPRING_SUMMER_2004 = 3;
    private static final int SUMMER_2004 = 4;
    private static final int FALL_2004 = 5;
    private static final int CURRENT_TERM = 0;
    private List FALL_2003_List = new Vector();
    private List WINTER_2004_List = new Vector();
    private List SPRING_2004_List = new Vector();
    private List SPRING_SUMMER_2004_List = new Vector();
    private List SUMMER_2004_List = new Vector();
    private List FALL_2004_List = new Vector();
    public static final String SITE_TYPE_COURSE = "CTNG-course";
    public static final String SITE_TYPE_DISSERTATION = "CTNG-dissertation";
    private static final String SITE_TYPE_PROJECT = "CTNG-project";
    public static final String SITE_TYPE_WORKSHOP = "CTNG-workshop";
    public static final String SITE_TYPE_REQUESTED = "CTNG-requested";
    public static final String SITE_TYPE_UNDEFINED = "CTNG-undefined";
    public static final String[] SITE_TYPES;
    private List affiliationList = new Vector();
    private List courseList = new Vector();
    private List honorificList = new Vector();
    private List featureList = new Vector();
    private List relatedProjectList = new Vector();
    private List relatedClassList = new Vector();
    private List selectedList = new Vector();
    private List sectionList = new Vector();
    private List siteSectionList = new Vector();
    private List subjectList = new Vector();
    private List subjectTitleList = new Vector();
    private List termList = new Vector();
    private List toolList = new Vector();
    private List toolRegistrationSelectedList = new Vector();
    private List toolRegistrationList = new Vector();
    private static final String STATE_SITE_REMOVALS = "site.removals";
    private static final String STATE_TOOL_REGISTRATION_LIST = "toolRegistrationList";
    private static final String STATE_TOOL_REGISTRATION_SELECTED_LIST = "toolRegistrationSelectedList";
    private static final String STATE_COURSE_TOOL_LIST = "courseToolList";
    private static final String STATE_PROJECT_TOOL_LIST = "projectToolList";
    private static final String STATE_DISSERTATION_TOOL_LIST = "dissertationToolList";
    private static final String STATE_WORKSHOP_TOOL_LIST = "workshopToolList";
    private static final String STATE_TOOL_LIST = "toolList";
    private static final String STATE_FEATURE_LIST = "site.feature.list";
    private static final String FEATURE_LIST = "featureList";
    private static final String STATE_SITE_TOOL_LIST = "site.tool.list";
    private static final String SELECTED_LIST = "selectedList";
    private static final String AFFILIATION_LIST = "affiliationList";
    private static final String COURSE_LIST = "courseList";
    private static final String HONORIFIC_LIST = "honorificList";
    private static final String RELATED_PROJECT_LIST = "relatedProjectList";
    private static final String RELATED_CLASS_LIST = "relatedClassList";
    private static final String TERM_LIST = "termList";
    private static final String SECTION_LIST = "sectionList";
    private static final String SITE_SECTION_LIST = "siteSectionList";
    private static final String STATE_UNPUBLISHED_SITES_LIST = "unpublishedSitesList";
    private static final String STATE_PUBLISHED_SITES_LIST = "publishedSitesList";
    private static final String STATE_REQUESTED_SITES_LIST = "requestedSitesList";
    private static final String STATE_CURRENT_TERM_SITES_LIST = "currentTermSitesList";
    private static final String STATE_OTHER_SITES_LIST = "otherSitesList";
    private static final String STATE_SITE_LIST = "site.list";
    private static final String SUBJECT_LIST = "subjectList";
    private static final String SUBJECT_TITLE_LIST = "subjectTitleList";
    private static final String STATE_PROFILE = "profile";
    private static final String STATE_CLASS_ROSTER = "site.class.roster";
    private static final String STATE_TERM_REQUEST = "site.term.request";
    private static final String STATE_SUBJECT_REQUEST = "site.subject.request";
    private static final String STATE_COURSE_REQUEST = "site.course.request";
    private static final String STATE_SECTION_REQUEST = "stite.section.equest";
    private static final String FORM_TITLE = "form_title";
    private static final String FORM_DESCRIPTION = "form_description";
    private static final String FORM_AFFILIATION = "form_affiliation";
    private static final String FORM_AFFILIATION_TEXT = "form_affiliation_text";
    private static final String FORM_HONORIFIC = "form_honorific";
    private static final String FORM_INSTITUTION = "form_institution";
    private static final String FORM_SUBJECT = "form_subject";
    private static final String FORM_COURSE = "form_course";
    private static final String FORM_SECTION = "form_section";
    private static final String FORM_OFFICE = "form_office";
    private static final String FORM_PHONE = "form_phone";
    private static final String FORM_EMAIL = "form_email";
    private static final String FORM_TERM = "form_term";
    private static final String FORM_REUSE = "form_reuse";
    private static final String FORM_RELATED_CLASS = "form_related_class";
    private static final String FORM_RELATED_PROJECT = "form_related_project";
    private static final String FORM_NAME = "form_name";
    private static final String FORM_PERSON = "form_person";
    private static final String FORM_SHORT_DESCRIPTION = "form_short_description";
    private static final String FORM_SELECTED = "form_selected";
    private static final String FORM_UMID = "form_umid";
    private static final String CONTEXT_ACTION = "SiteAction";
    private static final int NUMBER_OF_TEMPLATES = 5;
    private static final String STATE_TEMPLATE_INDEX = "site.templateIndex";
    private static final String STATE_TEMPLATE_ARRAY = "site.templateArray";
    private static final String STATE_INITIALIZED = "site.initialized";
    private static final String STATE_ACTION = "site.action";
    private static final String STATE_ALERT_MESSAGE = "alertMessage";
    private static final String STATE_SORT_BY = "site.sort_by";
    private static final String STATE_SORT_ASC = "site.sort_asc";
    private static final String STATE_MY_COPYRIGHT = "resources.mycopyright";
    private static final String COPYRIGHT_SYMBOL = "&#169;";
    private static final String SECTION_DELIMITER = ":";
    private static final String STATE_TERM_SELECTED = "stateTermSelected";
    private static final String NULL_STRING = "";
    private static final String FINISHED_STRING = "Your site set up is complete. You may now add content to and then publish your site.";
    private static final String NO_SITE_SELECTED_STRING = "No site(s) checked. Please check a site or sites.";
    private static final String NO_FEATURES_SELECTED_STRING = "You have not checked any features for your site. Please check the features you wish to add.";
    private static final String NO_STATE_SITE_INSTANCE_STRING = "NO_STATE_SITE_INSTANCE";
    private static final String NO_STATE_SITE_INFO_STRING = " NO_STATE_SITE_INFO";
    private static final String NO_STATE_PROFILE_STRING = "NO_STATE_PROFILE";
    private static final String MORE_THAN_ONE_SITE_SELECTED_STRING = "Please check only one site to Revise... at a time";
    protected static final String[] AFFILIATIONS;
    private static final String[] HONORIFICS;
    private static final String[] TERMS;

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        if (state.getAttribute("obsever") == null) {
            String deliveryId = this.clientWindowId(state, portlet.getID());
            String elementId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID());
            String pattern = SiteService.siteReference(NULL_STRING);
            state.setAttribute("obsever", (Object)new EventObservingCourier(deliveryId, elementId, pattern));
        }
        this.updateObservationOfChannel(state, portlet.getID());
    }

    private void updateObservationOfChannel(SessionState state, String peid) {
        EventObservingCourier observer = (EventObservingCourier)state.getAttribute("obsever");
        String deliveryId = this.clientWindowId(state, peid);
        observer.setDeliveryId(deliveryId);
    }

    private void cleanState(SessionState state) {
        if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
            SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
            SiteService.cancelEdit(site);
        }
        state.removeAttribute(STATE_SITE_INSTANCE);
        state.removeAttribute(STATE_PROFILE);
        state.removeAttribute(STATE_SITE_INFO);
        state.removeAttribute("CTNG:site-type");
        state.removeAttribute("participantToAdd");
        state.removeAttribute(STATE_TOOL_REGISTRATION_SELECTED_LIST);
        state.removeAttribute(SELECTED_LIST);
        state.removeAttribute("termCourseSectionList");
        state.removeAttribute("umiacCourseSectionList");
        state.removeAttribute("manualCourseSectionList");
        state.removeAttribute(STATE_TERM_REQUEST);
        state.removeAttribute(STATE_SUBJECT_REQUEST);
        state.removeAttribute(STATE_COURSE_REQUEST);
        state.removeAttribute(STATE_SECTION_REQUEST);
        state.removeAttribute(STATE_SITE_TOOL_LIST);
        state.removeAttribute(STATE_TOOL_LIST);
        state.removeAttribute(STATE_FEATURE_LIST);
        state.removeAttribute(FEATURE_LIST);
    }

    private void buildInstructorSectionsList(SessionState state, ParameterParser params, Context context) {
        int term;
        Vector umiacCourseSectionList = (Vector)state.getAttribute("umiacCourseSectionList");
        Vector<CourseListItem> termCourseSectionList = new Vector<CourseListItem>();
        Profile profile = (Profile)state.getAttribute(STATE_PROFILE);
        SiteInfo siteInfo = (SiteInfo)state.getAttribute(STATE_SITE_INFO);
        String form_title = siteInfo.title;
        String form_description = siteInfo.description;
        Integer form_term = new Integer(siteInfo.term);
        Integer form_reuse = new Integer(siteInfo.reuse);
        CourseListItem item = new CourseListItem();
        CourseListItem cli = new CourseListItem();
        boolean add = true;
        String umiac_uniqname = NULL_STRING;
        umiac_uniqname = UsageSessionService.getSessionUser().getId();
        String umiac_year = NULL_STRING;
        String umiac_term = NULL_STRING;
        boolean term_changed = false;
        int termInState = Integer.parseInt((String)state.getAttribute(STATE_TERM_SELECTED));
        if (params.getString("selectTerm") == null) {
            term = termInState;
        } else {
            term = Integer.parseInt(params.getString("selectTerm"));
            term_changed = term != termInState;
            state.setAttribute(STATE_TERM_SELECTED, (Object)params.getString("selectTerm"));
        }
        state.setAttribute(STATE_TERM_REQUEST, (Object)Integer.toString(term));
        int template_index = Integer.parseInt((String)state.getAttribute(STATE_TEMPLATE_INDEX));
        if (term_changed) {
            Vector umiacListCleared = (Vector)state.getAttribute("umiacCourseSectionList");
            Vector manualListCleared = (Vector)state.getAttribute("manualCourseSectionList");
            if (umiacListCleared != null && template_index == 3) {
                umiacListCleared.clear();
                state.setAttribute("umiacCourseSectionList", (Object)umiacListCleared);
            }
            if (manualListCleared != null && template_index == 3) {
                manualListCleared.clear();
                state.setAttribute("manualCourseSectionList", (Object)manualListCleared);
            }
            state.setAttribute(STATE_TERM_SELECTED, (Object)Integer.toString(term));
        }
        switch (term) {
            case 0: {
                umiac_term = "2";
                umiac_year = "2003";
                break;
            }
            case 1: {
                umiac_term = "3";
                umiac_year = "2004";
                break;
            }
            case 2: {
                umiac_term = "4";
                umiac_year = "2004";
                break;
            }
            case 3: {
                umiac_term = "5";
                umiac_year = "2004";
                break;
            }
            case 4: {
                umiac_term = "1";
                umiac_year = "2004";
                break;
            }
            case 5: {
                umiac_term = "2";
                umiac_year = "2004";
            }
        }
        try {
            ListIterator i = this.umiacClient.getInstructorSections(umiac_uniqname, umiac_year, umiac_term).listIterator();
            while (i.hasNext()) {
                String[] res = (String[])i.next();
                item = this.buildCourseListItem(res);
                add = true;
                int j = 0;
                while (j < umiacCourseSectionList.size()) {
                    cli = (CourseListItem)umiacCourseSectionList.get(j);
                    if (cli.getKey().equals(item.getKey())) {
                        add = false;
                    }
                    ++j;
                }
                if (!add) continue;
                termCourseSectionList.add(item);
            }
        }
        catch (IdUnusedException ignore) {
            termCourseSectionList.clear();
        }
        context.put("termCourseSectionList", termCourseSectionList);
        state.setAttribute("termCourseSectionList", termCourseSectionList);
        siteInfo.term = term;
        state.setAttribute(STATE_SITE_INFO, (Object)siteInfo);
        this.updateSiteInfo(params, state);
        form_term = new Integer(term);
        this.termList = (Vector)state.getAttribute(TERM_LIST);
        context.put("umiacCourseSectionList", state.getAttribute("umiacCourseSectionList"));
        context.put("manualCourseSectionList", state.getAttribute("manualCourseSectionList"));
        context.put(FORM_TERM, form_term);
        context.put(TERM_LIST, this.termList);
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        String template = null;
        context.put("action", CONTEXT_ACTION);
        this.updatePortlet(state, portlet, data);
        if (state.getAttribute(STATE_INITIALIZED) == null) {
            this.init(portlet, data, state);
        }
        int index = Integer.valueOf((String)state.getAttribute(STATE_TEMPLATE_INDEX));
        template = this.buildContextForTemplate(index, portlet, context, data, state);
        return template;
    }

    private String buildContextForTemplate(int index, VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        String site_type = NULL_STRING;
        ParameterParser params = data.getParameters();
        Profile profile = (Profile)state.getAttribute(STATE_PROFILE);
        SiteInfo siteInfo = (SiteInfo)state.getAttribute(STATE_SITE_INFO);
        Vector umiacCourseSectionList = (Vector)state.getAttribute("umiacCourseSectionList");
        Vector currentTermSitesList = (Vector)state.getAttribute(STATE_CURRENT_TERM_SITES_LIST);
        Vector unpublishedSitesList = (Vector)state.getAttribute(STATE_UNPUBLISHED_SITES_LIST);
        Vector publishedSitesList = (Vector)state.getAttribute(STATE_PUBLISHED_SITES_LIST);
        Vector requestedSitesList = (Vector)state.getAttribute(STATE_REQUESTED_SITES_LIST);
        Vector otherSitesList = (Vector)state.getAttribute(STATE_OTHER_SITES_LIST);
        Vector affiliationList = (Vector)state.getAttribute(AFFILIATION_LIST);
        Vector honorificList = (Vector)state.getAttribute(HONORIFIC_LIST);
        Vector termList = (Vector)state.getAttribute(TERM_LIST);
        Vector subjectList = (Vector)state.getAttribute(SUBJECT_LIST);
        Vector courseList = (Vector)state.getAttribute(COURSE_LIST);
        Vector sectionList = (Vector)state.getAttribute(SECTION_LIST);
        List participantList = new Vector();
        List roles = new Vector();
        switch (index) {
            case 0: {
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
                    SiteService.cancelEdit(site);
                }
                context.put(STATE_UNPUBLISHED_SITES_LIST, unpublishedSitesList);
                context.put(STATE_PUBLISHED_SITES_LIST, publishedSitesList);
                context.put(STATE_REQUESTED_SITES_LIST, requestedSitesList);
                context.put("current_term", "Fall 2003");
                Menu bar = new Menu((Portlet)portlet, data, (String)state.getAttribute(STATE_ACTION));
                bar.add(new MenuEntry("New Site...", "doNew_site"));
                context.put("menu", bar);
                Menu bar_published = new Menu((Portlet)portlet, data, (String)state.getAttribute(STATE_ACTION));
                bar_published.add(new MenuEntry("Revise", null, true, 0, "doGet_site", "publishedSitesForm"));
                bar_published.add(new MenuEntry("Delete", null, true, 0, "doMenu_site_delete", "publishedSitesForm"));
                bar_published.add(new MenuEntry("Unpublish", null, true, 0, "doMenu_site_unpublish", "publishedSitesForm"));
                context.put("published_menu", bar_published);
                Menu bar_unpublished = new Menu((Portlet)portlet, data, (String)state.getAttribute(STATE_ACTION));
                bar_unpublished.add(new MenuEntry("Revise", null, true, 0, "doGet_site", "unpublishedSitesForm"));
                bar_unpublished.add(new MenuEntry("Delete", null, true, 0, "doMenu_site_delete", "unpublishedSitesForm"));
                bar_unpublished.add(new MenuEntry("Publish", null, true, 0, "doMenu_site_publish", "unpublishedSitesForm"));
                context.put("unpublished_menu", bar_unpublished);
                return (String)this.getContext(data).get("template") + TEMPLATE[0];
            }
            case 1: {
                context.put("form_type", siteInfo.site_type);
                return (String)this.getContext(data).get("template") + TEMPLATE[1];
            }
            case 2: {
                return (String)this.getContext(data).get("template") + TEMPLATE[2];
            }
            case 3: {
                this.buildInstructorSectionsList(state, params, context);
                context.put(FORM_SUBJECT, siteInfo.subject);
                context.put(FORM_COURSE, siteInfo.course);
                context.put(FORM_SECTION, siteInfo.sections);
                context.put(FORM_TITLE, siteInfo.title);
                context.put(FORM_DESCRIPTION, siteInfo.description);
                return (String)this.getContext(data).get("template") + TEMPLATE[3];
            }
            case 4: {
                this.toolRegistrationList = (Vector)state.getAttribute(STATE_COURSE_TOOL_LIST);
                this.toolRegistrationSelectedList = (Vector)state.getAttribute(STATE_TOOL_REGISTRATION_SELECTED_LIST);
                context.put(STATE_TOOL_REGISTRATION_SELECTED_LIST, this.toolRegistrationSelectedList);
                context.put(STATE_TOOL_REGISTRATION_LIST, this.toolRegistrationList);
                return (String)this.getContext(data).get("template") + TEMPLATE[4];
            }
            case 5: {
                return (String)this.getContext(data).get("template") + TEMPLATE[5];
            }
            case 6: {
                return (String)this.getContext(data).get("template") + TEMPLATE[6];
            }
            case 7: {
                return (String)this.getContext(data).get("template") + TEMPLATE[7];
            }
            case 8: {
                return (String)this.getContext(data).get("template") + TEMPLATE[8];
            }
            case 9: {
                context.put(TERM_LIST, termList);
                context.put(FORM_TERM, Integer.toString(siteInfo.term));
                context.put(FORM_TITLE, siteInfo.title);
                context.put(FORM_DESCRIPTION, siteInfo.description);
                return (String)this.getContext(data).get("template") + TEMPLATE[9];
            }
            case 10: {
                this.toolRegistrationList = (Vector)state.getAttribute(STATE_PROJECT_TOOL_LIST);
                this.toolRegistrationSelectedList = (Vector)state.getAttribute(STATE_TOOL_REGISTRATION_SELECTED_LIST);
                context.put(STATE_TOOL_REGISTRATION_SELECTED_LIST, this.toolRegistrationSelectedList);
                context.put(STATE_TOOL_REGISTRATION_LIST, this.toolRegistrationList);
                return (String)this.getContext(data).get("template") + TEMPLATE[10];
            }
            case 11: {
                return (String)this.getContext(data).get("template") + TEMPLATE[11];
            }
            case 12: {
                return (String)this.getContext(data).get("template") + TEMPLATE[12];
            }
            case 13: {
                return (String)this.getContext(data).get("template") + TEMPLATE[13];
            }
            case 14: {
                return (String)this.getContext(data).get("template") + TEMPLATE[14];
            }
            case 15: {
                Menu back_bar = new Menu((Portlet)portlet, data, (String)state.getAttribute(STATE_ACTION));
                back_bar.add(new MenuEntry("Back to list...", "doBack_to_list"));
                context.put("menu", back_bar);
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    site_type = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getProperties().getProperty("CTNG:site-type");
                }
                if (site_type.equals(SITE_TYPE_COURSE)) {
                    context.put("classFlag", Boolean.TRUE.toString());
                } else {
                    context.put("classFlag", Boolean.FALSE.toString());
                }
                return (String)this.getContext(data).get("template") + TEMPLATE[15];
            }
            case 16: {
                context.put(FORM_TITLE, siteInfo.title);
                context.put(FORM_DESCRIPTION, siteInfo.description);
                context.put("form_infoUrl", siteInfo.infoUrl);
                return (String)this.getContext(data).get("template") + TEMPLATE[16];
            }
            case 17: {
                Menu section_menu = new Menu((Portlet)portlet, data, (String)state.getAttribute(STATE_ACTION));
                section_menu.add(new MenuEntry("Add", null, true, 0, "doMenu_section_add", "sectionAccessForm"));
                section_menu.add(new MenuEntry("Delete", null, true, 0, "doMenu_section_delete", "sectionAccessForm"));
                context.put("section_menu", section_menu);
                return (String)this.getContext(data).get("template") + TEMPLATE[17];
            }
            case 18: {
                this.buildInstructorSectionsList(state, params, context);
                umiacCourseSectionList = (Vector)state.getAttribute("umiacCourseSectionList");
                if (umiacCourseSectionList.size() != 0) {
                    context.put("remove_button", Boolean.TRUE.toString());
                }
                context.put("umiacCourseSectionList", umiacCourseSectionList);
                return (String)this.getContext(data).get("template") + TEMPLATE[18];
            }
            case 19: {
                return (String)this.getContext(data).get("template") + TEMPLATE[19];
            }
            case 20: {
                return (String)this.getContext(data).get("template") + TEMPLATE[20];
            }
            case 21: {
                boolean workshop_site;
                List pageList = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getPages();
                if (pageList != null && pageList.size() != 0) {
                    ListIterator i = pageList.listIterator();
                    while (i.hasNext()) {
                        SitePage page = (SitePage)i.next();
                        if (!page.getTitle().equals("Home")) continue;
                        context.put("check_home", Boolean.TRUE.toString());
                    }
                }
                if (state.getAttribute(STATE_TOOL_REGISTRATION_SELECTED_LIST) != NULL_STRING) {
                    this.toolRegistrationSelectedList = (Vector)state.getAttribute(STATE_TOOL_REGISTRATION_SELECTED_LIST);
                    context.put(STATE_TOOL_REGISTRATION_SELECTED_LIST, this.toolRegistrationSelectedList);
                }
                boolean course_site = ((String)state.getAttribute("CTNG:site-type")).equals(SITE_TYPE_COURSE);
                boolean project_site = ((String)state.getAttribute("CTNG:site-type")).equals(SITE_TYPE_PROJECT);
                boolean dissertation_site = ((String)state.getAttribute("CTNG:site-type")).equals(SITE_TYPE_DISSERTATION);
                boolean bl = workshop_site = ((String)state.getAttribute("CTNG:site-type")).equals(SITE_TYPE_WORKSHOP);
                if (course_site) {
                    this.toolRegistrationList = (Vector)state.getAttribute(STATE_COURSE_TOOL_LIST);
                    context.put("course_site", Boolean.TRUE.toString());
                } else if (project_site) {
                    this.toolRegistrationList = (Vector)state.getAttribute(STATE_PROJECT_TOOL_LIST);
                } else if (dissertation_site) {
                    this.toolRegistrationList = (Vector)state.getAttribute(STATE_DISSERTATION_TOOL_LIST);
                } else if (workshop_site) {
                    this.toolRegistrationList = (Vector)state.getAttribute(STATE_WORKSHOP_TOOL_LIST);
                } else {
                    Log.warn("chef", "SiteAction.buildContextForTemplate, case 21: - unknown STATE_SITE_TYPE");
                }
                context.put(STATE_TOOL_REGISTRATION_LIST, this.toolRegistrationList);
                return (String)this.getContext(data).get("template") + TEMPLATE[21];
            }
            case 22: {
                Vector skins = (Vector)state.getAttribute("skins");
                context.put("form_css", siteInfo.skin);
                context.put("skins", skins);
                context.put("form_iconUrl", siteInfo.iconUrl);
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    site_type = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getProperties().getProperty("CTNG:site-type");
                }
                if (site_type.equals(SITE_TYPE_COURSE)) {
                    context.put("course_site", Boolean.TRUE.toString());
                }
                return (String)this.getContext(data).get("template") + TEMPLATE[22];
            }
            case 23: {
                return (String)this.getContext(data).get("template") + TEMPLATE[23];
            }
            case 24: {
                return (String)this.getContext(data).get("template") + TEMPLATE[24];
            }
            case 25: {
                Menu backToList = new Menu((Portlet)portlet, data, (String)state.getAttribute(STATE_ACTION));
                backToList.add(new MenuEntry("Back to customize...", "doMenu_customize"));
                context.put("menu", backToList);
                Vector<Student> studentList = new Vector<Student>();
                int i = 0;
                while (i < umiacCourseSectionList.size()) {
                    CourseListItem listItem = new CourseListItem();
                    listItem.year = ((CourseListItem)umiacCourseSectionList.get(i)).getYear();
                    listItem.term_code = ((CourseListItem)umiacCourseSectionList.get(i)).getTerm_code();
                    listItem.campus_code = ((CourseListItem)umiacCourseSectionList.get(i)).getCampus_code();
                    listItem.subject = ((CourseListItem)umiacCourseSectionList.get(i)).getSubject();
                    listItem.catalog_nbr = ((CourseListItem)umiacCourseSectionList.get(i)).getCatalog_nbr();
                    listItem.class_section = ((CourseListItem)umiacCourseSectionList.get(i)).getClass_section();
                    List roster = this.getRoster(state, listItem.year, listItem.term_code, listItem.campus_code, listItem.subject, listItem.catalog_nbr, listItem.class_section);
                    ListIterator j = roster.listIterator();
                    while (j.hasNext()) {
                        Student student = (Student)j.next();
                        studentList.add(student);
                    }
                    ++i;
                }
                participantList = this.getParticipantList(state);
                context.put("participantList", participantList);
                context.put("studentList", studentList);
                return (String)this.getContext(data).get("template") + TEMPLATE[25];
            }
            case 26: {
                return (String)this.getContext(data).get("template") + TEMPLATE[26];
            }
            case 27: {
                Menu participant_bar = new Menu((Portlet)portlet, data, (String)state.getAttribute(STATE_ACTION));
                participant_bar.add(new MenuEntry("Add Participant...", "doMenu_add_participant"));
                participant_bar.add(new MenuEntry("Change Roles...", "doMenu_change_roles"));
                participant_bar.add(new MenuEntry("Back to customize...", "doMenu_customize"));
                context.put("menu", participant_bar);
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    site_type = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getProperties().getProperty("CTNG:site-type");
                }
                if (site_type.equals(SITE_TYPE_COURSE)) {
                    context.put("course_site", Boolean.TRUE.toString());
                }
                participantList = this.getParticipantList(state);
                context.put("participantList", participantList);
                context.put("participantSelectedList", state.getAttribute("participantSelectedList"));
                return (String)this.getContext(data).get("template") + TEMPLATE[27];
            }
            case 28: {
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    site_type = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getProperties().getProperty("CTNG:site-type");
                }
                if (site_type.equals(SITE_TYPE_COURSE)) {
                    context.put("course_site", Boolean.TRUE.toString());
                }
                roles = this.getRoles(state);
                context.put("roles", roles);
                Participant form_participantToAdd = (Participant)state.getAttribute("form_participantToAdd");
                context.put("form_participantToAdd", form_participantToAdd);
                return (String)this.getContext(data).get("template") + TEMPLATE[28];
            }
            case 29: {
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    site_type = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getProperties().getProperty("CTNG:site-type");
                }
                if (site_type.equals(SITE_TYPE_COURSE)) {
                    context.put("course_site", Boolean.TRUE.toString());
                }
                participantList = this.getParticipantList(state);
                context.put("participantList", participantList);
                return (String)this.getContext(data).get("template") + TEMPLATE[29];
            }
            case 30: {
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    site_type = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getProperties().getProperty("CTNG:site-type");
                }
                if (site_type.equals(SITE_TYPE_COURSE)) {
                    context.put("course_site", Boolean.TRUE.toString());
                }
                roles = this.getRoles(state);
                context.put("roles", roles);
                participantList = this.getParticipantList(state);
                context.put("participantList", participantList);
                return (String)this.getContext(data).get("template") + TEMPLATE[30];
            }
            case 31: {
                String[] removals = (String[])state.getAttribute(STATE_SITE_REMOVALS);
                Vector<Site> remove = new Vector<Site>();
                state.removeAttribute(STATE_SITE_REMOVALS);
                if (removals != null && removals.length != 0) {
                    int i = 0;
                    while (i < removals.length) {
                        String id = removals[i];
                        if (SiteService.allowRemoveSite(id)) {
                            try {
                                Site site = SiteService.getSite(id);
                                remove.add(site);
                            }
                            catch (IdUnusedException e) {
                                Log.warn("chef", "SiteAction.buildContextForTemplate, case 31: IdUnusedException");
                            }
                        }
                        ++i;
                    }
                    context.put("removals", remove);
                    return (String)this.getContext(data).get("template") + TEMPLATE[31];
                }
            }
            case 32: {
                roles = this.getRoles(state);
                context.put("roles", roles);
                context.put("form_joinable", new Boolean(siteInfo.joinable));
                context.put("form_joinerRole", siteInfo.joinerRole);
                return (String)this.getContext(data).get("template") + TEMPLATE[32];
            }
        }
        return (String)this.getContext(data).get("template") + TEMPLATE[0];
    }

    private List buildSectionsFromRealm(String id) {
        Vector<CourseListItem> rv = new Vector<CourseListItem>();
        if (id != null) {
            String course_part = NULL_STRING;
            String section_part = NULL_STRING;
            String key = NULL_STRING;
            CourseListItem cli = new CourseListItem();
            int format = id.indexOf("+") != -1 ? 0 : (id.indexOf("[") != -1 ? 1 : 2);
            switch (format) {
                case 0: {
                    String[] courses = id.split("\\+");
                    int i = 0;
                    while (i < courses.length) {
                        if (courses[i].indexOf("[") == -1) {
                            cli = this.keyToCourseListItem(courses[i]);
                            rv.add(cli);
                        } else {
                            course_part = id.substring(0, id.indexOf("["));
                            section_part = id.substring(id.indexOf("[") + 1, id.indexOf("]"));
                            String[] sect = section_part.split(",");
                            int j = 0;
                            while (j < sect.length) {
                                key = course_part + sect[j];
                                cli = this.keyToCourseListItem(key);
                                rv.add(cli);
                                ++i;
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case 1: {
                    course_part = id.substring(0, id.indexOf("["));
                    section_part = id.substring(id.indexOf("[") + 1, id.indexOf("]"));
                    String[] sec = section_part.split(",");
                    int i = 0;
                    while (i < sec.length) {
                        key = course_part + sec[i];
                        cli = this.keyToCourseListItem(key);
                        rv.add(cli);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    cli = this.keyToCourseListItem(id);
                    rv.add(cli);
                }
            }
        }
        return rv;
    }

    private CourseListItem keyToCourseListItem(String key) {
        CourseListItem cli = new CourseListItem();
        String[] res = key.split(",");
        cli.key = key;
        cli.year = res[0];
        cli.term_code = res[1];
        cli.campus_code = res[2];
        cli.subject = res[3];
        cli.catalog_nbr = res[4];
        cli.title = NULL_STRING;
        cli.url = NULL_STRING;
        cli.class_section = res[5];
        cli.role = NULL_STRING;
        cli.subrole = NULL_STRING;
        cli.crosslist = NULL_STRING;
        return cli;
    }

    private String buildExternalRealm(SessionState state, List sectionList) {
        String id = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
        String realm = "/site/" + id;
        if (!RealmService.allowUpdateRealm(realm)) {
            this.addAlert(state, "You do not have permission to link to course roster(s).");
            return null;
        }
        if (!((String)state.getAttribute("CTNG:site-type")).equals(SITE_TYPE_COURSE)) {
            Log.warn("chef", "SiteAction.buildExternalRealm, STATE_SITE_TYPE NE SITE_TYPE_COURSE");
            return null;
        }
        boolean same_course = true;
        if (sectionList.size() == 0) {
            return null;
        }
        if (sectionList.size() == 1) {
            return ((CourseListItem)sectionList.get(0)).getKey();
        }
        String full_key = ((CourseListItem)sectionList.get(0)).getKey();
        String course = full_key.substring(0, full_key.lastIndexOf(","));
        same_course = true;
        ListIterator i = sectionList.listIterator();
        while (i.hasNext()) {
            CourseListItem item = (CourseListItem)i.next();
            if (item.getKey().indexOf(course) != -1) continue;
            same_course = false;
        }
        if (same_course) {
            StringBuffer sections = new StringBuffer();
            sections.append(course);
            sections.append(",[");
            boolean first_section = true;
            ListIterator i2 = sectionList.listIterator();
            while (i2.hasNext()) {
                CourseListItem item = (CourseListItem)i2.next();
                String section = new String();
                section = first_section ? item.key.substring(item.key.lastIndexOf(",") + 1, item.key.length()) : item.key.substring(item.key.lastIndexOf(","), item.key.length());
                first_section = false;
                sections.append(section);
            }
            sections.append("]");
            return sections.toString();
        }
        Vector<String> keys = new Vector<String>();
        int i3 = 0;
        while (i3 < sectionList.size()) {
            CourseListItem item = (CourseListItem)sectionList.get(i3);
            keys.add(item.getKey());
            ++i3;
        }
        Collections.sort(keys);
        StringBuffer buf = new StringBuffer();
        StringBuffer section_buf = new StringBuffer();
        String last_course = null;
        String last_section = null;
        String to_buf = null;
        int plus = 43;
        boolean add_course = true;
        int i4 = 0;
        while (i4 < keys.size()) {
            String this_key = (String)keys.get(i4);
            String this_course = this_key.substring(0, this_key.lastIndexOf(","));
            String this_section = this_key.substring(this_key.lastIndexOf(","), this_key.length());
            last_course = this_course;
            if (i4 != 0) {
                String previous_key = (String)keys.get(i4 - 1);
                String previous_course = previous_key.substring(0, previous_key.lastIndexOf(","));
                String previous_section = previous_key.substring(previous_key.lastIndexOf(","), previous_key.length());
                if (previous_course.equals(this_course)) {
                    same_course = true;
                    section_buf.append(previous_section);
                } else {
                    same_course = false;
                    buf.append(previous_course);
                    section_buf.append(previous_section);
                    if (section_buf.lastIndexOf(",") == 0) {
                        to_buf = section_buf.toString();
                        buf.append(to_buf);
                    } else {
                        buf.append(",[");
                        to_buf = section_buf.toString();
                        buf.append(to_buf.substring(1));
                        buf.append("]");
                    }
                    section_buf.setLength(0);
                    buf.append("+");
                }
                last_section = this_section;
            }
            ++i4;
        }
        if (same_course) {
            buf.append(last_section);
            buf.append("]");
        } else {
            buf.append(last_course + last_section);
        }
        return buf.toString();
    }

    private String buildCourseSiteLabel(Vector sectionList) {
        return "awaiting further definition";
    }

    public void doNew_site(RunData data) throws Exception {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"1");
    }

    public void doMenu_site_delete(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        if (params.getStrings("selectedMembers") == null) {
            this.addAlert(state, NO_SITE_SELECTED_STRING);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
            return;
        }
        String[] removals = params.getStrings("selectedMembers");
        state.setAttribute(STATE_SITE_REMOVALS, (Object)removals);
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"31");
    }

    public void doSite_delete_confirmed(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        if (params.getStrings("selectedMembers") == null) {
            Log.warn("chef", "SiteAction.doSite_delete_confirmed selectedMembers null");
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
            return;
        }
        ArrayList<String> chosenList = new ArrayList<String>(Arrays.asList(params.getStrings("selectedMembers")));
        if (!chosenList.isEmpty()) {
            ListIterator i = chosenList.listIterator();
            while (i.hasNext()) {
                try {
                    String id = (String)i.next();
                    if (!SiteService.allowRemoveSite(id)) continue;
                    try {
                        SiteEdit site = SiteService.editSite(id);
                        SiteService.removeSite(site);
                        SiteService.commitEdit(site);
                    }
                    catch (IdUnusedException e) {
                        this.addAlert(state, "the requested site(s) could not be located. Please contact Course Tools NG Support.");
                        Log.warn("chef", "SiteAction.doMenu_site_delete - IdUnusedException " + id);
                        return;
                    }
                    catch (PermissionException e) {
                        this.addAlert(state, "You do not have permission to delete site(s).");
                        Log.warn("chef", "SiteAction.doMenu_site_delete -  PermissionException " + id);
                        return;
                    }
                }
                catch (InUseException e) {
                    this.addAlert(state, "Site(s) in use and could not be deleted.");
                    Log.warn("chef", "SiteAction.doMenu_site_delete -  InUseException ");
                    return;
                }
            }
        }
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
        this.actionForTemplate("continue", 0, params, state);
    }

    public void doGet_site(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        if (params.getStrings("selectedMembers") == null) {
            this.addAlert(state, NO_SITE_SELECTED_STRING);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
            return;
        }
        ArrayList<String> chosenList = new ArrayList<String>(Arrays.asList(params.getStrings("selectedMembers")));
        if (!chosenList.isEmpty()) {
            if (chosenList.size() != 1) {
                this.addAlert(state, MORE_THAN_ONE_SITE_SELECTED_STRING);
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
                return;
            }
            try {
                this.cleanState(state);
                SiteEdit site = SiteService.editSite((String)chosenList.get(0));
                state.setAttribute(STATE_SITE_INSTANCE, (Object)site);
                this.sitePropertiesIntoState(state);
                this.siteToolsIntoState(state);
                List umiacCourseSectionList = this.buildSectionsFromRealm(this.getExternalRealmId(state));
                state.setAttribute("umiacCourseSectionList", (Object)umiacCourseSectionList);
            }
            catch (IdUnusedException e) {
                Log.warn("chef", "SiteAction.doGet_site-IdUnusedException " + (String)chosenList.get(0));
            }
            catch (PermissionException e) {
                Log.warn("chef", "SiteAction.doGet_site -  PermissionException " + (String)chosenList.get(0));
            }
            catch (InUseException e) {
                Log.warn("chef", "SiteAction.doGet_site - InUseException " + (String)chosenList.get(0));
            }
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"15");
        }
    }

    public void doMenu_site_reuse(RunData data) throws Exception {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"1");
    }

    public void doMenu_site_revise(RunData data) throws Exception {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"1");
    }

    public void doView(RunData data) throws Exception {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"1");
    }

    public void doSite_type(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Profile profile = new Profile();
        SiteInfo siteInfo = new SiteInfo();
        state.setAttribute(STATE_PROFILE, (Object)profile);
        state.setAttribute(STATE_SITE_INFO, (Object)siteInfo);
        state.removeAttribute(STATE_TOOL_REGISTRATION_SELECTED_LIST);
        ParameterParser params = data.getParameters();
        if (params.getString("itemType").equals("class")) {
            state.setAttribute("CTNG:site-type", (Object)SITE_TYPE_COURSE);
            Vector umiacCourseSectionList = new Vector();
            Vector manualCourseSectionList = new Vector();
            state.removeAttribute("termCourseSectionList");
            state.setAttribute("umiacCourseSectionList", umiacCourseSectionList);
            state.setAttribute("manualCourseSectionList", manualCourseSectionList);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"3");
        } else if (params.getString("itemType").equals("diss")) {
            state.setAttribute("CTNG:site-type", (Object)SITE_TYPE_DISSERTATION);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"6");
        } else if (params.getString("itemType").equals("project")) {
            state.setAttribute("CTNG:site-type", (Object)SITE_TYPE_PROJECT);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"9");
        }
        int index = Integer.valueOf(params.getString("template-index"));
        this.actionForTemplate("continue", index, params, state);
    }

    public void doContinue(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("continue"));
        int index = Integer.valueOf(params.getString("template-index"));
        String navigation = "continue";
        this.actionForTemplate(navigation, index, params, state);
    }

    public void doBack(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("back"));
        int index = Integer.valueOf(params.getString("template-index"));
        String navigation = "back";
        this.actionForTemplate(navigation, index, params, state);
    }

    public void doFinish(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        this.getFeatures(params, state);
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("continue"));
        int index = Integer.valueOf(params.getString("template-index"));
        this.actionForTemplate("continue", index, params, state);
        this.updateSiteAttributes(state);
        this.commitSite(state, 1);
        this.siteToolsIntoState(state);
        if (((String)state.getAttribute("CTNG:site-type")).equals(SITE_TYPE_COURSE)) {
            this.finishCourseSite(state, params);
        }
        this.actionForTemplate("continue", 0, params, state);
    }

    public void doCancel(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("back"));
    }

    public void doMenu_customize(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"15");
    }

    public void doBack_to_list(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
            try {
                SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
                SiteService.cancelEdit(site);
            }
            catch (ClassCastException ignore) {
                Log.warn("chef", "SiteAction.doCancel no site in state");
            }
        }
        this.cleanState(state);
        this.setupFormNamesAndConstants(state);
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
        this.actionForTemplate("continue", 0, params, state);
    }

    public void doMenu_site_publish(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        if (params.getStrings("selectedMembers") == null) {
            this.addAlert(state, NO_SITE_SELECTED_STRING);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
            return;
        }
        ArrayList<String> chosenList = new ArrayList<String>(Arrays.asList(params.getStrings("selectedMembers")));
        if (!chosenList.isEmpty()) {
            ListIterator i = chosenList.listIterator();
            while (i.hasNext()) {
                try {
                    this.cleanState(state);
                    SiteEdit site = SiteService.editSite((String)i.next());
                    state.setAttribute(STATE_SITE_INSTANCE, (Object)site);
                    this.sitePropertiesIntoState(state);
                    if (site.getProperties().getProperty("CTNG:site-type").equals(SITE_TYPE_COURSE)) {
                        String providerRealmId = this.getExternalRealmId(state);
                        if (providerRealmId == null || providerRealmId.length() == 0) {
                            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
                            this.commitSite(state);
                            return;
                        }
                        this.commitSite(state, 2);
                        continue;
                    }
                    this.commitSite(state, 2);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", "SiteAction.doMenu_site_publish -  IdUnusedException " + (String)i.next());
                }
                catch (PermissionException e) {
                    Log.warn("chef", "SiteAction.doMenu_site_publish -  PermissionException " + (String)i.next());
                }
                catch (InUseException e) {
                    Log.warn("chef", "SiteAction.doMenu_site_publish - InUseException " + (String)i.next());
                }
            }
        }
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
        this.actionForTemplate("continue", 0, params, state);
    }

    public void doMenu_site_unpublish(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        if (params.getStrings("selectedMembers") == null) {
            this.addAlert(state, NO_SITE_SELECTED_STRING);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
            return;
        }
        ArrayList<String> chosenList = new ArrayList<String>(Arrays.asList(params.getStrings("selectedMembers")));
        if (!chosenList.isEmpty()) {
            ListIterator i = chosenList.listIterator();
            while (i.hasNext()) {
                try {
                    this.cleanState(state);
                    SiteEdit site = SiteService.editSite((String)i.next());
                    state.setAttribute(STATE_SITE_INSTANCE, (Object)site);
                    this.sitePropertiesIntoState(state);
                    this.commitSite(state, 1);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", "SiteAction.doMenu_site_unpublish -  IdUnusedException " + (String)i.next());
                }
                catch (PermissionException e) {
                    Log.warn("chef", "SiteAction.doMenu_site_unpublish - PermissionException " + (String)i.next());
                }
                catch (InUseException e) {
                    Log.warn("chef", "SiteAction.doMenu_site_unpublish - InUseException " + (String)i.next());
                }
            }
        }
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
        this.actionForTemplate("continue", 0, params, state);
    }

    public void doAdd_custom_link(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        if (params.getString("name") == null || params.getString("url") == null) {
            ToolRegistration tr = ServerConfigurationService.getToolRegistration("chef.iframe");
            String toolRegId = tr.getId();
            SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
            SitePageEdit page = site.addPage();
            page.setTitle(params.getString("name"));
            ToolConfigurationEdit tool = page.addTool();
            tool.setToolId(toolRegId);
            tool.setTitle(params.getString("name"));
            ResourceProperties rp = tr.getDefaultConfiguration();
            ResourcePropertiesEdit rpe = tool.getPropertiesEdit();
            rpe.addAll(rp);
            this.commitSite(state);
        } else {
            this.addAlert(state, "Required field(s) missing. Please enter all required fields.");
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
        }
    }

    public void doAdd_remove_features(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
        this.getFeatures(params, state);
        int index = Integer.valueOf(params.getString("template-index"));
        this.actionForTemplate("continue", index, params, state);
        int status = site.getStatus();
        this.commitSite(state, status);
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("continue"));
    }

    public void doMenu_add_participant(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"28");
    }

    public void doMenu_remove_participant(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"29");
    }

    public void doMenu_change_roles(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"30");
    }

    public void doAdd_course_section(RunData data) {
        try {
            boolean adds;
            boolean manual_selection;
            SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
            ParameterParser params = data.getParameters();
            String form_term = params.getString("term");
            String form_subject = params.getString("subject");
            String form_course = params.getString("course");
            String form_section = params.getString("section");
            String title = params.getString("title");
            Vector termCourseSectionList = state.getAttribute("termCourseSectionList") == null ? new Vector() : (Vector)state.getAttribute("termCourseSectionList");
            Vector umiacCourseSectionList = state.getAttribute("umiacCourseSectionList") == null ? new Vector() : (Vector)state.getAttribute("umiacCourseSectionList");
            Vector manualCourseSectionList = state.getAttribute("manualCourseSectionList") == null ? new Vector() : (Vector)state.getAttribute("manualCourseSectionList");
            AbstractList umiacChosenList = new Vector();
            if (params.getStrings("umiacAdds") != null) {
                umiacChosenList = new ArrayList<String>(Arrays.asList(params.getStrings("umiacAdds")));
            }
            boolean has_subject = form_subject.trim().length() != 0;
            boolean has_course = form_course.trim().length() != 0;
            boolean has_section = form_section.trim().length() != 0;
            boolean bl = manual_selection = has_subject && has_course && has_section;
            if (!(!has_subject && !has_course && !has_section || has_subject && has_course && has_section)) {
                this.addAlert(state, "A required field is missing. Please fill in all required fields.");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
                return;
            }
            if (title == null || title.trim().length() == 0) {
                this.addAlert(state, "Please provide a title.");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
                return;
            }
            if (!SiteService.allowAddSite(title)) {
                this.addAlert(state, "You do not have permission to add " + title + ".");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
                return;
            }
            if (!(umiacChosenList != null && umiacChosenList.size() != 0 || manual_selection)) {
                this.addAlert(state, "Please choose or enter course and section, then click Continue. ");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
                return;
            }
            if (umiacChosenList.size() != 0 && (has_subject || has_course || has_section)) {
                this.addAlert(state, "Please choose from the list or fill out the form, but not both.");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
                return;
            }
            if (manual_selection) {
                if (umiacCourseSectionList != null) {
                    umiacCourseSectionList.clear();
                }
                state.setAttribute("umiacCourseSectionList", (Object)umiacCourseSectionList);
                CourseListItem cli_manual = new CourseListItem();
                cli_manual.year = "2003";
                cli_manual.term_code = "2";
                cli_manual.campus_code = "A";
                cli_manual.subject = form_subject;
                cli_manual.catalog_nbr = form_course;
                cli_manual.class_section = form_section;
                cli_manual.title = NULL_STRING;
                cli_manual.url = NULL_STRING;
                cli_manual.role = NULL_STRING;
                cli_manual.subrole = NULL_STRING;
                cli_manual.key = cli_manual.year + "," + cli_manual.term_code + "," + cli_manual.campus_code + "," + cli_manual.subject + "," + cli_manual.catalog_nbr + "," + cli_manual.class_section;
                manualCourseSectionList.add(cli_manual);
                state.setAttribute("manualCourseSectionList", (Object)manualCourseSectionList);
                state.setAttribute(STATE_COURSE_REQUEST, (Object)form_course);
                state.setAttribute(STATE_SUBJECT_REQUEST, (Object)form_subject);
                state.setAttribute(STATE_SECTION_REQUEST, (Object)form_section);
            }
            boolean bl2 = adds = params.getStrings("umiacAdds") != null;
            if (adds) {
                if (manualCourseSectionList != null) {
                    manualCourseSectionList.clear();
                }
                state.setAttribute("manualCourseSectionList", (Object)manualCourseSectionList);
                ListIterator i = umiacChosenList.listIterator();
                while (i.hasNext()) {
                    String umiacId = (String)i.next();
                    ListIterator j = termCourseSectionList.listIterator();
                    while (j.hasNext()) {
                        CourseListItem umiacCLI = (CourseListItem)j.next();
                        String termCourseSectionListId = umiacCLI.getKey();
                        if (!umiacId.equals(termCourseSectionListId)) continue;
                        umiacCourseSectionList.add(umiacCLI);
                    }
                }
            }
            this.updateSiteInfo(params, state);
            this.addNewSite(params, state);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("continue"));
            int index = Integer.valueOf(params.getString("template-index"));
            this.actionForTemplate("continue", index, params, state);
        }
        catch (Exception e) {
            Log.warn("chef", "SiteAction.doAdd_course_section Exception " + e.getMessage());
        }
    }

    public void doRevise_course_section(RunData data) {
        try {
            boolean adds;
            boolean manual_selection;
            SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
            ParameterParser params = data.getParameters();
            String form_term = params.getString("term");
            String form_subject = params.getString("subject");
            String form_course = params.getString("course");
            String form_section = params.getString("section");
            String title = params.getString("title");
            String calledFrom = params.getString("template-index");
            Vector termCourseSectionList = state.getAttribute("termCourseSectionList") == null ? new Vector() : (Vector)state.getAttribute("termCourseSectionList");
            Vector umiacCourseSectionList = state.getAttribute("umiacCourseSectionList") == null ? new Vector() : (Vector)state.getAttribute("umiacCourseSectionList");
            Vector manualCourseSectionList = state.getAttribute("manualCourseSectionList") == null ? new Vector() : (Vector)state.getAttribute("manualCourseSectionList");
            AbstractList umiacChosenList = new Vector();
            if (params.getStrings("umiacAdds") != null) {
                umiacChosenList = new ArrayList<String>(Arrays.asList(params.getStrings("umiacAdds")));
            }
            boolean has_subject = form_subject.trim().length() != 0;
            boolean has_course = form_course.trim().length() != 0;
            boolean has_section = form_section.trim().length() != 0;
            boolean bl = manual_selection = has_subject && has_course && has_section;
            if (!(!has_subject && !has_course && !has_section || has_subject && has_course && has_section)) {
                this.addAlert(state, "A required field is missing. Please fill in all required fields.");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
                return;
            }
            if (!SiteService.allowAddSite(title)) {
                this.addAlert(state, "You do not have permission to add " + title + ".");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
                return;
            }
            if (!(umiacChosenList != null && umiacChosenList.size() != 0 || manual_selection)) {
                this.addAlert(state, "Please choose or enter course and section, then click Continue. ");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
                return;
            }
            if (umiacChosenList.size() != 0 && (has_subject || has_course || has_section)) {
                this.addAlert(state, "Please choose from the list or fill out the form, but not both.");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
                return;
            }
            if (manual_selection) {
                if (umiacCourseSectionList != null) {
                    umiacCourseSectionList.clear();
                }
                state.setAttribute("umiacCourseSectionList", (Object)umiacCourseSectionList);
                CourseListItem cli_manual = new CourseListItem();
                cli_manual.year = "2003";
                cli_manual.term_code = "2";
                cli_manual.campus_code = "A";
                cli_manual.subject = form_subject;
                cli_manual.catalog_nbr = form_course;
                cli_manual.class_section = form_section;
                cli_manual.title = NULL_STRING;
                cli_manual.url = NULL_STRING;
                cli_manual.role = NULL_STRING;
                cli_manual.subrole = NULL_STRING;
                cli_manual.key = cli_manual.year + "," + cli_manual.term_code + "," + cli_manual.campus_code + "," + cli_manual.subject + "," + cli_manual.catalog_nbr + "," + cli_manual.class_section;
                manualCourseSectionList.add(cli_manual);
                state.setAttribute("manualCourseSectionList", (Object)manualCourseSectionList);
                state.setAttribute(STATE_COURSE_REQUEST, (Object)form_course);
                state.setAttribute(STATE_SUBJECT_REQUEST, (Object)form_subject);
                state.setAttribute(STATE_SECTION_REQUEST, (Object)form_section);
            }
            boolean bl2 = adds = params.getStrings("umiacAdds") != null;
            if (adds) {
                if (manualCourseSectionList != null) {
                    manualCourseSectionList.clear();
                }
                state.setAttribute("manualCourseSectionList", (Object)manualCourseSectionList);
                ListIterator i = umiacChosenList.listIterator();
                while (i.hasNext()) {
                    String umiacId = (String)i.next();
                    ListIterator j = termCourseSectionList.listIterator();
                    while (j.hasNext()) {
                        CourseListItem umiacCLI = (CourseListItem)j.next();
                        String termCourseSectionListId = umiacCLI.getKey();
                        if (!umiacId.equals(termCourseSectionListId)) continue;
                        umiacCourseSectionList.add(umiacCLI);
                    }
                }
            }
            this.updateSiteInfo(params, state);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
        }
        catch (Exception e) {
            Log.warn("chef", "SiteAction.doRevise_course_section Exception " + e.getMessage());
        }
    }

    public void doDelete_course_section(RunData data) {
        boolean manualDeletes;
        ListIterator i;
        boolean umiacDeletes;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        Vector umiacCourseSectionList = (Vector)state.getAttribute("umiacCourseSectionList");
        Vector manualCourseSectionList = (Vector)state.getAttribute("manualCourseSectionList");
        Vector<CourseListItem> umiacDeletionList = new Vector<CourseListItem>();
        Vector<CourseListItem> manualDeletionList = new Vector<CourseListItem>();
        boolean bl = umiacDeletes = params.getStrings("umiacDeletes") != null;
        if (umiacDeletes) {
            ArrayList<String> umiacChosenList = new ArrayList<String>(Arrays.asList(params.getStrings("umiacDeletes")));
            ListIterator i2 = umiacChosenList.listIterator();
            while (i2.hasNext()) {
                String umiacId = (String)i2.next();
                ListIterator j = umiacCourseSectionList.listIterator();
                while (j.hasNext()) {
                    CourseListItem umiacCLI = (CourseListItem)j.next();
                    String umiacCourseSectionListId = umiacCLI.getKey();
                    if (!umiacId.equals(umiacCourseSectionListId)) continue;
                    umiacDeletionList.add(umiacCLI);
                }
            }
            i = umiacDeletionList.listIterator();
            while (i.hasNext()) {
                CourseListItem umiacDelete = (CourseListItem)i.next();
                umiacCourseSectionList.remove(umiacDelete);
            }
            state.setAttribute("umiacCourseSectionList", (Object)umiacCourseSectionList);
        }
        boolean bl2 = manualDeletes = params.getStrings("manualDeletes") != null;
        if (manualDeletes) {
            ArrayList<String> manualChosenList = new ArrayList<String>(Arrays.asList(params.getStrings("manualDeletes")));
            i = manualChosenList.listIterator();
            while (i.hasNext()) {
                String manualId = (String)i.next();
                ListIterator j = manualCourseSectionList.listIterator();
                while (j.hasNext()) {
                    CourseListItem manualCLI = (CourseListItem)j.next();
                    String manualCourseSectionListId = manualCLI.getKey();
                    if (!manualId.equals(manualCourseSectionListId)) continue;
                    manualDeletionList.add(manualCLI);
                }
            }
            ListIterator i3 = manualDeletionList.listIterator();
            while (i3.hasNext()) {
                CourseListItem manualDelete = (CourseListItem)i3.next();
                manualCourseSectionList.remove(manualDelete);
            }
            state.setAttribute("manualCourseSectionList", (Object)manualCourseSectionList);
        }
    }

    public void doMenu_section_add(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"18");
        ParameterParser params = data.getParameters();
        int index = 17;
        this.actionForTemplate("continue", index, params, state);
    }

    public void doMenu_section_revise(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"19");
        ParameterParser params = data.getParameters();
        int index = 17;
        this.actionForTemplate("continue", index, params, state);
    }

    public void doMenu_section_delete(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"20");
        ParameterParser params = data.getParameters();
        int index = 17;
        this.actionForTemplate("continue", index, params, state);
    }

    private void setupTerms(SessionState state) {
        int i = 0;
        while (i < TERMS.length) {
            IdAndText item = new IdAndText();
            item.id = i;
            item.text = TERMS[i];
            this.termList.add(item);
            ++i;
        }
        state.setAttribute(TERM_LIST, (Object)this.termList);
    }

    private void setupToolOrder(SessionState state) {
        Vector<String> toolOrder = new Vector<String>();
        toolOrder.add("chef.schedule");
        toolOrder.add("chef.announcements");
        toolOrder.add("chef.resources");
        toolOrder.add("chef.threadeddiscussion");
        toolOrder.add("chef.chat");
        toolOrder.add("chef.assignment");
        toolOrder.add("chef.dropbox");
        toolOrder.add("chef.mailbox");
        toolOrder.add("chef.news");
        toolOrder.add("chef.iframe");
        state.setAttribute("toolOrder", toolOrder);
    }

    private void setupSkins(SessionState state) {
        Vector<Skin> skins = new Vector<Skin>();
        Skin chef = new Skin();
        chef.css = "chef.css";
        chef.unit = "None";
        skins.add(chef);
        Skin arc = new Skin();
        arc.css = "arc.css";
        arc.unit = "College of Architecture and Urban Planning";
        skins.add(arc);
        Skin art = new Skin();
        art.css = "art.css";
        art.unit = "School of Art and Design";
        skins.add(art);
        Skin bus = new Skin();
        bus.css = "bus.css";
        bus.unit = "Business School";
        skins.add(bus);
        Skin den = new Skin();
        den.css = "den.css";
        den.unit = "School of Dentistry";
        skins.add(den);
        Skin edu = new Skin();
        edu.css = "edu.css";
        edu.unit = "School of Education";
        skins.add(edu);
        Skin eng = new Skin();
        eng.css = "eng.css";
        eng.unit = "College of Engineering";
        skins.add(eng);
        Skin inf = new Skin();
        inf.css = "inf.css";
        inf.unit = "School of Information";
        skins.add(inf);
        Skin kin = new Skin();
        kin.css = "kin.css";
        kin.unit = "Division of Kinesiology";
        skins.add(kin);
        Skin law = new Skin();
        law.css = "law.css";
        law.unit = "Law School";
        skins.add(law);
        Skin lsa = new Skin();
        lsa.css = "lsa.css";
        lsa.unit = "LS&A";
        skins.add(lsa);
        Skin med = new Skin();
        med.css = "med.css";
        med.unit = "Medical School";
        skins.add(med);
        Skin mus = new Skin();
        mus.css = "mus.css";
        mus.unit = "School of Music";
        skins.add(mus);
        Skin nre = new Skin();
        nre.css = "nre.css";
        nre.unit = "School of Natural Resources and Environment";
        skins.add(nre);
        Skin nur = new Skin();
        nur.css = "nur.css";
        nur.unit = "School of Nursing";
        skins.add(nur);
        Skin off = new Skin();
        off.css = "off.css";
        off.unit = "Officer Education Programs";
        skins.add(off);
        Skin pha = new Skin();
        pha.css = "pha.css";
        pha.unit = "College of Pharmacy";
        skins.add(pha);
        Skin sph = new Skin();
        sph.css = "sph.css";
        sph.unit = "School of Public Health";
        skins.add(sph);
        Skin spp = new Skin();
        spp.css = "spp.css";
        spp.unit = "School of Public Policy";
        skins.add(spp);
        Skin rac = new Skin();
        rac.css = "rac.css";
        rac.unit = "Rackham School of Graduate Studies";
        Skin ssw = new Skin();
        ssw.css = "ssw.css";
        ssw.unit = "School of Social Work";
        skins.add(ssw);
        Skin umd = new Skin();
        umd.css = "umd.css";
        umd.unit = "UM Dearborn";
        skins.add(umd);
        state.setAttribute("skins", skins);
    }

    private void init(VelocityPortlet portlet, RunData data, SessionState state) {
        ParameterParser params = data.getParameters();
        state.setAttribute(STATE_ACTION, (Object)CONTEXT_ACTION);
        this.setupFormNamesAndConstants(state);
        this.setupSkins(state);
        this.setupTerms(state);
        this.setupToolOrder(state);
        this.setupToolLists(state);
        this.actionForTemplate("continue", 0, params, state);
        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
    }

    private void updateParticipantRoles(ParameterParser params, SessionState state) {
        String realmId = "/site/" + ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
        if (RealmService.allowUpdateRealm(realmId)) {
            try {
                RealmEdit realmEdit = RealmService.editRealm(realmId);
                List users = this.getUsers(state);
                List roles = this.getRoles(state);
                ListIterator i = users.listIterator();
                while (i.hasNext()) {
                    User user = (User)i.next();
                    ListIterator j = roles.listIterator();
                    while (j.hasNext()) {
                        Role role = (Role)j.next();
                        try {
                            realmEdit.removeUserRole(user, role);
                        }
                        catch (Exception ignore) {
                            this.addAlert(state, "Problem encountered removing user role.");
                            Log.warn("chef", "SiteAction.updateParticipantRoles Exception ignore " + realmId);
                        }
                    }
                    String[] selected = params.getStrings(user.getId());
                    if (selected == null || selected.length == 0) continue;
                    int j2 = 0;
                    while (j2 < selected.length) {
                        Role r = realmEdit.getRole(selected[j2]);
                        realmEdit.addUserRole(user, r);
                        ++j2;
                    }
                }
                RealmService.commitEdit(realmEdit);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Problem encountered updating user roles.");
                Log.warn("chef", "SiteAction.updateParticipantRoles  IdUnusedException " + realmId);
            }
            catch (PermissionException e) {
                this.addAlert(state, "You do not have permission to change roles.");
                Log.warn("chef", "SiteAction.updateParticipantRoles  PermissionException " + realmId);
            }
            catch (InUseException e) {
                this.addAlert(state, "Site is in use and cannot be changed.");
                Log.warn("chef", "SiteAction.updateParticipantRoles  InUnuseException " + realmId);
            }
        }
    }

    private void updatePortlet(SessionState state, VelocityPortlet portlet, RunData data) {
        if (state.getAttribute("update") == null) {
            return;
        }
        state.removeAttribute("update");
    }

    private void actionForTemplate(String navigation, int index, ParameterParser params, SessionState state) {
        boolean forward = navigation.equals("continue");
        String template_index = (String)state.getAttribute(STATE_TEMPLATE_INDEX);
        Vector umiacCourseSelectionList = (Vector)state.getAttribute("umiacCourseSelectionList");
        Vector manualCourseSelectionList = (Vector)state.getAttribute("manualCourseSelectionList");
        Vector umiacCourseSectionList = (Vector)state.getAttribute("umiacCourseSectionList");
        Vector manualCourseSectionList = (Vector)state.getAttribute("manualCourseSectionList");
        switch (index) {
            case 0: {
                Vector<Site> unpublishedSitesList = new Vector<Site>();
                Vector<Site> publishedSitesList = new Vector<Site>();
                Vector<Site> requestedSitesList = new Vector<Site>();
                Vector currentTermSitesList = new Vector();
                Vector otherSitesList = new Vector();
                Vector siteList = (Vector)SiteService.getSites();
                if (!siteList.isEmpty()) {
                    ListIterator i = siteList.listIterator();
                    while (i.hasNext()) {
                        Site site = (Site)i.next();
                        ResourceProperties rp = site.getProperties();
                        boolean knownType = false;
                        boolean typeCourse = false;
                        boolean currentTerm = false;
                        try {
                            int j = 0;
                            while (j < SITE_TYPES.length) {
                                if (rp.getProperty("CTNG:site-type").equals(SITE_TYPES[j])) {
                                    knownType = true;
                                }
                                ++j;
                            }
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        if (!knownType) continue;
                        if (rp.getProperty("CTNG:site-type").equals(SITE_TYPE_COURSE)) {
                            typeCourse = true;
                        }
                        if (Integer.parseInt(rp.getProperty(PROP_SITE_TERM)) == 0) {
                            currentTerm = true;
                        }
                        if (site.getStatus() == 2 && SiteService.allowUpdateSite(site.getId())) {
                            publishedSitesList.add(site);
                            continue;
                        }
                        if (rp.getProperty("CTNG:site-type").equals(SITE_TYPE_REQUESTED) && SiteService.allowUpdateSite(site.getId())) {
                            requestedSitesList.add(site);
                            continue;
                        }
                        if (site.getStatus() != 1 || !SiteService.allowUpdateSite(site.getId())) continue;
                        unpublishedSitesList.add(site);
                    }
                }
                state.setAttribute(STATE_CURRENT_TERM_SITES_LIST, currentTermSitesList);
                state.setAttribute(STATE_UNPUBLISHED_SITES_LIST, unpublishedSitesList);
                state.setAttribute(STATE_PUBLISHED_SITES_LIST, publishedSitesList);
                state.setAttribute(STATE_REQUESTED_SITES_LIST, requestedSitesList);
                state.setAttribute(STATE_OTHER_SITES_LIST, otherSitesList);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                state.setAttribute("CTNG:site-type", (Object)SITE_TYPE_COURSE);
                this.updateProfile(params, state);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                state.setAttribute("CTNG:site-type", (Object)SITE_TYPE_DISSERTATION);
                this.updateProfile(params, state);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.getFeatures(params, state);
                if (!forward) break;
                this.commitSite(state, 1);
                break;
            }
            case 8: {
                state.setAttribute("CTNG:site-type", (Object)SITE_TYPE_PROJECT);
                this.updateProfile(params, state);
                break;
            }
            case 9: {
                String form_title = params.getString("title");
                if (forward) {
                    if (form_title == null || form_title.trim().length() == 0) {
                        this.addAlert(state, "Please enter the required fields.");
                        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"9");
                        return;
                    }
                    if (!SiteService.allowAddSite(form_title)) {
                        this.addAlert(state, "You do not have permission to add " + form_title + ".");
                        return;
                    }
                }
                this.updateSiteInfo(params, state);
                if (forward) {
                    this.updateSiteAttributes(state);
                }
                if (!forward) break;
                this.addNewSite(params, state);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                this.updateSiteProperties(state);
                if (!forward) break;
                this.commitSite(state, 2);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                this.updateSiteProperties(state);
                if (!forward) break;
                this.commitSite(state, 2);
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
                if (params.getString("title") != null) {
                    site.setTitle(params.getString("title"));
                }
                if (params.getString("description") != null) {
                    site.setDescription(params.getString("description"));
                }
                if (params.getString("infoUrl") != null) {
                    site.setInfoUrl(params.getString("infoUrl"));
                }
                if (forward) {
                    this.commitSite(state);
                }
                state.setAttribute(STATE_SITE_INSTANCE, (Object)site);
                this.updateSiteInfo(params, state);
                if (forward) {
                    this.updateSiteProperties(state);
                }
                if (forward) {
                    this.updateSiteAttributes(state);
                }
                if (!forward) break;
                this.commitSite(state);
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                if (!forward) break;
                this.finishSectionAccess(state, params);
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                this.customizeLayout(forward, params, state);
                this.updateSiteInfo(params, state);
                if (forward) {
                    this.updateSiteProperties(state);
                }
                if (!forward) break;
                this.updateSiteAttributes(state);
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                this.getParticipantList(state);
                break;
            }
            case 28: {
                if (!forward) break;
                this.addParticipant(params, state);
                break;
            }
            case 29: {
                if (!forward) break;
                this.removeParticipants(params, state);
                break;
            }
            case 30: {
                if (!forward) break;
                this.updateParticipantRoles(params, state);
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                this.updateSiteInfo(params, state);
                if (forward) {
                    this.updateSiteProperties(state);
                }
                if (forward) {
                    this.updateSiteAttributes(state);
                }
                if (params.getString("joinable") != "true" || params.getString("joinerRole") != null) break;
                this.addAlert(state, "Please select a role for those joining your site.");
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"32");
            }
        }
    }

    private void updateProfile(ParameterParser params, SessionState state) {
        Profile profile = (Profile)state.getAttribute(STATE_PROFILE);
        if (params.getString("institution") != null) {
            profile.institution = params.getString("institution");
        }
        if (params.getString("affiliation") != null) {
            profile.affiliation = Integer.parseInt(params.getString("affiliation"));
        }
        if (params.getString("honorific") != null) {
            profile.honorific = Integer.parseInt(params.getString("honorific"));
        }
        if (params.getString("office") != null) {
            profile.office = params.getString("office");
        }
        if (params.getString("phone") != null) {
            profile.phone = params.getString("phone");
        }
        if (params.getString("email") != null) {
            profile.email = params.getString("email");
        }
        state.setAttribute(STATE_PROFILE, (Object)profile);
    }

    private void updateSiteAttributes(SessionState state) {
        SiteInfo siteInfo = new SiteInfo();
        if (state.getAttribute(STATE_SITE_INFO) == null) {
            Log.warn("chef", "SiteAction.updateSiteAttributes STATE_SITE_INFO == null");
            return;
        }
        siteInfo = (SiteInfo)state.getAttribute(STATE_SITE_INFO);
        if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
            SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
            if (StringUtil.trimToNull(siteInfo.title) != null) {
                site.setTitle(siteInfo.title);
            }
            if (siteInfo.description != null) {
                site.setDescription(siteInfo.description);
            }
            if (StringUtil.trimToNull(siteInfo.skin) != null) {
                site.setSkin(siteInfo.skin);
            }
            if (StringUtil.trimToNull(siteInfo.infoUrl) != null) {
                site.setInfoUrl(siteInfo.infoUrl);
            }
            if (StringUtil.trimToNull(siteInfo.iconUrl) != null) {
                site.setIconUrl(siteInfo.iconUrl);
            }
            site.setJoinable(siteInfo.joinable);
            if (StringUtil.trimToNull(siteInfo.joinerRole) != null) {
                site.setJoinerRole(siteInfo.joinerRole);
            }
            String id = site.getId();
            SiteService.commitEdit(site);
            try {
                SiteEdit updated_site = SiteService.editSite(id);
                state.setAttribute(STATE_SITE_INSTANCE, (Object)updated_site);
            }
            catch (IdUnusedException e) {
                Log.warn("chef", "SiteAction.commitSite IdUnusedException " + id + " not found");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You do not have permission to make changes to this site.");
                Log.warn("chef", "SiteAction.commitSite IdUnusedException " + id + " not found");
            }
            catch (InUseException e) {
                this.addAlert(state, "Cannot save changes to site because site is being used by another person.");
                Log.warn("chef", "SiteAction.commitSite IdUnusedException " + id + " not found");
            }
        } else {
            Log.warn("chef", "SiteAction.updateSiteAttributes STATE_SITE_INSTANCE == null");
        }
    }

    private void updateSiteInfo(ParameterParser params, SessionState state) {
        SiteInfo siteInfo = new SiteInfo();
        if (state.getAttribute(STATE_SITE_INFO) != null) {
            siteInfo = (SiteInfo)state.getAttribute(STATE_SITE_INFO);
        }
        siteInfo.site_type = (String)state.getAttribute("CTNG:site-type");
        if (params.getString("title") != null) {
            siteInfo.title = params.getString("title");
        }
        if (params.getString("description") != null) {
            siteInfo.description = params.getString("description");
        }
        if (params.getString("term") != null) {
            siteInfo.term = Integer.parseInt(params.getString("term"));
            state.setAttribute(STATE_TERM_REQUEST, (Object)params.getString("term"));
        }
        if (params.getString("iconUrl") != null) {
            siteInfo.iconUrl = params.getString("iconUrl");
        }
        if (params.getString("infoUrl") != null) {
            siteInfo.infoUrl = params.getString("infoUrl");
        }
        if (params.getString("skin") != null) {
            siteInfo.skin = params.getString("skin");
        }
        if (params.getString("joinerRole") != null) {
            siteInfo.joinerRole = params.getString("joinerRole");
        }
        if (params.getString("joinable") != null) {
            boolean joinable;
            siteInfo.joinable = joinable = params.getBoolean("joinable");
            if (!joinable) {
                siteInfo.joinerRole = NULL_STRING;
            }
        }
        state.setAttribute(STATE_SITE_INFO, (Object)siteInfo);
    }

    private String getExternalRealmId(SessionState state) {
        SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
        String realmId = "/site/" + site.getId();
        String rv = null;
        try {
            Realm realm = RealmService.getRealm(realmId);
            rv = realm.getProviderRealmId();
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "SiteAction.getExternalRealmId, site realm not found");
            this.addAlert(state, "The site access information was not found.");
        }
        return rv;
    }

    private List getParticipantList(SessionState state) {
        Vector users = new Vector();
        Vector<Participant> participants = new Vector<Participant>();
        String realmId = "/site/" + ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
        try {
            Realm realm = RealmService.getRealm(realmId);
            users.addAll(realm.getUsers());
            Collections.sort(users);
            int i = 0;
            while (i < users.size()) {
                Set roles;
                User user = (User)users.get(i);
                Participant participant = new Participant();
                participant.name = user.getSortName();
                participant.uniqname = user.getId();
                participant.roles = roles = realm.getUserRoles(user);
                participants.add(participant);
                ++i;
            }
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "SiteAction.updateParticipantList  IdUnusedException " + realmId);
        }
        return participants;
    }

    private List getRoles(SessionState state) {
        Vector roles = new Vector();
        String realmId = "/site/" + ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
        try {
            Realm realm = RealmService.getRealm(realmId);
            roles.addAll(realm.getRoles());
            Collections.sort(roles);
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "SiteAction.getRoles IdUnusedException " + realmId);
        }
        return roles;
    }

    private List getUsers(SessionState state) {
        Vector users = new Vector();
        String realmId = "/site/" + ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
        try {
            Realm realm = RealmService.getRealm(realmId);
            users.addAll(realm.getUsers());
            Collections.sort(users);
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "SiteAction.getUsers IdUnusedException " + realmId);
        }
        return users;
    }

    private void getFeatures(ParameterParser params, SessionState state) {
        if (params.getStrings("selectedTools") == null) {
            this.addAlert(state, NO_FEATURES_SELECTED_STRING);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
            return;
        }
        Vector toolRegistrationList = (Vector)state.getAttribute(STATE_TOOL_REGISTRATION_LIST);
        ArrayList<String> chosenList = new ArrayList<String>(Arrays.asList(params.getStrings("selectedTools")));
        Vector<String> idsSelected = new Vector<String>();
        SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
        if (chosenList != null) {
            ListIterator i;
            boolean removePages;
            List pageList = site.getPageEdits();
            boolean bl = removePages = pageList.size() > 0;
            if (removePages) {
                i = pageList.listIterator();
                while (i.hasNext()) {
                    SitePageEdit page = (SitePageEdit)i.next();
                    List toolList = page.getToolEdits();
                    ListIterator j = toolList.listIterator();
                    while (j.hasNext()) {
                        ToolConfigurationEdit tool = (ToolConfigurationEdit)j.next();
                        page.removeTool(tool);
                    }
                    site.removePage(page);
                }
            }
            i = chosenList.listIterator();
            while (i.hasNext()) {
                String toolId = (String)i.next();
                if (toolId.equals("CTNG.home")) {
                    try {
                        SitePageEdit page = site.addPage();
                        page.setTitle("Home");
                        page.setLayout(1);
                        ToolConfigurationEdit iframe = page.addTool();
                        iframe.setToolId("chef.iframe");
                        iframe.setTitle("Worksite Information");
                        iframe.setLayoutHints("0,0");
                        iframe.getPropertiesEdit().addProperty("height", "100px");
                        iframe.getPropertiesEdit().addProperty("special", "workspace");
                        iframe.getPropertiesEdit().addProperty("source", NULL_STRING);
                        iframe.getPropertiesEdit().addProperty("special", "worksite");
                        ToolConfigurationEdit announcement = page.addTool();
                        announcement.setToolId("chef.synoptic.announcement");
                        announcement.setTitle("Recent Announcements");
                        announcement.setLayoutHints("0,1");
                        announcement.getPropertiesEdit().addProperty("items", "3");
                        announcement.getPropertiesEdit().addProperty("show-subject", "true");
                        announcement.getPropertiesEdit().addProperty("length", "50");
                        announcement.getPropertiesEdit().addProperty("message-service", "org.chefproject.service.generic.GenericAnnouncementService");
                        announcement.getPropertiesEdit().addProperty("days", "10");
                        ToolConfigurationEdit discussion = page.addTool();
                        discussion.setToolId("chef.synoptic.discussion");
                        discussion.setTitle("Recent Discussion Items");
                        discussion.setLayoutHints("1,1");
                        discussion.getPropertiesEdit().addProperty("items", "3");
                        discussion.getPropertiesEdit().addProperty("show-subject", "true");
                        discussion.getPropertiesEdit().addProperty("length", "50");
                        discussion.getPropertiesEdit().addProperty("message-service", "org.chefproject.service.generic.GenericDiscussionService");
                        discussion.getPropertiesEdit().addProperty("days", "10");
                        ToolConfigurationEdit chat = page.addTool();
                        chat.setToolId("chef.synoptic.chat");
                        chat.setTitle("Recent Chat Messages");
                        chat.setLayoutHints("2,1");
                        chat.getPropertiesEdit().addProperty("items", "3");
                        chat.getPropertiesEdit().addProperty("show-subject", "false");
                        chat.getPropertiesEdit().addProperty("length", "50");
                        chat.getPropertiesEdit().addProperty("message-service", "org.chefproject.service.generic.GenericChatService");
                        chat.getPropertiesEdit().addProperty("days", "10");
                    }
                    catch (Exception e) {
                        Log.warn("chef", "SiteAction.getFeatures Exception " + e.getMessage());
                    }
                    continue;
                }
                ListIterator j = toolRegistrationList.listIterator();
                while (j.hasNext()) {
                    ToolRegistration tr = (ToolRegistration)j.next();
                    String toolRegId = tr.getId();
                    String toolRegTitle = tr.getTitle();
                    if (!toolId.equals(toolRegId)) continue;
                    idsSelected.add(toolId);
                    SitePageEdit page = site.addPage();
                    page.setTitle(toolRegTitle);
                    ToolConfigurationEdit tool = page.addTool();
                    tool.setToolId(toolRegId);
                    tool.setTitle(toolRegTitle);
                    ResourceProperties rp = tr.getDefaultConfiguration();
                    ResourcePropertiesEdit rpe = tool.getPropertiesEdit();
                    rpe.addAll(rp);
                }
            }
            SitePageEdit lastPage = site.addPage();
            lastPage.setTitle("Help");
            ToolConfigurationEdit help = lastPage.addTool();
            help.setToolId("chef.contactSupport");
            help.setTitle("Contact Support Form");
            state.setAttribute(STATE_TOOL_REGISTRATION_SELECTED_LIST, idsSelected);
        } else {
            this.addAlert(state, NO_FEATURES_SELECTED_STRING);
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
        }
    }

    private List getRoster(SessionState state, String year, String term, String campus, String subject, String course, String section) {
        Vector<Student> rv = new Vector<Student>();
        try {
            ListIterator i = this.umiacClient.getClassList(year, term, campus, subject, course, section).listIterator();
            while (i.hasNext()) {
                String[] res = (String[])i.next();
                Student student = new Student();
                student.name = res[0];
                student.uniqname = res[1];
                student.id = res[2];
                student.level = res[3];
                student.credits = res[4];
                rv.add(student);
            }
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "A problem was encountered connecting to the Registrar's information system.");
            String err = "SiteAction.getRoster, IdUnusedException ";
            Log.warn("chef", err);
        }
        return rv;
    }

    public CourseListItem buildCourseListItem(String[] res) {
        CourseListItem course = new CourseListItem();
        course.year = res[0];
        course.term_code = res[1];
        course.campus_code = res[2];
        course.subject = res[3];
        course.catalog_nbr = res[4];
        course.class_section = res[5];
        course.title = res[6];
        course.url = res[7];
        course.component = res[8];
        course.role = res[9];
        course.subrole = res[10];
        course.key = res[0] + "," + res[1] + "," + res[2] + "," + res[3] + "," + res[4] + "," + res[5];
        course.crosslist = res.length == 12 ? "CL" : NULL_STRING;
        return course;
    }

    public void commitSite(SessionState state, int status) {
        SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
        String id = site.getId();
        site.setStatus(status);
        SiteService.commitEdit(site);
        try {
            SiteEdit updated_site = SiteService.editSite(id);
            state.setAttribute(STATE_SITE_INSTANCE, (Object)updated_site);
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "SiteAction.commitSite IdUnusedException " + id + " not found");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to make changes to this site.");
            Log.warn("chef", "SiteAction.commitSite IdUnusedException " + id + " not found");
        }
        catch (InUseException e) {
            this.addAlert(state, "Cannot save changes to site because site is being used by another person.");
            Log.warn("chef", "SiteAction.commitSite IdUnusedException " + id + " not found");
        }
    }

    public void commitSite(SessionState state) {
        SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
        String id = site.getId();
        SiteService.commitEdit(site);
        try {
            SiteEdit updated_site = SiteService.editSite(id);
            state.setAttribute(STATE_SITE_INSTANCE, (Object)updated_site);
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "SiteAction.commitSite IdUnusedException " + id + " not found");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to make changes to this site.");
            Log.warn("chef", "SiteAction.commitSite IdUnusedException " + id + " not found");
        }
        catch (InUseException e) {
            this.addAlert(state, "Cannot save changes to site because site is being used by another person.");
            Log.warn("chef", "SiteAction.commitSite IdUnusedException " + id + " not found");
        }
    }

    private void customizeLayout(boolean forward, ParameterParser params, SessionState state) {
        String skin = null;
        String iconUrl = null;
        if (params.getString("skin") != null) {
            skin = params.getString("skin");
        }
        if (params.getString("iconUrl") != null) {
            iconUrl = params.getString("iconUrl");
        }
        if (forward) {
            try {
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
                    String id = site.getId();
                    if (skin != null) {
                        site.setSkin(skin);
                    }
                    if (iconUrl != null) {
                        site.setIconUrl(iconUrl);
                    }
                    SiteService.commitEdit(site);
                    try {
                        SiteEdit updated_site = SiteService.editSite(id);
                        state.setAttribute(STATE_SITE_INSTANCE, (Object)updated_site);
                    }
                    catch (IdUnusedException e) {
                        Log.warn("chef", "SiteAction.commitSite IdUnusedException");
                    }
                    catch (PermissionException e) {
                        this.addAlert(state, "You do not have permission to make changes to this site.");
                        Log.warn("chef", "SiteAction.commitSite PermissionException");
                    }
                    catch (InUseException e) {
                        this.addAlert(state, "Cannot save changes to site because site is being used by another person.");
                        Log.warn("chef", "SiteAction.commitSite IdUnusedException");
                    }
                }
            }
            catch (Exception e) {
                Log.warn("chef", "SiteAction.customizeLayout Exception " + e.getMessage());
            }
        }
    }

    private void updateSiteProperties(SessionState state) {
        try {
            SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
            SiteInfo siteInfo = (SiteInfo)state.getAttribute(STATE_SITE_INFO);
            Profile profile = (Profile)state.getAttribute(STATE_PROFILE);
            ResourcePropertiesEdit rpe = site.getPropertiesEdit();
            rpe.addProperty(PROP_SITE_CONTACT_INSTITUTION, profile.institution);
            rpe.addProperty(PROP_SITE_CONTACT_AFFILIATION, Integer.toString(profile.affiliation));
            rpe.addProperty(PROP_SITE_CONTACT_HONORIFIC, Integer.toString(profile.honorific));
            rpe.addProperty(PROP_SITE_CONTACT_OFFICE, profile.office);
            rpe.addProperty(PROP_SITE_CONTACT_PHONE, profile.phone);
            rpe.addProperty(PROP_SITE_CONTACT_EMAIL, profile.email);
            rpe.addProperty("CTNG:site-type", siteInfo.site_type);
            rpe.addProperty(PROP_SITE_TITLE, siteInfo.title);
            rpe.addProperty(PROP_SITE_SITE_INFO_URL, siteInfo.infoUrl);
            rpe.addProperty(PROP_SITE_ICON_URL, siteInfo.iconUrl);
            rpe.addProperty(PROP_SITE_COURSE, siteInfo.course);
            rpe.addProperty(PROP_SITE_SUBJECT, siteInfo.subject);
            rpe.addProperty(PROP_SITE_TERM, Integer.toString(siteInfo.term));
            rpe.addProperty(PROP_SITE_RELATED_CLASS, Integer.toString(siteInfo.related_class));
            rpe.addProperty(PROP_SITE_RELATED_PROJECT, Integer.toString(siteInfo.related_project));
            rpe.addProperty(PROP_SITE_REUSE, Integer.toString(siteInfo.reuse));
            rpe.addProperty(PROP_SITE_ADDITIONAL, siteInfo.additional);
            rpe.addProperty(PROP_SITE_SECTIONS, siteInfo.sections);
            state.setAttribute(STATE_SITE_INSTANCE, (Object)site);
        }
        catch (Exception e) {
            Log.warn("chef", "SiteAction.updateSiteProperties  Exception" + e.getMessage());
        }
    }

    private void removeParticipants(ParameterParser params, SessionState state) {
        if (params.getStrings("removeUser") == null) {
            this.addAlert(state, "No users were selected for removal.");
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"29");
            return;
        }
        Vector<Participant> participantSelectedList = new Vector<Participant>();
        ArrayList<String> removals = new ArrayList<String>(Arrays.asList(params.getStrings("removeUser")));
        if (!removals.isEmpty()) {
            ListIterator i = removals.listIterator();
            while (i.hasNext()) {
                try {
                    String id = (String)i.next();
                    User user = UserDirectoryService.getUser(id);
                    try {
                        String realmId = "/site/" + ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
                        RealmEdit realmEdit = RealmService.editRealm(realmId);
                        Participant selected = new Participant();
                        selected.name = user.getDisplayName();
                        selected.uniqname = user.getId();
                        participantSelectedList.add(selected);
                        realmEdit.removeUser(user);
                        RealmService.commitEdit(realmEdit);
                    }
                    catch (IdUnusedException e) {
                        Log.warn("chef", "SiteAction.removeParticipants IdUnusedException");
                        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"29");
                        return;
                    }
                    catch (PermissionException e) {
                        Log.warn("chef", "SiteAction.removeParticipants PermissionException");
                        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"29");
                        return;
                    }
                    catch (InUseException e) {
                        Log.warn("chef", "SiteAction.removeParticipants InUseException");
                        state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"29");
                        return;
                    }
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", "SiteAction.removeParticipants IdUnusedException ");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"29");
                    return;
                }
            }
            state.setAttribute("participantSelectedList", participantSelectedList);
        }
    }

    private void addParticipant(ParameterParser params, SessionState state) {
        if (params.getString("addUser") == null || params.getString("addUser").trim().length() == 0) {
            this.addAlert(state, "No user id given. Please provide a user id.");
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"28");
            return;
        }
        if (params.getStrings("addRole") == null) {
            this.addAlert(state, "Please select role(s).");
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"28");
            return;
        }
        String addUser = params.getString("addUser").trim();
        try {
            User user = UserDirectoryService.getUser(addUser);
            ArrayList<String> selected = new ArrayList<String>(Arrays.asList(params.getStrings("addRole")));
            String realmId = "/site/" + ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
            if (RealmService.allowUpdateRealm(realmId)) {
                try {
                    RealmEdit realmEdit = RealmService.editRealm(realmId);
                    int i = 0;
                    while (i < selected.size()) {
                        Role role = realmEdit.getRole((String)selected.get(i));
                        realmEdit.addUserRole(user, role);
                        ++i;
                    }
                    RealmService.commitEdit(realmEdit);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", "SiteAction.addParticipant IdUnusedException " + realmId + " " + user.getId());
                }
                catch (PermissionException e) {
                    Log.warn("chef", "SiteAction.addParticipant PermissionException " + realmId + " " + user.getId());
                }
                catch (InUseException e) {
                    Log.warn("chef", "SiteAction.addParticipant InUseException " + realmId + " " + user.getId());
                }
                catch (Exception e) {
                    Log.warn("chef", "SiteAction.addParticipant Exception " + e.getMessage() + " " + realmId + " " + user.getId());
                }
            }
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "User not found. Please provide the uniqname of a CHEF user.");
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"28");
            return;
        }
    }

    private void addNewSite(ParameterParser params, SessionState state) {
        Profile profile = (Profile)state.getAttribute(STATE_PROFILE);
        SiteInfo siteInfo = (SiteInfo)state.getAttribute(STATE_SITE_INFO);
        Vector umiacCourseSectionList = (Vector)state.getAttribute("umiacCourseSectionList");
        Vector manualCourseSectionList = (Vector)state.getAttribute("manualCourseSectionList");
        String email = UsageSessionService.getSessionUser().getEmail();
        String title = siteInfo.title;
        String id = NULL_STRING;
        String realmId = NULL_STRING;
        String externalRealmId = NULL_STRING;
        boolean external_id = false;
        boolean requested_site = false;
        id = IdService.getUniqueId();
        try {
            SiteEdit site = SiteService.addSite(id);
            if (!((String)state.getAttribute("CTNG:site-type")).equals(SITE_TYPE_COURSE)) {
                site.setTitle(title);
            }
            ResourcePropertiesEdit rp = site.getPropertiesEdit();
            rp.addProperty(PROP_SITE_TITLE, siteInfo.title);
            rp.addProperty(PROP_SITE_DESCRIPTION, siteInfo.description);
            if (requested_site) {
                rp.addProperty("CTNG:site-type", SITE_TYPE_REQUESTED);
            } else {
                rp.addProperty("CTNG:site-type", siteInfo.site_type);
            }
            rp.addProperty(PROP_SITE_ICON_URL, siteInfo.iconUrl);
            rp.addProperty(PROP_SITE_SITE_INFO_URL, siteInfo.infoUrl);
            rp.addProperty(PROP_SITE_CONTACT_INSTITUTION, profile.institution);
            rp.addProperty(PROP_SITE_CONTACT_AFFILIATION, Integer.toString(profile.affiliation));
            rp.addProperty(PROP_SITE_COURSE, Integer.toString(profile.course));
            rp.addProperty(PROP_SITE_SUBJECT, Integer.toString(profile.subject));
            rp.addProperty(PROP_SITE_CONTACT_HONORIFIC, Integer.toString(profile.honorific));
            rp.addProperty(PROP_SITE_CONTACT_OFFICE, profile.office);
            rp.addProperty(PROP_SITE_CONTACT_PHONE, profile.phone);
            rp.addProperty(PROP_SITE_CONTACT_EMAIL, profile.email);
            rp.addProperty(PROP_SITE_TERM, Integer.toString(siteInfo.term));
            rp.addProperty(PROP_SITE_RELATED_CLASS, Integer.toString(siteInfo.related_class));
            rp.addProperty(PROP_SITE_RELATED_PROJECT, Integer.toString(siteInfo.related_project));
            rp.addProperty(PROP_SITE_REUSE, Integer.toString(siteInfo.reuse));
            state.setAttribute(STATE_SITE_INSTANCE, (Object)site);
        }
        catch (IdUsedException e) {
            this.addAlert(state, "A site with id " + id + " already exists.");
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
            return;
        }
        catch (IdInvalidException e) {
            this.addAlert(state, "The site id " + id + " is not valid.");
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
            return;
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to add the site " + title + ".");
            state.setAttribute(STATE_TEMPLATE_INDEX, (Object)params.getString("template-index"));
            return;
        }
    }

    private String getCourseTab(SessionState state, String id) {
        String course = null;
        String sections = null;
        String tab = null;
        try {
            if (id.indexOf("+") != -1) {
                String[] courses = id.split("\\+");
                course = courses[0];
                if (course.indexOf("[") != -1) {
                    sections = course.substring(course.indexOf("[") + 1, course.length());
                    sections = sections.substring(0, sections.indexOf("]") - 1);
                    sections = sections.replace(',', ' ');
                    course = course.substring(0, course.indexOf("[") - 1);
                    String[] fields = course.split(",");
                    tab = course = fields[3] + " " + fields[4] + " " + sections;
                } else {
                    String[] fields = course.split(",");
                    tab = course = fields[3] + " " + fields[4] + " " + fields[5];
                }
            } else if (id.indexOf("[") != -1) {
                course = id;
                course = course.replace('[', ',');
                course = course.substring(0, course.indexOf("[") - 1);
                String[] fields = course.split(",");
                tab = fields[3] + " " + fields[4] + " " + fields[5];
            } else {
                String[] fields = id.split(",");
                tab = fields[3] + " " + fields[4] + " " + fields[5];
            }
        }
        catch (Exception e) {
            Log.warn("chef", "SiteAction.getCourseTab Exception " + e.getMessage() + " " + id);
            tab = UsageSessionService.getSessionUser().getId() + "class";
        }
        return tab;
    }

    private void finishCourseSite(SessionState state, ParameterParser params) {
        Vector umiacCourseSectionList = (Vector)state.getAttribute("umiacCourseSectionList");
        Vector manualCourseSectionList = (Vector)state.getAttribute("manualCourseSectionList");
        String id = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
        String realm = "/site/" + id;
        String tab = NULL_STRING;
        if (((String)state.getAttribute("CTNG:site-type")).equals(SITE_TYPE_COURSE)) {
            if (umiacCourseSectionList != null && umiacCourseSectionList.size() != 0) {
                String providerRealm = this.buildExternalRealm(state, umiacCourseSectionList);
                tab = this.getCourseTab(state, providerRealm);
                try {
                    RealmEdit realmEdit = RealmService.editRealm(realm);
                    realmEdit.setProviderRealmId(providerRealm);
                    RealmService.commitEdit(realmEdit);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", "SiteAction.finishCourseSite IdUnusedException, not found, or not an RealmEdit object");
                    this.addAlert(state, "The expected realm object was not found.");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"4");
                    return;
                }
                catch (PermissionException e) {
                    Log.warn("chef", "SiteAction.finishCourseSite PermissionException, user does not have permission to edit RealmEdit object.");
                    this.addAlert(state, "You do not have permission to change the access to this site.");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"4");
                    return;
                }
                catch (InUseException e) {
                    this.addAlert(state, "The access to this site is currently being edited by another user.");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"4");
                    return;
                }
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
                    try {
                        site.setTitle(tab);
                        SiteService.commitEdit(site);
                    }
                    catch (Exception e) {
                        Log.warn("chef", "SiteAction.finishCourseSite Exception " + e.getMessage());
                        return;
                    }
                }
            } else if (manualCourseSectionList != null && manualCourseSectionList.size() != 0) {
                CourseListItem cli = (CourseListItem)manualCourseSectionList.get(0);
                tab = cli.subject + " " + cli.catalog_nbr + " " + cli.class_section;
                if (state.getAttribute(STATE_SITE_INSTANCE) != null) {
                    SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
                    try {
                        site.setTitle(tab);
                        SiteService.commitEdit(site);
                    }
                    catch (Exception e) {
                        Log.warn("chef", "SiteAction.finishCourseSite Exception " + e.getMessage());
                        return;
                    }
                }
                this.sendSiteRequest(state, "new");
                this.actionForTemplate("continue", 0, params, state);
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"0");
            }
        }
    }

    private void finishSectionAccess(SessionState state, ParameterParser params) {
        Vector umiacCourseSectionList = (Vector)state.getAttribute("umiacCourseSectionList");
        Vector manualCourseSectionList = (Vector)state.getAttribute("manualCourseSectionList");
        String id = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
        String realm = "/site/" + id;
        if (((String)state.getAttribute("CTNG:site-type")).equals(SITE_TYPE_COURSE)) {
            if (umiacCourseSectionList == null || umiacCourseSectionList.size() == 0) {
                try {
                    RealmEdit realmEdit1 = RealmService.editRealm(realm);
                    realmEdit1.setProviderRealmId(NULL_STRING);
                    RealmService.commitEdit(realmEdit1);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", "SiteAction.finishSectionAccess IdUnusedException, not found, or not an RealmEdit object");
                    this.addAlert(state, "The expected realm object was not found.");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"18");
                    return;
                }
                catch (PermissionException e) {
                    Log.warn("chef", "SiteAction.finishSectionAccess PermissionException, user does not have permission to edit RealmEdit object.");
                    this.addAlert(state, "You do not have permission to change the access to this site.");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"18");
                    return;
                }
                catch (InUseException e) {
                    this.addAlert(state, "The access to this site is currently being edited by another user.");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"18");
                    return;
                }
            }
            if (umiacCourseSectionList != null && umiacCourseSectionList.size() != 0) {
                String externalRealm = this.buildExternalRealm(state, umiacCourseSectionList);
                try {
                    RealmEdit realmEdit2 = RealmService.editRealm(realm);
                    realmEdit2.setProviderRealmId(externalRealm);
                    RealmService.commitEdit(realmEdit2);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", "SiteAction.finishSectionAccess IdUnusedException, not found, or not an RealmEdit object");
                    this.addAlert(state, "The expected realm object was not found.");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"18");
                    return;
                }
                catch (PermissionException e) {
                    Log.warn("chef", "SiteAction.finishSectionAccess PermissionException, user does not have permission to edit RealmEdit object.");
                    this.addAlert(state, "You do not have permission to change the access to this site.");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"18");
                    return;
                }
                catch (InUseException e) {
                    this.addAlert(state, "The access to this site is currently being edited by another user.");
                    state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"18");
                    return;
                }
            } else if (manualCourseSectionList != null && manualCourseSectionList.size() != 0) {
                this.sendSiteRequest(state, "change");
                this.actionForTemplate("continue", 15, params, state);
                state.setAttribute(STATE_TEMPLATE_INDEX, (Object)"15");
            }
        }
    }

    private void sendSiteRequest(SessionState state, String request) {
        Vector manualCourseSectionList = (Vector)state.getAttribute("manualCourseSectionList");
        String id = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getId();
        String title = ((SiteEdit)state.getAttribute(STATE_SITE_INSTANCE)).getTitle();
        Time time = new Time();
        String local_time = time.toStringLocalTime();
        String local_date = time.toStringLocalDate();
        String message_subject = "Site Request from " + UsageSessionService.getSessionUser().getDisplayName();
        String term_name = NULL_STRING;
        int term = Integer.parseInt((String)state.getAttribute(STATE_TERM_REQUEST));
        switch (term) {
            case 0: {
                term_name = "Fall, 2003";
                break;
            }
            case 1: {
                term_name = "Winter, 2004";
                break;
            }
            case 2: {
                term_name = "Spring, 2004";
                break;
            }
            case 3: {
                term_name = "Spring/Summer, 2004";
                break;
            }
            case 4: {
                term_name = "Summer, 2004";
                break;
            }
            case 5: {
                term_name = "Fall, 2004";
            }
        }
        String from = NULL_STRING;
        String to = NULL_STRING;
        String headerTo = NULL_STRING;
        String replyTo = NULL_STRING;
        String sender = NULL_STRING;
        String uniqname = UsageSessionService.getSessionUser().getId();
        sender = UsageSessionService.getSessionUser().getDisplayName();
        from = UsageSessionService.getSessionUser().getEmail();
        to = "UMCTFeedbackMail@ctmail.ummu.umich.edu";
        headerTo = "UMCTFeedbackMail@ctmail.ummu.umich.edu";
        replyTo = UsageSessionService.getSessionUser().getEmail();
        StringBuffer buf = new StringBuffer();
        buf.append("To:\t\tCourseTools Next Generation Support\n");
        buf.append("\nFrom:\t" + sender + "\n");
        if (request.equals("new")) {
            buf.append("Subj:\tSite Request\n");
        } else {
            buf.append("Subj:\tSite Change Request\n");
        }
        buf.append("Date:\t" + local_date + " " + local_time + "\n\n");
        if (request.equals("new")) {
            buf.append("I am requesting approval of a CTNG Course Site for ");
        } else {
            buf.append("I am requesting approval of access to a CTNG Course Site for ");
        }
        buf.append(term_name);
        int nbr_sections = manualCourseSectionList.size();
        if (nbr_sections > 1) {
            buf.append(" for these " + Integer.toString(nbr_sections) + " sections:\n\n");
        } else {
            buf.append(" for this section:\n\n");
        }
        int i = 0;
        while (i < manualCourseSectionList.size()) {
            CourseListItem cli = (CourseListItem)manualCourseSectionList.get(i);
            buf.append("Subject:\t" + cli.subject + "\n");
            buf.append("Course:\t" + cli.catalog_nbr + "\n");
            buf.append("Section:\t" + cli.class_section + "\n\n");
            ++i;
        }
        buf.append("Name:\t\t" + UsageSessionService.getSessionUser().getDisplayName() + " (uniqname " + uniqname + ")\n");
        buf.append("Email:\t" + replyTo + "\n\n");
        buf.append("Site title:\t" + title + "\n");
        buf.append("Site id:\t" + id + "\n\n");
        String content = buf.toString();
        Email email = new Email();
        Email.send(from, to, message_subject, content, headerTo, replyTo);
        from = "UMCTFeedbackMail@ctmail.ummu.umich.edu";
        to = UsageSessionService.getSessionUser().getEmail();
        headerTo = UsageSessionService.getSessionUser().getEmail();
        replyTo = UsageSessionService.getSessionUser().getEmail();
        buf.setLength(0);
        buf.append("This is a copy of the Course Site request that you made.\n\n");
        buf.append(content);
        buf.append("If you wish to provide additional information, please send email to ctng-support@umich.edu");
        content = buf.toString();
        Email CCemail = new Email();
        Email.send(from, to, message_subject, content, headerTo, replyTo);
        this.addAlert(state, "Your site request has been sent to Course Tools NG Support, and a copy has been sent to you.");
    }

    private void sitePropertiesIntoState(SessionState state) {
        try {
            SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
            Profile profile = new Profile();
            SiteInfo siteInfo = new SiteInfo();
            siteInfo.title = site.getTitle();
            siteInfo.description = site.getDescription();
            siteInfo.iconUrl = site.getIconUrl();
            siteInfo.infoUrl = site.getInfoUrl();
            siteInfo.joinable = site.isJoinable();
            siteInfo.joinerRole = site.getJoinerRole();
            siteInfo.skin = site.getSkin();
            ResourceProperties rp = site.getProperties();
            profile.institution = rp.getProperty(PROP_SITE_CONTACT_INSTITUTION);
            profile.affiliation = Integer.parseInt(rp.getProperty(PROP_SITE_CONTACT_AFFILIATION));
            profile.honorific = Integer.parseInt(rp.getProperty(PROP_SITE_CONTACT_HONORIFIC));
            profile.office = rp.getProperty(PROP_SITE_CONTACT_OFFICE);
            profile.phone = rp.getProperty(PROP_SITE_CONTACT_PHONE);
            profile.email = rp.getProperty(PROP_SITE_CONTACT_EMAIL);
            siteInfo.site_type = rp.getProperty("CTNG:site-type");
            siteInfo.external_id = rp.getProperty(PROP_EXTERNAL_ID);
            rp.getProperty(PROP_SITE_SITE_INFO_URL);
            siteInfo.course = rp.getProperty(PROP_SITE_COURSE);
            siteInfo.subject = rp.getProperty(PROP_SITE_SUBJECT);
            siteInfo.term = Integer.parseInt(rp.getProperty(PROP_SITE_TERM));
            siteInfo.related_class = Integer.parseInt(rp.getProperty(PROP_SITE_RELATED_CLASS));
            siteInfo.related_project = Integer.parseInt(rp.getProperty(PROP_SITE_RELATED_PROJECT));
            siteInfo.reuse = Integer.parseInt(rp.getProperty(PROP_SITE_REUSE));
            state.setAttribute(STATE_PROFILE, (Object)profile);
            state.setAttribute(STATE_SITE_INFO, (Object)siteInfo);
            state.setAttribute("CTNG:site-type", (Object)siteInfo.site_type);
        }
        catch (Exception e) {
            Log.warn("chef", "SiteAction.sitePropertiesIntoState " + e.getMessage());
        }
    }

    public List removeDuplicateCourseListItems(List courseListItems) {
        Vector<CourseListItem> rv = new Vector<CourseListItem>();
        if (courseListItems != null && courseListItems.size() != 0) {
            CourseListItem cli_i = (CourseListItem)courseListItems.get(0);
            rv.add(cli_i);
            int i = 1;
            while (i < courseListItems.size()) {
                boolean add = true;
                cli_i = (CourseListItem)courseListItems.get(i);
                String key_i = cli_i.getKey();
                int j = 0;
                while (j < rv.size()) {
                    CourseListItem cli_j = (CourseListItem)courseListItems.get(j);
                    String key_j = cli_j.getKey();
                    if (key_i.equals(key_j)) {
                        add = false;
                    }
                    ++j;
                }
                if (add) {
                    rv.add(cli_i);
                }
                ++i;
            }
        }
        return rv;
    }

    private void siteToolsIntoState(SessionState state) {
        SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_INSTANCE);
        Vector<String> toolRegistrationSelectedList = new Vector<String>();
        List pageList = site.getPages();
        if (pageList != null && pageList.size() != 0) {
            ListIterator i = pageList.listIterator();
            while (i.hasNext()) {
                SitePage page = (SitePage)i.next();
                if (page.getTitle().equals("Home")) continue;
                List toolList = page.getTools();
                int index = 0;
                ListIterator j = toolList.listIterator();
                while (j.hasNext()) {
                    ToolConfigurationEdit tool = (ToolConfigurationEdit)j.next();
                    String toolId = tool.getToolId();
                    toolRegistrationSelectedList.add(tool.getToolId());
                    IdAndText item = new IdAndText();
                    item.text = tool.getTitle();
                    this.selectedList.add(item);
                    ++index;
                }
            }
            state.setAttribute(SELECTED_LIST, (Object)this.selectedList);
            state.setAttribute(STATE_TOOL_REGISTRATION_SELECTED_LIST, toolRegistrationSelectedList);
        } else {
            state.setAttribute(STATE_SITE_TOOL_LIST, (Object)NULL_STRING);
            state.setAttribute(SELECTED_LIST, (Object)NULL_STRING);
            state.setAttribute(STATE_TOOL_REGISTRATION_SELECTED_LIST, (Object)NULL_STRING);
        }
    }

    private List orderTools(SessionState state, List toolRegistrationList) {
        Vector<ToolRegistration> rv = new Vector<ToolRegistration>();
        Vector toolOrder = (Vector)state.getAttribute("toolOrder");
        ListIterator i = toolOrder.listIterator();
        while (i.hasNext()) {
            String tool_id = (String)i.next();
            ListIterator j = toolRegistrationList.listIterator();
            while (j.hasNext()) {
                ToolRegistration tr = (ToolRegistration)j.next();
                if (!tr.getId().equals(tool_id)) continue;
                rv.add(tr);
            }
        }
        return rv;
    }

    private void setupToolLists(SessionState state) {
        Vector<IdAndText> featureList = new Vector<IdAndText>();
        Vector<Tool> toolList = new Vector<Tool>();
        Vector<Tool> courseToolList = new Vector<Tool>();
        Vector<Tool> projectToolList = new Vector<Tool>();
        Vector<Tool> dissertationToolList = new Vector<Tool>();
        Vector<Tool> workshopToolList = new Vector<Tool>();
        List toolRegistrationList = this.orderTools(state, ServerConfigurationService.getToolRegistrations());
        if (toolRegistrationList.isEmpty()) {
            Log.warn("chef", "SiteAction.setupToolLists -  toolRegistrationList.isEmpty ");
        } else {
            int j = 0;
            ListIterator i = toolRegistrationList.listIterator();
            while (i.hasNext()) {
                ToolRegistration tr = (ToolRegistration)i.next();
                IdAndText item = new IdAndText();
                item.id = j++;
                item.text = tr.getTitle();
                featureList.add(item);
            }
            ListIterator i2 = toolRegistrationList.listIterator();
            while (i2.hasNext()) {
                ToolRegistration tr = (ToolRegistration)i2.next();
                List categoriesList = tr.getCategories();
                ListIterator k = categoriesList.listIterator();
                while (k.hasNext()) {
                    Tool t = new Tool();
                    t.id = tr.getId();
                    t.title = tr.getTitle();
                    t.description = tr.getDescription();
                    t.selected = false;
                    String category = (String)k.next();
                    if (category.equals(SITE_TYPE_COURSE)) {
                        courseToolList.add(t);
                    } else if (category.equals(SITE_TYPE_PROJECT)) {
                        projectToolList.add(t);
                    } else if (category.equals(SITE_TYPE_DISSERTATION)) {
                        dissertationToolList.add(t);
                    } else if (category.equals(SITE_TYPE_WORKSHOP)) {
                        workshopToolList.add(t);
                    }
                    toolList.add(t);
                }
                state.setAttribute(STATE_COURSE_TOOL_LIST, courseToolList);
                state.setAttribute(STATE_PROJECT_TOOL_LIST, projectToolList);
                state.setAttribute(STATE_DISSERTATION_TOOL_LIST, dissertationToolList);
                state.setAttribute(STATE_WORKSHOP_TOOL_LIST, workshopToolList);
            }
        }
        state.setAttribute(STATE_TOOL_REGISTRATION_LIST, (Object)toolRegistrationList);
        state.setAttribute(FEATURE_LIST, featureList);
        state.setAttribute(STATE_TOOL_LIST, toolList);
    }

    private void setupFormNamesAndConstants(SessionState state) {
        TimeBreakdown timeBreakdown = new Time().breakdownLocal();
        String mycopyright = "&#169; " + timeBreakdown.getYear() + ", " + UsageSessionService.getSessionUser().getDisplayName() + ". All Rights Reserved. ";
        state.setAttribute(STATE_MY_COPYRIGHT, (Object)mycopyright);
        state.setAttribute(STATE_SITE_INSTANCE, null);
        state.setAttribute(STATE_INITIALIZED, (Object)Boolean.TRUE.toString());
        state.setAttribute(STATE_TERM_SELECTED, (Object)"0");
        Profile profile = new Profile();
        SiteInfo siteInfo = new SiteInfo();
        Participant participant = new Participant();
        participant.name = NULL_STRING;
        participant.uniqname = NULL_STRING;
        state.setAttribute(STATE_PROFILE, (Object)profile);
        state.setAttribute(STATE_SITE_INFO, (Object)siteInfo);
        state.setAttribute("form_participantToAdd", (Object)participant);
        Vector umiacCourseSectionList = new Vector();
        Vector manualCourseSectionList = new Vector();
        Vector studentList = new Vector();
        state.setAttribute(STATE_CLASS_ROSTER, studentList);
        state.setAttribute("umiacCourseSectionList", umiacCourseSectionList);
        state.setAttribute("manualCourseSectionList", manualCourseSectionList);
        state.setAttribute(FORM_TERM, (Object)"0");
        state.setAttribute(FORM_AFFILIATION, (Object)"0");
        state.setAttribute(FORM_HONORIFIC, (Object)"0");
        state.setAttribute(FORM_REUSE, (Object)"0");
        state.setAttribute(FORM_RELATED_CLASS, (Object)"0");
        state.setAttribute(FORM_RELATED_PROJECT, (Object)"0");
        state.setAttribute(FORM_INSTITUTION, (Object)"0");
        state.setAttribute(FORM_OFFICE, (Object)NULL_STRING);
        state.setAttribute(FORM_PHONE, (Object)NULL_STRING);
        state.setAttribute(FORM_EMAIL, (Object)NULL_STRING);
        state.setAttribute(FORM_SUBJECT, (Object)NULL_STRING);
        state.setAttribute(FORM_COURSE, (Object)NULL_STRING);
        state.setAttribute(FORM_DESCRIPTION, (Object)NULL_STRING);
        state.setAttribute(FORM_TITLE, (Object)NULL_STRING);
        state.setAttribute(FORM_NAME, (Object)NULL_STRING);
        state.setAttribute(FORM_SHORT_DESCRIPTION, (Object)NULL_STRING);
    }

    static {
        STATE_SITE_INSTANCE = STATE_SITE_INSTANCE;
        STATE_SITE_INFO = STATE_SITE_INFO;
        STATE_SITE_TYPE = "CTNG:site-type";
        PROP_EXTERNAL_ID = PROP_EXTERNAL_ID;
        PROP_SITE_CONTACT_INSTITUTION = PROP_SITE_CONTACT_INSTITUTION;
        PROP_SITE_CONTACT_AFFILIATION = PROP_SITE_CONTACT_AFFILIATION;
        PROP_SITE_CONTACT_EMAIL = PROP_SITE_CONTACT_EMAIL;
        PROP_SITE_CONTACT_HONORIFIC = PROP_SITE_CONTACT_HONORIFIC;
        PROP_SITE_CONTACT_OFFICE = PROP_SITE_CONTACT_OFFICE;
        PROP_SITE_CONTACT_PHONE = PROP_SITE_CONTACT_PHONE;
        PROP_SITE_TYPE = "CTNG:site-type";
        PROP_SITE_TITLE = PROP_SITE_TITLE;
        PROP_SITE_DESCRIPTION = PROP_SITE_DESCRIPTION;
        PROP_SITE_TERM = PROP_SITE_TERM;
        PROP_SITE_SUBJECT = PROP_SITE_SUBJECT;
        PROP_SITE_COURSE = PROP_SITE_COURSE;
        PROP_SITE_SECTIONS = PROP_SITE_SECTIONS;
        PROP_SITE_REUSE = PROP_SITE_REUSE;
        PROP_SITE_RELATED_CLASS = PROP_SITE_RELATED_CLASS;
        PROP_SITE_RELATED_PROJECT = PROP_SITE_RELATED_PROJECT;
        PROP_SITE_ICON_URL = PROP_SITE_ICON_URL;
        PROP_SITE_SITE_INFO_URL = PROP_SITE_SITE_INFO_URL;
        PROP_SITE_ADDITIONAL = PROP_SITE_ADDITIONAL;
        FALL_2003 = 0;
        WINTER_2004 = 1;
        SPRING_2004 = 2;
        SPRING_SUMMER_2004 = 3;
        SUMMER_2004 = 4;
        FALL_2004 = 5;
        CURRENT_TERM = 0;
        SITE_TYPE_COURSE = SITE_TYPE_COURSE;
        SITE_TYPE_DISSERTATION = SITE_TYPE_DISSERTATION;
        SITE_TYPE_PROJECT = SITE_TYPE_PROJECT;
        SITE_TYPE_WORKSHOP = SITE_TYPE_WORKSHOP;
        SITE_TYPE_REQUESTED = SITE_TYPE_REQUESTED;
        SITE_TYPE_UNDEFINED = SITE_TYPE_UNDEFINED;
        SITE_TYPES = new String[]{SITE_TYPE_UNDEFINED, SITE_TYPE_REQUESTED, SITE_TYPE_COURSE, SITE_TYPE_DISSERTATION, SITE_TYPE_PROJECT, SITE_TYPE_WORKSHOP};
        STATE_SITE_REMOVALS = STATE_SITE_REMOVALS;
        STATE_TOOL_REGISTRATION_LIST = STATE_TOOL_REGISTRATION_LIST;
        STATE_TOOL_REGISTRATION_SELECTED_LIST = STATE_TOOL_REGISTRATION_SELECTED_LIST;
        STATE_COURSE_TOOL_LIST = STATE_COURSE_TOOL_LIST;
        STATE_PROJECT_TOOL_LIST = STATE_PROJECT_TOOL_LIST;
        STATE_DISSERTATION_TOOL_LIST = STATE_DISSERTATION_TOOL_LIST;
        STATE_WORKSHOP_TOOL_LIST = STATE_WORKSHOP_TOOL_LIST;
        STATE_TOOL_LIST = STATE_TOOL_LIST;
        STATE_FEATURE_LIST = STATE_FEATURE_LIST;
        FEATURE_LIST = FEATURE_LIST;
        STATE_SITE_TOOL_LIST = STATE_SITE_TOOL_LIST;
        SELECTED_LIST = SELECTED_LIST;
        AFFILIATION_LIST = AFFILIATION_LIST;
        COURSE_LIST = COURSE_LIST;
        HONORIFIC_LIST = HONORIFIC_LIST;
        RELATED_PROJECT_LIST = RELATED_PROJECT_LIST;
        RELATED_CLASS_LIST = RELATED_CLASS_LIST;
        TERM_LIST = TERM_LIST;
        SECTION_LIST = SECTION_LIST;
        SITE_SECTION_LIST = SITE_SECTION_LIST;
        STATE_UNPUBLISHED_SITES_LIST = STATE_UNPUBLISHED_SITES_LIST;
        STATE_PUBLISHED_SITES_LIST = STATE_PUBLISHED_SITES_LIST;
        STATE_REQUESTED_SITES_LIST = STATE_REQUESTED_SITES_LIST;
        STATE_CURRENT_TERM_SITES_LIST = STATE_CURRENT_TERM_SITES_LIST;
        STATE_OTHER_SITES_LIST = STATE_OTHER_SITES_LIST;
        STATE_SITE_LIST = STATE_SITE_LIST;
        SUBJECT_LIST = SUBJECT_LIST;
        SUBJECT_TITLE_LIST = SUBJECT_TITLE_LIST;
        STATE_PROFILE = STATE_PROFILE;
        STATE_CLASS_ROSTER = STATE_CLASS_ROSTER;
        STATE_TERM_REQUEST = STATE_TERM_REQUEST;
        STATE_SUBJECT_REQUEST = STATE_SUBJECT_REQUEST;
        STATE_COURSE_REQUEST = STATE_COURSE_REQUEST;
        STATE_SECTION_REQUEST = STATE_SECTION_REQUEST;
        FORM_TITLE = FORM_TITLE;
        FORM_DESCRIPTION = FORM_DESCRIPTION;
        FORM_AFFILIATION = FORM_AFFILIATION;
        FORM_AFFILIATION_TEXT = FORM_AFFILIATION_TEXT;
        FORM_HONORIFIC = FORM_HONORIFIC;
        FORM_INSTITUTION = FORM_INSTITUTION;
        FORM_SUBJECT = FORM_SUBJECT;
        FORM_COURSE = FORM_COURSE;
        FORM_SECTION = FORM_SECTION;
        FORM_OFFICE = FORM_OFFICE;
        FORM_PHONE = FORM_PHONE;
        FORM_EMAIL = FORM_EMAIL;
        FORM_TERM = FORM_TERM;
        FORM_REUSE = FORM_REUSE;
        FORM_RELATED_CLASS = FORM_RELATED_CLASS;
        FORM_RELATED_PROJECT = FORM_RELATED_PROJECT;
        FORM_NAME = FORM_NAME;
        FORM_PERSON = FORM_PERSON;
        FORM_SHORT_DESCRIPTION = FORM_SHORT_DESCRIPTION;
        FORM_SELECTED = FORM_SELECTED;
        FORM_UMID = FORM_UMID;
        CONTEXT_ACTION = CONTEXT_ACTION;
        NUMBER_OF_TEMPLATES = 5;
        STATE_TEMPLATE_INDEX = STATE_TEMPLATE_INDEX;
        STATE_TEMPLATE_ARRAY = STATE_TEMPLATE_ARRAY;
        STATE_INITIALIZED = STATE_INITIALIZED;
        STATE_ACTION = STATE_ACTION;
        STATE_ALERT_MESSAGE = STATE_ALERT_MESSAGE;
        STATE_SORT_BY = STATE_SORT_BY;
        STATE_SORT_ASC = STATE_SORT_ASC;
        STATE_MY_COPYRIGHT = STATE_MY_COPYRIGHT;
        COPYRIGHT_SYMBOL = COPYRIGHT_SYMBOL;
        SECTION_DELIMITER = SECTION_DELIMITER;
        STATE_TERM_SELECTED = STATE_TERM_SELECTED;
        NULL_STRING = NULL_STRING;
        FINISHED_STRING = FINISHED_STRING;
        NO_SITE_SELECTED_STRING = NO_SITE_SELECTED_STRING;
        NO_FEATURES_SELECTED_STRING = NO_FEATURES_SELECTED_STRING;
        NO_STATE_SITE_INSTANCE_STRING = NO_STATE_SITE_INSTANCE_STRING;
        NO_STATE_SITE_INFO_STRING = NO_STATE_SITE_INFO_STRING;
        NO_STATE_PROFILE_STRING = NO_STATE_PROFILE_STRING;
        MORE_THAN_ONE_SITE_SELECTED_STRING = MORE_THAN_ONE_SITE_SELECTED_STRING;
        AFFILIATIONS = new String[]{"None", "LS&amp;A", "College of Architecture and Urban Planning", "School of Art and Design", "Business School", "School of Dentistry", "School of Education", "College of Engineering", "School of Information", "Division of Kinesiology", "Law School", "Medical School", "School of Music", "School of Natural Resources and Environment", "School of Nursing", "Officer Education Programs", "College of Pharmacy", "School of Public Health", "School of Public Policy", "Rackham School of Graduate Studies", "School of Social Work", "UM Dearborn", "UM Flint"};
        HONORIFICS = new String[]{"None", "Dr.", "Ms.", "Mr.", "Mrs.", "Professor"};
        TERMS = new String[]{"Fall 2003", "Winter 2004", "Spring 2004", "Spring-Summer 2004", "Summer 2004", "Fall 2004"};
    }

    public class SiteListItem {
        public String id = "";
        public String title = "";
        public String by = "";
        public String course_subject = "";
        public List sections = new Vector();

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getBy() {
            return this.by;
        }

        public String getCourse_subject() {
            return this.course_subject;
        }

        public List getSections() {
            return this.sections;
        }
    }

    public class SiteInfo {
        public int term = 0;
        public String course = "";
        public String subject = "";
        public int reuse = 0;
        public int related_class = 0;
        public int related_project = 0;
        public String site_id = "";
        public String external_id = "";
        public String site_type = "CTNG-undefined";
        public String iconUrl = "";
        public String infoUrl = "";
        public String skin = "";
        public boolean joinable = false;
        public String joinerRole = "";
        public String title = "";
        public String description = "";
        public String additional = "";
        public String sections = "";

        public int getTerm() {
            return this.term;
        }

        public String getCourse() {
            return this.course;
        }

        public String getSubject() {
            return this.subject;
        }

        public int getReuse() {
            return this.reuse;
        }

        public int getRelatedClass() {
            return this.related_class;
        }

        public int getRelatedProject() {
            return this.related_project;
        }

        public String getSiteId() {
            return this.site_id;
        }

        public String getSiteType() {
            return this.site_type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public String getInfoUrll() {
            return this.infoUrl;
        }

        public String getSkin() {
            return this.skin;
        }

        public boolean getJoinable() {
            return this.joinable;
        }

        public String getJoinerRole() {
            return this.joinerRole;
        }

        public String getAdditional() {
            return this.additional;
        }

        public String getSections() {
            return this.sections;
        }
    }

    public class Profile {
        public String institution = "";
        public int affiliation = 0;
        public int subject = 0;
        public int course = 0;
        public int honorific = 0;
        public String office = "";
        public String phone = "";
        public String email = "";

        public int getAffiliation() {
            return this.affiliation;
        }

        public int getSubject() {
            return this.subject;
        }

        public int getCourse() {
            return this.course;
        }

        public int getHonorific() {
            return this.honorific;
        }

        public String getOffice() {
            return this.office;
        }

        public String getPhone() {
            return this.phone;
        }

        public String getEmail() {
            return this.email;
        }
    }

    public class Student {
        public String name = "";
        public String uniqname = "";
        public String id = "";
        public String level = "";
        public String credits = "";

        public String getName() {
            return this.name;
        }

        public String getUniqname() {
            return this.uniqname;
        }

        public String getId() {
            return this.id;
        }

        public String getLevel() {
            return this.level;
        }

        public String getCredits() {
            return this.credits;
        }
    }

    public class Participant {
        public String name = "";
        public String uniqname = "";
        public Set roles = new HashSet();

        public String getName() {
            return this.name;
        }

        public String getUniqname() {
            return this.uniqname;
        }

        public Set getRoles() {
            return this.roles;
        }

        public boolean hasRole(String id) {
            boolean m_hasRole = false;
            Iterator i = this.roles.iterator();
            while (i.hasNext()) {
                Role role = (Role)i.next();
                if (!role.getId().equals(id)) continue;
                m_hasRole = true;
            }
            return m_hasRole;
        }
    }

    public class Tool {
        public String id = "";
        public String title = "";
        public String description = "";
        public boolean selected = false;

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean getSelected() {
            return this.selected;
        }
    }

    public class IdAndText {
        public int id;
        public String text;

        public int getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }
    }

    public class Skin {
        public String css;
        public String unit;

        public String getCss() {
            return this.css;
        }

        public String getUnit() {
            return this.unit;
        }
    }

    public class CourseListItem {
        public String year = "";
        public String term_code = "";
        public String campus_code = "";
        public String subject = "";
        public String catalog_nbr = "";
        public String class_section = "";
        public String title = "";
        public String url = "";
        public String component = "";
        public String role = "";
        public String subrole = "";
        public String crosslist = "";
        public String key = "";

        public String getYear() {
            return this.year;
        }

        public String getTerm_code() {
            return this.term_code;
        }

        public String getCampus_code() {
            return this.campus_code;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getCatalog_nbr() {
            return this.catalog_nbr;
        }

        public String getClass_section() {
            return this.class_section;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            return this.url;
        }

        public String getComponent() {
            return this.component;
        }

        public String getRole() {
            return this.role;
        }

        public String getSubrole() {
            return this.subrole;
        }

        public String getCrosslist() {
            return this.crosslist;
        }

        public String getKey() {
            return this.key;
        }
    }

    private class InstructorSection {
        String year = "";
        String term_code = "";
        String campus_code = "";
        String subject = "";
        String catalog_nbr = "";
        String title = "";
        String class_section = "";
        String url = "";
        String component = "";
        String role = "";
        String subrole = "";

        private InstructorSection() {
        }
    }
}

