MODULE YOMHOOK

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

! Used by "hook" function
! LHOOK = true implies "hook" function will be called
! Altough initialized to TRUE it will be reset by first call to 
! DR_HOOK unless we really want to use the hook function

SAVE
PUBLIC

LOGICAL :: LHOOK=.TRUE.

INTERFACE
#include "dr_hook_util.h"
#include "dr_hook_util_multi.h"
END INTERFACE

INTERFACE DR_HOOK  
! We want compile time mapping of DR_HOOK-arguments and not
! to test OPTIONAL-arguments with PRESENT()-function, since
! it costs more.
! However, this "unrolling" approach cannot be streched much more
! than this without making number of member-functions too large
! (i.e. all the possible permutations of these "optional" args;
!  arguments that are not present in the DR_HOOK_DEFAULT -version)

MODULE PROCEDURE &
  DR_HOOK_DEFAULT, &
  DR_HOOK_FILE, &
  DR_HOOK_SIZE, &
  DR_HOOK_FILE_SIZE, &
  DR_HOOK_MULTI_DEFAULT, &
  DR_HOOK_MULTI_FILE, &
  DR_HOOK_MULTI_SIZE, &
  DR_HOOK_MULTI_FILE_SIZE
END INTERFACE

CONTAINS 

SUBROUTINE DR_HOOK_DEFAULT(CDNAME,KSWITCH,PKEY)
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIM),        INTENT(IN) :: KSWITCH
REAL(KIND=JPRB),        INTENT(INOUT) :: PKEY
CALL DR_HOOK_UTIL(CDNAME,KSWITCH,PKEY,'',0)
END SUBROUTINE DR_HOOK_DEFAULT

SUBROUTINE DR_HOOK_MULTI_DEFAULT(CDNAME,KSWITCH,PKEY)
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIM),        INTENT(IN) :: KSWITCH
REAL(KIND=JPRB),        INTENT(INOUT) :: PKEY(:)
CALL DR_HOOK_UTIL_MULTI(CDNAME,KSWITCH,PKEY,SIZE(PKEY),'',0)
END SUBROUTINE DR_HOOK_MULTI_DEFAULT



SUBROUTINE DR_HOOK_FILE(CDNAME,KSWITCH,PKEY,CDFILE)
CHARACTER(LEN=*), INTENT(IN) :: CDNAME,CDFILE
INTEGER(KIND=JPIM),        INTENT(IN) :: KSWITCH
REAL(KIND=JPRB),        INTENT(INOUT) :: PKEY
CALL DR_HOOK_UTIL(CDNAME,KSWITCH,PKEY,CDFILE,0)
END SUBROUTINE DR_HOOK_FILE

SUBROUTINE DR_HOOK_MULTI_FILE(CDNAME,KSWITCH,PKEY,CDFILE)
CHARACTER(LEN=*), INTENT(IN) :: CDNAME,CDFILE
INTEGER(KIND=JPIM),        INTENT(IN) :: KSWITCH
REAL(KIND=JPRB),        INTENT(INOUT) :: PKEY(:)
CALL DR_HOOK_UTIL_MULTI(CDNAME,KSWITCH,PKEY,SIZE(PKEY),CDFILE,0)
END SUBROUTINE DR_HOOK_MULTI_FILE



SUBROUTINE DR_HOOK_SIZE(CDNAME,KSWITCH,PKEY,KSIZEINFO)
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIM),        INTENT(IN) :: KSWITCH,KSIZEINFO
REAL(KIND=JPRB),        INTENT(INOUT) :: PKEY
CALL DR_HOOK_UTIL(CDNAME,KSWITCH,PKEY,'',KSIZEINFO)
END SUBROUTINE DR_HOOK_SIZE

SUBROUTINE DR_HOOK_MULTI_SIZE(CDNAME,KSWITCH,PKEY,KSIZEINFO)
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIM),        INTENT(IN) :: KSWITCH,KSIZEINFO
REAL(KIND=JPRB),        INTENT(INOUT) :: PKEY(:)
CALL DR_HOOK_UTIL_MULTI(CDNAME,KSWITCH,PKEY,SIZE(PKEY),'',KSIZEINFO)
END SUBROUTINE DR_HOOK_MULTI_SIZE



SUBROUTINE DR_HOOK_FILE_SIZE(CDNAME,KSWITCH,PKEY,CDFILE,KSIZEINFO)
CHARACTER(LEN=*), INTENT(IN) :: CDNAME,CDFILE
INTEGER(KIND=JPIM),        INTENT(IN) :: KSWITCH,KSIZEINFO
REAL(KIND=JPRB),        INTENT(INOUT) :: PKEY
CALL DR_HOOK_UTIL(CDNAME,KSWITCH,PKEY,CDFILE,KSIZEINFO)
END SUBROUTINE DR_HOOK_FILE_SIZE

SUBROUTINE DR_HOOK_MULTI_FILE_SIZE(CDNAME,KSWITCH,PKEY,CDFILE,KSIZEINFO)
CHARACTER(LEN=*), INTENT(IN) :: CDNAME,CDFILE
INTEGER(KIND=JPIM),        INTENT(IN) :: KSWITCH,KSIZEINFO
REAL(KIND=JPRB),        INTENT(INOUT) :: PKEY(:)
CALL DR_HOOK_UTIL_MULTI(CDNAME,KSWITCH,PKEY,SIZE(PKEY),CDFILE,KSIZEINFO)
END SUBROUTINE DR_HOOK_MULTI_FILE_SIZE

END MODULE YOMHOOK
