use strict;
use warnings;

use Test::More;
use Test::Command::Simple;
use Cwd qw(cwd);
use File::HomeDir::Test;
use File::HomeDir;
use File::Path qw(make_path);
use Test::TempDir::Tiny;

my @CMD = qw/ontospy gendocs/;
my $CMD = join ' ', @CMD;

run_ok @CMD;
like stdout, qr/Usage: $CMD/, 'Testing stdout';
cmp_ok stderr, 'eq', '', 'Testing stderr';

run_ok @CMD, '--help';
like stdout, qr/Usage: $CMD/, 'Testing stdout';
cmp_ok stderr, 'eq', '', 'Testing stderr';

my $FOAF = 'file://' . cwd . '/ontospy/tests/rdf/foaf.rdf';

ok $ENV{HOME} = File::HomeDir->my_home, 'create fake $HOME';
ok make_path "$ENV{HOME}/.ontospy/models", 'create $HOME/.ontospy/models';

in_tempdir "gendocs" => sub {
	run_ok @CMD, qw(--type 1), $FOAF;
	like stdout, qr/Loading graph.*\nBuilding visualization/, 'Testing stdout';
	like stderr, qr(^Done\.), 'Testing stderr';

	run_ok @CMD, qw(--type 3), $FOAF;
	like stdout, qr/Loading graph.*\nBuilding visualization/, 'Testing stdout';
	like stderr, qr(^Done\.), 'Testing stderr';
};

done_testing;
