/*
 * Copyright (c) 2004-2005 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2006 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2007 High Performance Computing Center Stuttgart,
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2005 The Regents of the University of California.
 *                         All rights reserved.
 * Copyright (c) 2007-2012 Cisco Systems, Inc.  All rights reserved.
 * Copyright (c) 2008-2009 Sun Microsystems, Inc.  All rights reserved.
 * Copyright (c) 2009      Oak Ridge National Labs.  All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#ifndef USE_MPI_F08_CONSTANTS_H
#define USE_MPI_F08_CONSTANTS_H

/*
 * This file contains macro definitions for parameter values used in the
 * MPI_F08 Fortran bindings.  The values are the same as those in
 * ompi/include/mpif-common.h and are generated by the script
 * TODO FIXME ompi/xxx/mpif-common.pl.
 */

#define OMPI_MPI_COMM_WORLD       0
#define OMPI_MPI_COMM_SELF        1
#define OMPI_MPI_GROUP_EMPTY      1
#define OMPI_MPI_ERRORS_ARE_FATAL 1
#define OMPI_MPI_ERRORS_RETURN    2

/*
 * NULL 'handles' (indices)
 */

#define OMPI_MPI_GROUP_NULL      0
#define OMPI_MPI_COMM_NULL       2
#define OMPI_MPI_DATATYPE_NULL   0
#define OMPI_MPI_REQUEST_NULL    0
#define OMPI_MPI_OP_NULL         0
#define OMPI_MPI_ERRHANDLER_NULL 0
#define OMPI_MPI_INFO_NULL       0
#define OMPI_MPI_WIN_NULL        0

#define OMPI_MPI_BYTE                1
#define OMPI_MPI_PACKED              2
#define OMPI_MPI_UB                  3
#define OMPI_MPI_LB                  4
#define OMPI_MPI_CHARACTER           5
#define OMPI_MPI_LOGICAL             6
#define OMPI_MPI_INTEGER             7
#define OMPI_MPI_INTEGER1            8
#define OMPI_MPI_INTEGER2            9
#define OMPI_MPI_INTEGER4           10
#define OMPI_MPI_INTEGER8           11
#define OMPI_MPI_INTEGER16          12
#define OMPI_MPI_REAL               13
#define OMPI_MPI_REAL4              14
#define OMPI_MPI_REAL8              15
#define OMPI_MPI_REAL16             16
#define OMPI_MPI_DOUBLE_PRECISION   17
#define OMPI_MPI_COMPLEX            18
#define OMPI_MPI_COMPLEX8           19
#define OMPI_MPI_COMPLEX16          20
#define OMPI_MPI_COMPLEX32          21
#define OMPI_MPI_DOUBLE_COMPLEX     22
#define OMPI_MPI_2REAL              23
#define OMPI_MPI_2DOUBLE_PRECISION  24
#define OMPI_MPI_2INTEGER           25
#define OMPI_MPI_2COMPLEX           26
#define OMPI_MPI_2DOUBLE_COMPLEX    27
#define OMPI_MPI_REAL2              28
#define OMPI_MPI_LOGICAL1           29
#define OMPI_MPI_LOGICAL2           30
#define OMPI_MPI_LOGICAL4           31
#define OMPI_MPI_LOGICAL8           32

#endif /* USE_MPI_F08_CONSTANTS_H */
