#!/usr/bin/python

import sys

import osc.cmdln as cmdln

import osc_plugin_dput

@cmdln.option('--maintained-in-git', action='store_true',
              help='add MAINTAINED_IN_GIT.txt')
def do_dput(self, subcmd, opts, proj_name, dsc_file):
    """
    ${cmd_name}: Automate the process of submiting a debian package to the OBS server.

    It expects a PROJECT_NAME and a .dsc, source .changes file, or
    source + binary .changes file. If used with a source + binary .changes
    file, the binaries will not be used.

    Usage:
        osc [global options] dput PROJECT_NAME PACKAGE.dsc
        osc [global options] dput PROJECT_NAME PACKAGE_source.changes
    """

    # in older versions of osc, this ends up in the class namespace (!)
    if hasattr(self, "osc_plugin_dput"):
        osc_plugin_dput = self.osc_plugin_dput

    osc_plugin_dput.do_dput(self, subcmd, opts, proj_name, dsc_file)
