/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.image;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.ScaleFilter;

public class BilinearScaleFilter
implements ScaleFilter {
    private NIOBufferImage srcImage;
    private int srcWidth;
    private int srcHeight;
    private int srcComponents;

    public BilinearScaleFilter(NIOBufferImage nIOBufferImage) {
        this.srcImage = nIOBufferImage;
        this.srcWidth = nIOBufferImage.getWidth();
        this.srcHeight = nIOBufferImage.getHeight();
        this.srcComponents = nIOBufferImage.getType().size;
    }

    public NIOBufferImage getScaledImage(int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * this.srcComponents);
        byteBuffer.order(ByteOrder.nativeOrder());
        ByteBuffer byteBuffer2 = this.srcImage.getBuffer();
        byteBuffer2.rewind();
        this.process(n, n2, byteBuffer2, byteBuffer);
        NIOBufferImage nIOBufferImage = new NIOBufferImage(n, n2, this.srcImage.getType(), this.srcImage.isGrayScale(), byteBuffer);
        return nIOBufferImage;
    }

    private void process(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        float f = (float)this.srcWidth / (float)n;
        float f2 = (float)this.srcHeight / (float)n2;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3;
                int n4 = (int)Math.floor((float)j * f);
                int n5 = (int)Math.floor((float)i * f2);
                int n6 = n4 + 1;
                if (n6 >= this.srcWidth) {
                    n6 = n4;
                }
                if ((n3 = n5 + 1) >= this.srcHeight) {
                    n3 = n5;
                }
                float f3 = (float)j * f - (float)n4;
                float f4 = (float)i * f2 - (float)n5;
                float f5 = 1.0f - f3;
                float f6 = 1.0f - f4;
                int n7 = n5 * this.srcWidth * this.srcComponents;
                int n8 = n3 * this.srcWidth * this.srcComponents;
                int n9 = n4 * this.srcComponents;
                int n10 = n6 * this.srcComponents;
                int n11 = n7 + n9;
                int n12 = n7 + n10;
                int n13 = n8 + n9;
                int n14 = n8 + n10;
                for (int k = 0; k < this.srcComponents; ++k) {
                    float f7 = f5 * (float)(0xFF & byteBuffer.get(n11++)) + f3 * (float)(0xFF & byteBuffer.get(n12++));
                    float f8 = f5 * (float)(0xFF & byteBuffer.get(n13++)) + f3 * (float)(0xFF & byteBuffer.get(n14++));
                    byte by = (byte)(f6 * f7 + f4 * f8);
                    byteBuffer2.put(by);
                }
            }
        }
    }
}

