/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import weka.gui.Messages;

public class SplashWindow
extends Window {
    private static final long serialVersionUID = -2685134277041307795L;
    private static SplashWindow m_instance;
    private Image image;
    private boolean paintCalled = false;

    private SplashWindow(Frame parent, Image image) {
        super(parent);
        this.image = image;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int imgWidth = image.getWidth(this);
        int imgHeight = image.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - imgWidth) / 2, (screenDim.height - imgHeight) / 2);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent evt) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(disposeOnClick);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(Image image) {
        if (m_instance == null && image != null) {
            Frame f = new Frame();
            m_instance = new SplashWindow(f, image);
            m_instance.show();
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = m_instance;
                synchronized (splashWindow) {
                    while (!SplashWindow.m_instance.paintCalled) {
                        try {
                            m_instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public static void splash(URL imageURL) {
        if (imageURL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL));
        }
    }

    public static void disposeSplash() {
        if (m_instance != null) {
            m_instance.getOwner().dispose();
            m_instance = null;
        }
    }

    public static void invokeMethod(String className, String methodName, String[] args) {
        try {
            Class.forName(className).getMethod(methodName, String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            InternalError error = new InternalError(stringBuilder.append(Messages.getString("SplashWindow_InvokeMethod_Exception_InternalError_Text")).append(methodName).toString());
            error.initCause(e);
            throw error;
        }
    }

    public static void invokeMain(String className, String[] args) {
        try {
            Class.forName(className).getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            Messages.getInstance();
            InternalError error = new InternalError(Messages.getString("SplashWindow_InvokeMain_Exception_InternalError_Text"));
            error.initCause(e);
            throw error;
        }
    }
}

