import os
import sys

try:
    # TODO: If we made the tests dir a package this could be avoided by using
    # package-relative imports
    import conv_base
except ImportError:
    sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__),
                                                    os.pardir)))
    import conv_base


class Test1461(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),18.0,vegamag)"
        cls.fname="C1461_%s.fits"
        cls.setup2()

class Test1462(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(icat(k93models,9230,0.0,4.1),band(johnson,v),23.0,vegamag)"
        cls.fname="C1462_%s.fits"
        cls.setup2()

class Test1463(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_1.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.04,gal1)"
        cls.fname="C1463_%s.fits"
        cls.setup2()

class Test1464(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_1.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.08,gal1)"
        cls.fname="C1464_%s.fits"
        cls.setup2()

class Test1465(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_10.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.16,smc)"
        cls.fname="C1465_%s.fits"
        cls.setup2()

class Test1466(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_11.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.2,lmc)"
        cls.fname="C1466_%s.fits"
        cls.setup2()

class Test1467(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_12.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.24,xgal)"
        cls.fname="C1467_%s.fits"
        cls.setup2()

class Test1468(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_14.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.08,gal1)"
        cls.fname="C1468_%s.fits"
        cls.setup2()

class Test1469(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_2.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.12,gal3)"
        cls.fname="C1469_%s.fits"
        cls.setup2()

class Test1470(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_2.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.16,smc)"
        cls.fname="C1470_%s.fits"
        cls.setup2()

class Test1471(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_3.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.2,lmc)"
        cls.fname="C1471_%s.fits"
        cls.setup2()

class Test1472(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_4.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.24,xgal)"
        cls.fname="C1472_%s.fits"
        cls.setup2()

class Test1473(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_5.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.04,gal1)"
        cls.fname="C1473_%s.fits"
        cls.setup2()

class Test1474(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_5.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.08,gal1)"
        cls.fname="C1474_%s.fits"
        cls.setup2()

class Test1475(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_6.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.12,gal3)"
        cls.fname="C1475_%s.fits"
        cls.setup2()

class Test1476(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141"
        cls.spectrum="rn(spec($PYSYN_CDBS/grid/pickles/dat_uvk/pickles_uk_9.fits),band(cousins,i),23.0,vegamag)*ebmvx(0.04,gal1)"
        cls.fname="C1476_%s.fits"
        cls.setup2()

class Test1477(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141,bkg"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),21.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1477_%s.fits"
        cls.setup2()

class Test1478(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141,bkg"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.1,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1478_%s.fits"
        cls.setup2()

class Test1479(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141,bkg"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.424602593467696,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1479_%s.fits"
        cls.setup2()

class Test1480(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141,bkg"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1480_%s.fits"
        cls.setup2()

class Test1481(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141,bkg"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),23.3,vegamag)+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1481_%s.fits"
        cls.setup2()

class Test1482(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="wfc3,ir,g141,bkg"
        cls.spectrum="spec(earthshine.fits)*0.5+spec(Zodi.fits)*0.5+(spec(el1215a.fits)+spec(el1302a.fits)+spec(el1356a.fits)+spec(el2471a.fits))"
        cls.fname="C1482_%s.fits"
        cls.setup2()

