# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource_py3 import ProxyResource


class Endpoint(ProxyResource):
    """Class representing a Traffic Manager endpoint.

    :param id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
    :type id: str
    :param name: The name of the resource
    :type name: str
    :param type: The type of the resource. Ex-
     Microsoft.Network/trafficManagerProfiles.
    :type type: str
    :param target_resource_id: The Azure Resource URI of the of the endpoint.
     Not applicable to endpoints of type 'ExternalEndpoints'.
    :type target_resource_id: str
    :param target: The fully-qualified DNS name or IP address of the endpoint.
     Traffic Manager returns this value in DNS responses to direct traffic to
     this endpoint.
    :type target: str
    :param endpoint_status: The status of the endpoint. If the endpoint is
     Enabled, it is probed for endpoint health and is included in the traffic
     routing method. Possible values include: 'Enabled', 'Disabled'
    :type endpoint_status: str or
     ~azure.mgmt.trafficmanager.models.EndpointStatus
    :param weight: The weight of this endpoint when using the 'Weighted'
     traffic routing method. Possible values are from 1 to 1000.
    :type weight: long
    :param priority: The priority of this endpoint when using the 'Priority'
     traffic routing method. Possible values are from 1 to 1000, lower values
     represent higher priority. This is an optional parameter.  If specified,
     it must be specified on all endpoints, and no two endpoints can share the
     same priority value.
    :type priority: long
    :param endpoint_location: Specifies the location of the external or nested
     endpoints when using the 'Performance' traffic routing method.
    :type endpoint_location: str
    :param endpoint_monitor_status: The monitoring status of the endpoint.
     Possible values include: 'CheckingEndpoint', 'Online', 'Degraded',
     'Disabled', 'Inactive', 'Stopped'
    :type endpoint_monitor_status: str or
     ~azure.mgmt.trafficmanager.models.EndpointMonitorStatus
    :param min_child_endpoints: The minimum number of endpoints that must be
     available in the child profile in order for the parent profile to be
     considered available. Only applicable to endpoint of type
     'NestedEndpoints'.
    :type min_child_endpoints: long
    :param geo_mapping: The list of countries/regions mapped to this endpoint
     when using the 'Geographic' traffic routing method. Please consult Traffic
     Manager Geographic documentation for a full list of accepted values.
    :type geo_mapping: list[str]
    :param subnets: The list of subnets, IP addresses, and/or address ranges
     mapped to this endpoint when using the 'Subnet' traffic routing method. An
     empty list will match all ranges not covered by other endpoints.
    :type subnets:
     list[~azure.mgmt.trafficmanager.models.EndpointPropertiesSubnetsItem]
    :param custom_headers: List of custom headers.
    :type custom_headers:
     list[~azure.mgmt.trafficmanager.models.EndpointPropertiesCustomHeadersItem]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'endpoint_status': {'key': 'properties.endpointStatus', 'type': 'str'},
        'weight': {'key': 'properties.weight', 'type': 'long'},
        'priority': {'key': 'properties.priority', 'type': 'long'},
        'endpoint_location': {'key': 'properties.endpointLocation', 'type': 'str'},
        'endpoint_monitor_status': {'key': 'properties.endpointMonitorStatus', 'type': 'str'},
        'min_child_endpoints': {'key': 'properties.minChildEndpoints', 'type': 'long'},
        'geo_mapping': {'key': 'properties.geoMapping', 'type': '[str]'},
        'subnets': {'key': 'properties.subnets', 'type': '[EndpointPropertiesSubnetsItem]'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '[EndpointPropertiesCustomHeadersItem]'},
    }

    def __init__(self, *, id: str=None, name: str=None, type: str=None, target_resource_id: str=None, target: str=None, endpoint_status=None, weight: int=None, priority: int=None, endpoint_location: str=None, endpoint_monitor_status=None, min_child_endpoints: int=None, geo_mapping=None, subnets=None, custom_headers=None, **kwargs) -> None:
        super(Endpoint, self).__init__(id=id, name=name, type=type, **kwargs)
        self.target_resource_id = target_resource_id
        self.target = target
        self.endpoint_status = endpoint_status
        self.weight = weight
        self.priority = priority
        self.endpoint_location = endpoint_location
        self.endpoint_monitor_status = endpoint_monitor_status
        self.min_child_endpoints = min_child_endpoints
        self.geo_mapping = geo_mapping
        self.subnets = subnets
        self.custom_headers = custom_headers
