// ==========================================================
// Definition of CelestLab Physical data  
// 
// Syntax: 
// data.name = value
// (scilab syntax)
// 
// Warning: 
// Most names are used in CelestLab, and consequently
// should not be changed. 
// ==========================================================

// ----------------------------------------------------------
// Default values for some quantities (Earth gravity)
// NB: data from EGM96s gravity model (if not mentioned otherwise)
// See also: solar_system_data.scd (same values for Earth)  
// ----------------------------------------------------------

// Equatorial radius - Earth [m]
data.eqRad = 6378136.3

// Oblateness - Earth  (WGS84)
data.obla = 1.0 / 298.257223563; 

// Gravitational constant (m^3/s^2) - Earth
data.mu = 3.986004415e14 

// Loads spherical harmonics  
gravmod = CL_fo_gravityLoad("egm96s.scd", %t);

// Zonal (unnormalized) harmonics from gravity model (real values)
// NB: Jk = -Ck0 = csnm(k+1,1) 
data.j1jn = - real(gravmod.csnm(2:$,1)); 

// Tesseral/sectorial (unnormalized) harmonics from gravity model (complex values)
// NB: cs1nm(n,m) = Cnm + %i * Snm = csnm(n+1,m+1)
data.cs1nm = gravmod.csnm(2:$, 2:$); 


// ----------------------------------------------------------
// Other data
// ----------------------------------------------------------

// Speed of light - IAU 2009 [m/s]
data.lightSpeed = 299792458  

// astronomical unit - IAU 2009 [m]
data.au = 149597870700;

// Acceleration on Earth at altitude 0 due to gravity [m/s^2] - Standard value
data.g0 = 9.80665  

// Universal gravitational constant - IAU 2009 [m^3.s^-2.kg^-1]
data.gravCst = 6.67428e-11 

// Angular rotation rate of the Earth [rad/s] - Veis frame
data.rotrEarth_Veis = 0.000072921151467052095767345660

// Earth-Sun inertial rotation period, consistent with rotrEarth_Veis [rad/s]  
// 86400 = 2*%pi / (rotrEarth_Veis - rotrEarthSun_Veis)
data.rotrEarthSun_Veis = 0.000000199099300621696728858545

// Angular rotation rate of the Earth [rad/s] - CIRS frame (IERS2010)
data.rotrEarth_CIRS = 0.000072921151467069794052379124

// Earth-Sun inertial rotation period, consistent with rotrEarth_CIRS [rad/s]  
// 86400 = 2*%pi / (rotrEarth_CIRS - rotrEarthSun_CIRS)
data.rotrEarthSun_CIRS = 0.000000199099300639395013892009

// Default angular rotation rate of the Earth and Earth-Sun inertial rotation period
// depending on the configuration (preferences) of CelestLab (ECI frame)
if (CL_configGet("ECI_frame") == "Veis")
  data.rotrBody = data.rotrEarth_Veis
  data.rotrBodySun = data.rotrEarthSun_Veis
elseif (CL_configGet("ECI_frame") == "CIRS")
  data.rotrBody = data.rotrEarth_CIRS
  data.rotrBodySun = data.rotrEarthSun_CIRS
end


// Total Solar irradiance at 1 AU [W/m2]
// SRP coefficient = TSI / lightSpeed 
// Value adjusted so that value of SRP coef = that of STELA (0.45605E-5) 
data.totalSolarIrradiance = 1367.203504709 

