/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "math/sinewindows.h"

namespace Math {

static const float sineWindow32[32] = {
	0.024541f, 0.073565f, 0.122411f, 0.170962f, 0.219101f, 0.266713f, 0.313682f, 0.359895f,
	0.405241f, 0.449611f, 0.492898f, 0.534998f, 0.575808f, 0.615232f, 0.653173f, 0.689541f,
	0.724247f, 0.757209f, 0.788346f, 0.817585f, 0.844854f, 0.870087f, 0.893224f, 0.914210f,
	0.932993f, 0.949528f, 0.963776f, 0.975702f, 0.985278f, 0.992480f, 0.997290f, 0.999699f
};

static const float sineWindow64[64] = {
	0.012272f, 0.036807f, 0.061321f, 0.085797f, 0.110222f, 0.134581f, 0.158858f, 0.183040f,
	0.207111f, 0.231058f, 0.254866f, 0.278520f, 0.302006f, 0.325310f, 0.348419f, 0.371317f,
	0.393992f, 0.416430f, 0.438616f, 0.460539f, 0.482184f, 0.503538f, 0.524590f, 0.545325f,
	0.565732f, 0.585798f, 0.605511f, 0.624860f, 0.643832f, 0.662416f, 0.680601f, 0.698376f,
	0.715731f, 0.732654f, 0.749136f, 0.765167f, 0.780737f, 0.795837f, 0.810457f, 0.824589f,
	0.838225f, 0.851355f, 0.863973f, 0.876070f, 0.887640f, 0.898674f, 0.909168f, 0.919114f,
	0.928506f, 0.937339f, 0.945607f, 0.953306f, 0.960431f, 0.966976f, 0.972940f, 0.978317f,
	0.983105f, 0.987301f, 0.990903f, 0.993907f, 0.996313f, 0.998118f, 0.999322f, 0.999925f
};

static const float sineWindow128[128] = {
	0.006136f, 0.018407f, 0.030675f, 0.042938f, 0.055195f, 0.067444f, 0.079682f, 0.091909f,
	0.104122f, 0.116319f, 0.128498f, 0.140658f, 0.152797f, 0.164913f, 0.177004f, 0.189069f,
	0.201105f, 0.213110f, 0.225084f, 0.237024f, 0.248928f, 0.260794f, 0.272621f, 0.284408f,
	0.296151f, 0.307850f, 0.319502f, 0.331106f, 0.342661f, 0.354164f, 0.365613f, 0.377007f,
	0.388345f, 0.399624f, 0.410843f, 0.422000f, 0.433094f, 0.444122f, 0.455084f, 0.465977f,
	0.476799f, 0.487550f, 0.498228f, 0.508830f, 0.519356f, 0.529804f, 0.540172f, 0.550458f,
	0.560662f, 0.570781f, 0.580814f, 0.590760f, 0.600616f, 0.610383f, 0.620057f, 0.629638f,
	0.639124f, 0.648514f, 0.657807f, 0.667000f, 0.676093f, 0.685084f, 0.693971f, 0.702755f,
	0.711432f, 0.720002f, 0.728464f, 0.736817f, 0.745058f, 0.753187f, 0.761202f, 0.769103f,
	0.776888f, 0.784557f, 0.792107f, 0.799537f, 0.806848f, 0.814036f, 0.821102f, 0.828045f,
	0.834863f, 0.841555f, 0.848120f, 0.854558f, 0.860867f, 0.867046f, 0.873095f, 0.879012f,
	0.884797f, 0.890449f, 0.895966f, 0.901349f, 0.906596f, 0.911706f, 0.916679f, 0.921514f,
	0.926210f, 0.930767f, 0.935183f, 0.939459f, 0.943593f, 0.947586f, 0.951435f, 0.955141f,
	0.958703f, 0.962121f, 0.965394f, 0.968522f, 0.971504f, 0.974339f, 0.977028f, 0.979570f,
	0.981964f, 0.984210f, 0.986308f, 0.988258f, 0.990058f, 0.991710f, 0.993212f, 0.994565f,
	0.995767f, 0.996820f, 0.997723f, 0.998476f, 0.999078f, 0.999529f, 0.999831f, 0.999981f
};

static const float sineWindow256[256] = {
	0.003068f, 0.009204f, 0.015339f, 0.021474f, 0.027608f, 0.033741f, 0.039873f, 0.046003f,
	0.052132f, 0.058258f, 0.064383f, 0.070505f, 0.076624f, 0.082740f, 0.088854f, 0.094963f,
	0.101070f, 0.107172f, 0.113271f, 0.119365f, 0.125455f, 0.131540f, 0.137620f, 0.143695f,
	0.149765f, 0.155828f, 0.161886f, 0.167938f, 0.173984f, 0.180023f, 0.186055f, 0.192080f,
	0.198098f, 0.204109f, 0.210112f, 0.216107f, 0.222094f, 0.228072f, 0.234042f, 0.240003f,
	0.245955f, 0.251898f, 0.257831f, 0.263755f, 0.269668f, 0.275572f, 0.281465f, 0.287347f,
	0.293219f, 0.299080f, 0.304929f, 0.310767f, 0.316593f, 0.322408f, 0.328210f, 0.334000f,
	0.339777f, 0.345541f, 0.351293f, 0.357031f, 0.362756f, 0.368467f, 0.374164f, 0.379847f,
	0.385516f, 0.391170f, 0.396810f, 0.402435f, 0.408044f, 0.413638f, 0.419217f, 0.424780f,
	0.430326f, 0.435857f, 0.441371f, 0.446869f, 0.452350f, 0.457813f, 0.463260f, 0.468689f,
	0.474100f, 0.479494f, 0.484869f, 0.490227f, 0.495565f, 0.500885f, 0.506187f, 0.511469f,
	0.516732f, 0.521975f, 0.527199f, 0.532403f, 0.537587f, 0.542751f, 0.547894f, 0.553017f,
	0.558119f, 0.563199f, 0.568259f, 0.573297f, 0.578314f, 0.583309f, 0.588282f, 0.593232f,
	0.598161f, 0.603067f, 0.607950f, 0.612810f, 0.617647f, 0.622461f, 0.627252f, 0.632019f,
	0.636762f, 0.641481f, 0.646176f, 0.650847f, 0.655493f, 0.660114f, 0.664711f, 0.669283f,
	0.673829f, 0.678350f, 0.682846f, 0.687315f, 0.691759f, 0.696177f, 0.700569f, 0.704934f,
	0.709273f, 0.713585f, 0.717870f, 0.722128f, 0.726359f, 0.730563f, 0.734739f, 0.738887f,
	0.743008f, 0.747101f, 0.751165f, 0.755201f, 0.759209f, 0.763188f, 0.767139f, 0.771061f,
	0.774953f, 0.778817f, 0.782651f, 0.786455f, 0.790230f, 0.793975f, 0.797691f, 0.801376f,
	0.805031f, 0.808656f, 0.812251f, 0.815814f, 0.819348f, 0.822850f, 0.826321f, 0.829761f,
	0.833170f, 0.836548f, 0.839894f, 0.843208f, 0.846491f, 0.849742f, 0.852961f, 0.856147f,
	0.859302f, 0.862424f, 0.865514f, 0.868571f, 0.871595f, 0.874587f, 0.877545f, 0.880471f,
	0.883363f, 0.886223f, 0.889048f, 0.891841f, 0.894599f, 0.897325f, 0.900016f, 0.902673f,
	0.905297f, 0.907886f, 0.910441f, 0.912962f, 0.915449f, 0.917901f, 0.920318f, 0.922701f,
	0.925049f, 0.927363f, 0.929641f, 0.931884f, 0.934093f, 0.936266f, 0.938404f, 0.940506f,
	0.942573f, 0.944605f, 0.946601f, 0.948561f, 0.950486f, 0.952375f, 0.954228f, 0.956045f,
	0.957826f, 0.959571f, 0.961280f, 0.962953f, 0.964590f, 0.966190f, 0.967754f, 0.969281f,
	0.970772f, 0.972227f, 0.973644f, 0.975025f, 0.976370f, 0.977677f, 0.978948f, 0.980182f,
	0.981379f, 0.982539f, 0.983662f, 0.984748f, 0.985798f, 0.986809f, 0.987784f, 0.988722f,
	0.989622f, 0.990485f, 0.991311f, 0.992099f, 0.992850f, 0.993564f, 0.994240f, 0.994879f,
	0.995481f, 0.996045f, 0.996571f, 0.997060f, 0.997511f, 0.997925f, 0.998302f, 0.998640f,
	0.998941f, 0.999205f, 0.999431f, 0.999619f, 0.999769f, 0.999882f, 0.999958f, 0.999995f
};

static const float sineWindow512[512] = {
	0.001534f, 0.004602f, 0.007670f, 0.010738f, 0.013805f, 0.016873f, 0.019940f, 0.023008f,
	0.026075f, 0.029142f, 0.032208f, 0.035274f, 0.038340f, 0.041406f, 0.044471f, 0.047535f,
	0.050600f, 0.053664f, 0.056727f, 0.059790f, 0.062852f, 0.065913f, 0.068974f, 0.072035f,
	0.075094f, 0.078153f, 0.081211f, 0.084269f, 0.087326f, 0.090381f, 0.093436f, 0.096490f,
	0.099544f, 0.102596f, 0.105647f, 0.108697f, 0.111747f, 0.114795f, 0.117842f, 0.120888f,
	0.123933f, 0.126977f, 0.130019f, 0.133061f, 0.136101f, 0.139139f, 0.142177f, 0.145213f,
	0.148248f, 0.151281f, 0.154313f, 0.157343f, 0.160372f, 0.163400f, 0.166426f, 0.169450f,
	0.172473f, 0.175494f, 0.178514f, 0.181532f, 0.184548f, 0.187562f, 0.190575f, 0.193586f,
	0.196595f, 0.199602f, 0.202607f, 0.205610f, 0.208612f, 0.211611f, 0.214609f, 0.217604f,
	0.220598f, 0.223589f, 0.226578f, 0.229565f, 0.232550f, 0.235533f, 0.238514f, 0.241492f,
	0.244468f, 0.247442f, 0.250413f, 0.253382f, 0.256349f, 0.259313f, 0.262275f, 0.265234f,
	0.268191f, 0.271145f, 0.274097f, 0.277046f, 0.279993f, 0.282937f, 0.285878f, 0.288816f,
	0.291752f, 0.294685f, 0.297616f, 0.300543f, 0.303468f, 0.306390f, 0.309309f, 0.312225f,
	0.315138f, 0.318048f, 0.320955f, 0.323859f, 0.326760f, 0.329658f, 0.332553f, 0.335445f,
	0.338334f, 0.341219f, 0.344101f, 0.346980f, 0.349856f, 0.352729f, 0.355598f, 0.358463f,
	0.361326f, 0.364185f, 0.367040f, 0.369892f, 0.372741f, 0.375586f, 0.378428f, 0.381266f,
	0.384100f, 0.386931f, 0.389758f, 0.392582f, 0.395401f, 0.398218f, 0.401030f, 0.403838f,
	0.406643f, 0.409444f, 0.412241f, 0.415034f, 0.417824f, 0.420609f, 0.423390f, 0.426168f,
	0.428941f, 0.431711f, 0.434476f, 0.437237f, 0.439994f, 0.442747f, 0.445496f, 0.448241f,
	0.450981f, 0.453717f, 0.456449f, 0.459177f, 0.461900f, 0.464619f, 0.467333f, 0.470043f,
	0.472749f, 0.475450f, 0.478147f, 0.480839f, 0.483527f, 0.486210f, 0.488889f, 0.491563f,
	0.494232f, 0.496897f, 0.499557f, 0.502212f, 0.504863f, 0.507509f, 0.510150f, 0.512786f,
	0.515418f, 0.518044f, 0.520666f, 0.523283f, 0.525895f, 0.528502f, 0.531104f, 0.533701f,
	0.536293f, 0.538880f, 0.541462f, 0.544039f, 0.546610f, 0.549177f, 0.551738f, 0.554294f,
	0.556845f, 0.559391f, 0.561931f, 0.564466f, 0.566996f, 0.569521f, 0.572040f, 0.574553f,
	0.577062f, 0.579565f, 0.582062f, 0.584554f, 0.587040f, 0.589521f, 0.591997f, 0.594467f,
	0.596931f, 0.599389f, 0.601842f, 0.604290f, 0.606731f, 0.609167f, 0.611597f, 0.614022f,
	0.616440f, 0.618853f, 0.621260f, 0.623661f, 0.626056f, 0.628446f, 0.630829f, 0.633207f,
	0.635578f, 0.637944f, 0.640303f, 0.642657f, 0.645005f, 0.647346f, 0.649681f, 0.652011f,
	0.654334f, 0.656651f, 0.658961f, 0.661266f, 0.663564f, 0.665856f, 0.668142f, 0.670422f,
	0.672695f, 0.674962f, 0.677222f, 0.679476f, 0.681724f, 0.683965f, 0.686200f, 0.688429f,
	0.690651f, 0.692866f, 0.695075f, 0.697277f, 0.699473f, 0.701663f, 0.703845f, 0.706021f,
	0.708191f, 0.710353f, 0.712509f, 0.714659f, 0.716801f, 0.718937f, 0.721066f, 0.723189f,
	0.725304f, 0.727413f, 0.729514f, 0.731609f, 0.733697f, 0.735779f, 0.737853f, 0.739920f,
	0.741980f, 0.744034f, 0.746080f, 0.748119f, 0.750152f, 0.752177f, 0.754195f, 0.756206f,
	0.758210f, 0.760207f, 0.762196f, 0.764179f, 0.766154f, 0.768122f, 0.770083f, 0.772036f,
	0.773983f, 0.775922f, 0.777853f, 0.779778f, 0.781695f, 0.783605f, 0.785507f, 0.787402f,
	0.789289f, 0.791169f, 0.793042f, 0.794907f, 0.796765f, 0.798615f, 0.800458f, 0.802293f,
	0.804120f, 0.805940f, 0.807753f, 0.809558f, 0.811355f, 0.813144f, 0.814926f, 0.816701f,
	0.818467f, 0.820226f, 0.821977f, 0.823721f, 0.825456f, 0.827184f, 0.828904f, 0.830616f,
	0.832321f, 0.834018f, 0.835706f, 0.837387f, 0.839060f, 0.840725f, 0.842383f, 0.844032f,
	0.845673f, 0.847307f, 0.848932f, 0.850550f, 0.852159f, 0.853760f, 0.855354f, 0.856939f,
	0.858516f, 0.860085f, 0.861646f, 0.863199f, 0.864744f, 0.866281f, 0.867809f, 0.869330f,
	0.870842f, 0.872346f, 0.873842f, 0.875329f, 0.876809f, 0.878280f, 0.879743f, 0.881197f,
	0.882643f, 0.884081f, 0.885511f, 0.886932f, 0.888345f, 0.889750f, 0.891146f, 0.892534f,
	0.893913f, 0.895284f, 0.896646f, 0.898001f, 0.899346f, 0.900683f, 0.902012f, 0.903332f,
	0.904644f, 0.905947f, 0.907242f, 0.908528f, 0.909806f, 0.911075f, 0.912335f, 0.913587f,
	0.914830f, 0.916065f, 0.917291f, 0.918508f, 0.919717f, 0.920917f, 0.922109f, 0.923291f,
	0.924465f, 0.925631f, 0.926787f, 0.927935f, 0.929075f, 0.930205f, 0.931327f, 0.932440f,
	0.933544f, 0.934639f, 0.935726f, 0.936803f, 0.937872f, 0.938932f, 0.939984f, 0.941026f,
	0.942060f, 0.943084f, 0.944100f, 0.945107f, 0.946105f, 0.947094f, 0.948075f, 0.949046f,
	0.950008f, 0.950962f, 0.951906f, 0.952842f, 0.953768f, 0.954686f, 0.955594f, 0.956494f,
	0.957385f, 0.958266f, 0.959139f, 0.960002f, 0.960857f, 0.961702f, 0.962538f, 0.963366f,
	0.964184f, 0.964993f, 0.965793f, 0.966584f, 0.967366f, 0.968139f, 0.968903f, 0.969657f,
	0.970403f, 0.971139f, 0.971866f, 0.972584f, 0.973293f, 0.973993f, 0.974684f, 0.975365f,
	0.976037f, 0.976700f, 0.977354f, 0.977998f, 0.978634f, 0.979260f, 0.979877f, 0.980485f,
	0.981083f, 0.981673f, 0.982253f, 0.982824f, 0.983385f, 0.983937f, 0.984480f, 0.985014f,
	0.985539f, 0.986054f, 0.986560f, 0.987057f, 0.987544f, 0.988022f, 0.988491f, 0.988950f,
	0.989400f, 0.989841f, 0.990273f, 0.990695f, 0.991108f, 0.991511f, 0.991906f, 0.992291f,
	0.992666f, 0.993032f, 0.993389f, 0.993737f, 0.994075f, 0.994404f, 0.994723f, 0.995033f,
	0.995334f, 0.995625f, 0.995907f, 0.996180f, 0.996443f, 0.996697f, 0.996941f, 0.997176f,
	0.997402f, 0.997618f, 0.997825f, 0.998023f, 0.998211f, 0.998390f, 0.998559f, 0.998719f,
	0.998870f, 0.999011f, 0.999142f, 0.999265f, 0.999378f, 0.999481f, 0.999575f, 0.999660f,
	0.999735f, 0.999801f, 0.999858f, 0.999905f, 0.999942f, 0.999971f, 0.999989f, 0.999999f
};

static const float sineWindow1024[1024] = {
	0.000767f, 0.002301f, 0.003835f, 0.005369f, 0.006903f, 0.008437f, 0.009971f, 0.011505f,
	0.013038f, 0.014572f, 0.016106f, 0.017640f, 0.019174f, 0.020707f, 0.022241f, 0.023774f,
	0.025308f, 0.026841f, 0.028375f, 0.029908f, 0.031441f, 0.032975f, 0.034508f, 0.036041f,
	0.037574f, 0.039107f, 0.040639f, 0.042172f, 0.043705f, 0.045237f, 0.046769f, 0.048302f,
	0.049834f, 0.051366f, 0.052898f, 0.054429f, 0.055961f, 0.057493f, 0.059024f, 0.060555f,
	0.062086f, 0.063617f, 0.065148f, 0.066679f, 0.068209f, 0.069739f, 0.071270f, 0.072800f,
	0.074329f, 0.075859f, 0.077389f, 0.078918f, 0.080447f, 0.081976f, 0.083505f, 0.085033f,
	0.086561f, 0.088090f, 0.089617f, 0.091145f, 0.092673f, 0.094200f, 0.095727f, 0.097254f,
	0.098780f, 0.100307f, 0.101833f, 0.103359f, 0.104884f, 0.106410f, 0.107935f, 0.109460f,
	0.110984f, 0.112509f, 0.114033f, 0.115557f, 0.117080f, 0.118604f, 0.120127f, 0.121649f,
	0.123172f, 0.124694f, 0.126216f, 0.127737f, 0.129259f, 0.130780f, 0.132300f, 0.133821f,
	0.135341f, 0.136860f, 0.138380f, 0.139899f, 0.141418f, 0.142936f, 0.144454f, 0.145972f,
	0.147489f, 0.149006f, 0.150523f, 0.152039f, 0.153555f, 0.155071f, 0.156586f, 0.158101f,
	0.159615f, 0.161129f, 0.162643f, 0.164157f, 0.165670f, 0.167182f, 0.168694f, 0.170206f,
	0.171718f, 0.173229f, 0.174739f, 0.176249f, 0.177759f, 0.179268f, 0.180777f, 0.182286f,
	0.183794f, 0.185302f, 0.186809f, 0.188315f, 0.189822f, 0.191328f, 0.192833f, 0.194338f,
	0.195843f, 0.197347f, 0.198850f, 0.200353f, 0.201856f, 0.203358f, 0.204860f, 0.206361f,
	0.207862f, 0.209362f, 0.210862f, 0.212361f, 0.213860f, 0.215358f, 0.216856f, 0.218353f,
	0.219850f, 0.221346f, 0.222841f, 0.224337f, 0.225831f, 0.227325f, 0.228819f, 0.230312f,
	0.231804f, 0.233296f, 0.234788f, 0.236278f, 0.237769f, 0.239258f, 0.240748f, 0.242236f,
	0.243724f, 0.245212f, 0.246698f, 0.248185f, 0.249670f, 0.251155f, 0.252640f, 0.254124f,
	0.255607f, 0.257090f, 0.258572f, 0.260054f, 0.261534f, 0.263015f, 0.264494f, 0.265973f,
	0.267452f, 0.268930f, 0.270407f, 0.271883f, 0.273359f, 0.274834f, 0.276309f, 0.277783f,
	0.279256f, 0.280729f, 0.282201f, 0.283672f, 0.285143f, 0.286613f, 0.288082f, 0.289551f,
	0.291019f, 0.292486f, 0.293952f, 0.295418f, 0.296883f, 0.298348f, 0.299812f, 0.301275f,
	0.302737f, 0.304199f, 0.305660f, 0.307120f, 0.308579f, 0.310038f, 0.311496f, 0.312953f,
	0.314410f, 0.315866f, 0.317321f, 0.318775f, 0.320229f, 0.321682f, 0.323134f, 0.324585f,
	0.326035f, 0.327485f, 0.328934f, 0.330382f, 0.331830f, 0.333277f, 0.334723f, 0.336168f,
	0.337612f, 0.339055f, 0.340498f, 0.341940f, 0.343381f, 0.344821f, 0.346261f, 0.347700f,
	0.349138f, 0.350575f, 0.352011f, 0.353446f, 0.354881f, 0.356314f, 0.357747f, 0.359179f,
	0.360611f, 0.362041f, 0.363470f, 0.364899f, 0.366327f, 0.367754f, 0.369180f, 0.370605f,
	0.372029f, 0.373453f, 0.374875f, 0.376297f, 0.377718f, 0.379138f, 0.380557f, 0.381975f,
	0.383392f, 0.384808f, 0.386224f, 0.387638f, 0.389052f, 0.390464f, 0.391876f, 0.393287f,
	0.394697f, 0.396106f, 0.397514f, 0.398921f, 0.400327f, 0.401732f, 0.403137f, 0.404540f,
	0.405942f, 0.407344f, 0.408744f, 0.410144f, 0.411542f, 0.412940f, 0.414336f, 0.415732f,
	0.417127f, 0.418520f, 0.419913f, 0.421305f, 0.422695f, 0.424085f, 0.425474f, 0.426862f,
	0.428248f, 0.429634f, 0.431019f, 0.432402f, 0.433785f, 0.435167f, 0.436547f, 0.437927f,
	0.439305f, 0.440683f, 0.442059f, 0.443435f, 0.444809f, 0.446183f, 0.447555f, 0.448926f,
	0.450296f, 0.451665f, 0.453033f, 0.454400f, 0.455766f, 0.457131f, 0.458495f, 0.459858f,
	0.461219f, 0.462580f, 0.463939f, 0.465298f, 0.466655f, 0.468011f, 0.469366f, 0.470720f,
	0.472073f, 0.473425f, 0.474775f, 0.476125f, 0.477473f, 0.478821f, 0.480167f, 0.481512f,
	0.482856f, 0.484198f, 0.485540f, 0.486880f, 0.488220f, 0.489558f, 0.490895f, 0.492231f,
	0.493565f, 0.494899f, 0.496231f, 0.497562f, 0.498893f, 0.500221f, 0.501549f, 0.502876f,
	0.504201f, 0.505525f, 0.506848f, 0.508170f, 0.509490f, 0.510810f, 0.512128f, 0.513445f,
	0.514760f, 0.516075f, 0.517388f, 0.518700f, 0.520011f, 0.521321f, 0.522629f, 0.523937f,
	0.525243f, 0.526547f, 0.527851f, 0.529153f, 0.530454f, 0.531754f, 0.533052f, 0.534349f,
	0.535645f, 0.536940f, 0.538234f, 0.539526f, 0.540817f, 0.542106f, 0.543395f, 0.544682f,
	0.545968f, 0.547252f, 0.548536f, 0.549817f, 0.551098f, 0.552378f, 0.553656f, 0.554932f,
	0.556208f, 0.557482f, 0.558755f, 0.560026f, 0.561297f, 0.562565f, 0.563833f, 0.565099f,
	0.566364f, 0.567628f, 0.568890f, 0.570151f, 0.571410f, 0.572669f, 0.573925f, 0.575181f,
	0.576435f, 0.577688f, 0.578939f, 0.580189f, 0.581438f, 0.582685f, 0.583931f, 0.585176f,
	0.586419f, 0.587661f, 0.588902f, 0.590141f, 0.591378f, 0.592615f, 0.593850f, 0.595083f,
	0.596315f, 0.597546f, 0.598775f, 0.600003f, 0.601230f, 0.602455f, 0.603678f, 0.604900f,
	0.606121f, 0.607341f, 0.608559f, 0.609775f, 0.610990f, 0.612204f, 0.613416f, 0.614627f,
	0.615836f, 0.617044f, 0.618250f, 0.619455f, 0.620659f, 0.621861f, 0.623061f, 0.624260f,
	0.625458f, 0.626654f, 0.627849f, 0.629042f, 0.630234f, 0.631424f, 0.632613f, 0.633800f,
	0.634986f, 0.636170f, 0.637353f, 0.638534f, 0.639714f, 0.640892f, 0.642069f, 0.643245f,
	0.644418f, 0.645590f, 0.646761f, 0.647930f, 0.649098f, 0.650264f, 0.651429f, 0.652592f,
	0.653753f, 0.654913f, 0.656072f, 0.657229f, 0.658384f, 0.659538f, 0.660690f, 0.661841f,
	0.662990f, 0.664138f, 0.665284f, 0.666428f, 0.667571f, 0.668712f, 0.669852f, 0.670990f,
	0.672127f, 0.673262f, 0.674396f, 0.675527f, 0.676658f, 0.677786f, 0.678913f, 0.680039f,
	0.681163f, 0.682285f, 0.683406f, 0.684525f, 0.685642f, 0.686758f, 0.687872f, 0.688985f,
	0.690096f, 0.691205f, 0.692313f, 0.693419f, 0.694523f, 0.695626f, 0.696728f, 0.697827f,
	0.698925f, 0.700021f, 0.701116f, 0.702209f, 0.703300f, 0.704390f, 0.705478f, 0.706564f,
	0.707649f, 0.708732f, 0.709813f, 0.710893f, 0.711971f, 0.713047f, 0.714122f, 0.715195f,
	0.716266f, 0.717336f, 0.718404f, 0.719470f, 0.720535f, 0.721597f, 0.722659f, 0.723718f,
	0.724776f, 0.725832f, 0.726886f, 0.727939f, 0.728990f, 0.730039f, 0.731086f, 0.732132f,
	0.733176f, 0.734218f, 0.735259f, 0.736298f, 0.737335f, 0.738370f, 0.739404f, 0.740436f,
	0.741466f, 0.742494f, 0.743521f, 0.744546f, 0.745569f, 0.746591f, 0.747610f, 0.748628f,
	0.749644f, 0.750659f, 0.751671f, 0.752682f, 0.753691f, 0.754698f, 0.755704f, 0.756708f,
	0.757710f, 0.758710f, 0.759708f, 0.760705f, 0.761700f, 0.762693f, 0.763684f, 0.764673f,
	0.765661f, 0.766647f, 0.767631f, 0.768613f, 0.769593f, 0.770572f, 0.771549f, 0.772524f,
	0.773497f, 0.774468f, 0.775438f, 0.776405f, 0.777371f, 0.778335f, 0.779297f, 0.780258f,
	0.781216f, 0.782173f, 0.783128f, 0.784081f, 0.785032f, 0.785981f, 0.786929f, 0.787874f,
	0.788818f, 0.789760f, 0.790700f, 0.791638f, 0.792575f, 0.793509f, 0.794442f, 0.795372f,
	0.796301f, 0.797228f, 0.798153f, 0.799076f, 0.799998f, 0.800917f, 0.801835f, 0.802750f,
	0.803664f, 0.804576f, 0.805486f, 0.806394f, 0.807300f, 0.808205f, 0.809107f, 0.810008f,
	0.810906f, 0.811803f, 0.812698f, 0.813591f, 0.814482f, 0.815371f, 0.816258f, 0.817143f,
	0.818026f, 0.818908f, 0.819787f, 0.820664f, 0.821540f, 0.822414f, 0.823285f, 0.824155f,
	0.825023f, 0.825889f, 0.826753f, 0.827615f, 0.828475f, 0.829333f, 0.830189f, 0.831043f,
	0.831895f, 0.832746f, 0.833594f, 0.834440f, 0.835285f, 0.836127f, 0.836968f, 0.837806f,
	0.838643f, 0.839477f, 0.840310f, 0.841140f, 0.841969f, 0.842796f, 0.843620f, 0.844443f,
	0.845264f, 0.846082f, 0.846899f, 0.847714f, 0.848526f, 0.849337f, 0.850146f, 0.850953f,
	0.851757f, 0.852560f, 0.853361f, 0.854159f, 0.854956f, 0.855751f, 0.856543f, 0.857334f,
	0.858123f, 0.858909f, 0.859694f, 0.860476f, 0.861257f, 0.862035f, 0.862812f, 0.863586f,
	0.864359f, 0.865129f, 0.865898f, 0.866664f, 0.867428f, 0.868190f, 0.868951f, 0.869709f,
	0.870465f, 0.871219f, 0.871971f, 0.872721f, 0.873469f, 0.874215f, 0.874958f, 0.875700f,
	0.876440f, 0.877177f, 0.877913f, 0.878646f, 0.879378f, 0.880107f, 0.880834f, 0.881559f,
	0.882283f, 0.883004f, 0.883723f, 0.884439f, 0.885154f, 0.885867f, 0.886578f, 0.887286f,
	0.887993f, 0.888697f, 0.889399f, 0.890099f, 0.890798f, 0.891494f, 0.892187f, 0.892879f,
	0.893569f, 0.894257f, 0.894942f, 0.895625f, 0.896307f, 0.896986f, 0.897663f, 0.898338f,
	0.899011f, 0.899681f, 0.900350f, 0.901016f, 0.901681f, 0.902343f, 0.903003f, 0.903661f,
	0.904317f, 0.904971f, 0.905622f, 0.906272f, 0.906919f, 0.907564f, 0.908207f, 0.908848f,
	0.909487f, 0.910124f, 0.910758f, 0.911391f, 0.912021f, 0.912649f, 0.913275f, 0.913899f,
	0.914520f, 0.915140f, 0.915757f, 0.916372f, 0.916985f, 0.917596f, 0.918205f, 0.918811f,
	0.919416f, 0.920018f, 0.920618f, 0.921216f, 0.921812f, 0.922405f, 0.922997f, 0.923586f,
	0.924173f, 0.924758f, 0.925340f, 0.925921f, 0.926499f, 0.927075f, 0.927649f, 0.928221f,
	0.928791f, 0.929358f, 0.929923f, 0.930486f, 0.931047f, 0.931606f, 0.932162f, 0.932716f,
	0.933269f, 0.933818f, 0.934366f, 0.934912f, 0.935455f, 0.935996f, 0.936535f, 0.937072f,
	0.937606f, 0.938138f, 0.938668f, 0.939196f, 0.939722f, 0.940245f, 0.940766f, 0.941285f,
	0.941802f, 0.942317f, 0.942829f, 0.943339f, 0.943847f, 0.944353f, 0.944856f, 0.945358f,
	0.945857f, 0.946353f, 0.946848f, 0.947340f, 0.947830f, 0.948318f, 0.948804f, 0.949287f,
	0.949768f, 0.950247f, 0.950724f, 0.951199f, 0.951671f, 0.952141f, 0.952609f, 0.953074f,
	0.953537f, 0.953998f, 0.954457f, 0.954914f, 0.955368f, 0.955820f, 0.956270f, 0.956717f,
	0.957163f, 0.957606f, 0.958047f, 0.958485f, 0.958921f, 0.959355f, 0.959787f, 0.960217f,
	0.960644f, 0.961069f, 0.961492f, 0.961912f, 0.962330f, 0.962746f, 0.963160f, 0.963571f,
	0.963980f, 0.964387f, 0.964792f, 0.965194f, 0.965594f, 0.965992f, 0.966387f, 0.966781f,
	0.967172f, 0.967560f, 0.967947f, 0.968331f, 0.968713f, 0.969092f, 0.969470f, 0.969845f,
	0.970217f, 0.970588f, 0.970956f, 0.971322f, 0.971685f, 0.972047f, 0.972406f, 0.972762f,
	0.973117f, 0.973469f, 0.973819f, 0.974166f, 0.974512f, 0.974855f, 0.975195f, 0.975534f,
	0.975870f, 0.976204f, 0.976535f, 0.976864f, 0.977191f, 0.977516f, 0.977838f, 0.978158f,
	0.978476f, 0.978791f, 0.979104f, 0.979415f, 0.979724f, 0.980030f, 0.980334f, 0.980635f,
	0.980935f, 0.981232f, 0.981526f, 0.981819f, 0.982109f, 0.982396f, 0.982682f, 0.982965f,
	0.983246f, 0.983524f, 0.983800f, 0.984074f, 0.984346f, 0.984615f, 0.984882f, 0.985146f,
	0.985408f, 0.985668f, 0.985926f, 0.986181f, 0.986434f, 0.986685f, 0.986933f, 0.987179f,
	0.987423f, 0.987664f, 0.987903f, 0.988140f, 0.988374f, 0.988607f, 0.988836f, 0.989064f,
	0.989289f, 0.989511f, 0.989732f, 0.989950f, 0.990166f, 0.990379f, 0.990590f, 0.990799f,
	0.991006f, 0.991210f, 0.991411f, 0.991611f, 0.991808f, 0.992003f, 0.992195f, 0.992385f,
	0.992573f, 0.992759f, 0.992942f, 0.993122f, 0.993301f, 0.993477f, 0.993651f, 0.993822f,
	0.993991f, 0.994158f, 0.994322f, 0.994484f, 0.994644f, 0.994802f, 0.994957f, 0.995109f,
	0.995260f, 0.995408f, 0.995553f, 0.995697f, 0.995838f, 0.995976f, 0.996113f, 0.996247f,
	0.996378f, 0.996507f, 0.996634f, 0.996759f, 0.996881f, 0.997001f, 0.997119f, 0.997234f,
	0.997347f, 0.997457f, 0.997565f, 0.997671f, 0.997774f, 0.997876f, 0.997974f, 0.998071f,
	0.998165f, 0.998257f, 0.998346f, 0.998433f, 0.998518f, 0.998600f, 0.998680f, 0.998758f,
	0.998833f, 0.998906f, 0.998976f, 0.999044f, 0.999110f, 0.999174f, 0.999235f, 0.999294f,
	0.999350f, 0.999404f, 0.999456f, 0.999506f, 0.999553f, 0.999597f, 0.999640f, 0.999680f,
	0.999717f, 0.999753f, 0.999786f, 0.999816f, 0.999844f, 0.999870f, 0.999894f, 0.999915f,
	0.999934f, 0.999950f, 0.999964f, 0.999976f, 0.999986f, 0.999993f, 0.999997f, 1.000000f
};

static const float sineWindow2048[2048] = {
	0.000383f, 0.001150f, 0.001917f, 0.002684f, 0.003451f, 0.004218f, 0.004985f, 0.005752f,
	0.006519f, 0.007286f, 0.008053f, 0.008820f, 0.009587f, 0.010354f, 0.011121f, 0.011888f,
	0.012655f, 0.013422f, 0.014189f, 0.014956f, 0.015723f, 0.016490f, 0.017256f, 0.018023f,
	0.018790f, 0.019557f, 0.020324f, 0.021091f, 0.021857f, 0.022624f, 0.023391f, 0.024158f,
	0.024925f, 0.025691f, 0.026458f, 0.027225f, 0.027991f, 0.028758f, 0.029525f, 0.030291f,
	0.031058f, 0.031825f, 0.032591f, 0.033358f, 0.034124f, 0.034891f, 0.035657f, 0.036424f,
	0.037190f, 0.037957f, 0.038723f, 0.039490f, 0.040256f, 0.041022f, 0.041789f, 0.042555f,
	0.043321f, 0.044088f, 0.044854f, 0.045620f, 0.046386f, 0.047152f, 0.047919f, 0.048685f,
	0.049451f, 0.050217f, 0.050983f, 0.051749f, 0.052515f, 0.053281f, 0.054046f, 0.054812f,
	0.055578f, 0.056344f, 0.057110f, 0.057875f, 0.058641f, 0.059407f, 0.060172f, 0.060938f,
	0.061704f, 0.062469f, 0.063234f, 0.064000f, 0.064765f, 0.065531f, 0.066296f, 0.067061f,
	0.067827f, 0.068592f, 0.069357f, 0.070122f, 0.070887f, 0.071652f, 0.072417f, 0.073182f,
	0.073947f, 0.074712f, 0.075477f, 0.076241f, 0.077006f, 0.077771f, 0.078536f, 0.079300f,
	0.080065f, 0.080829f, 0.081594f, 0.082358f, 0.083122f, 0.083887f, 0.084651f, 0.085415f,
	0.086179f, 0.086943f, 0.087708f, 0.088472f, 0.089236f, 0.089999f, 0.090763f, 0.091527f,
	0.092291f, 0.093055f, 0.093818f, 0.094582f, 0.095345f, 0.096109f, 0.096872f, 0.097635f,
	0.098399f, 0.099162f, 0.099925f, 0.100688f, 0.101451f, 0.102214f, 0.102977f, 0.103740f,
	0.104503f, 0.105266f, 0.106028f, 0.106791f, 0.107554f, 0.108316f, 0.109079f, 0.109841f,
	0.110603f, 0.111366f, 0.112128f, 0.112890f, 0.113652f, 0.114414f, 0.115176f, 0.115938f,
	0.116700f, 0.117461f, 0.118223f, 0.118984f, 0.119746f, 0.120507f, 0.121269f, 0.122030f,
	0.122791f, 0.123552f, 0.124314f, 0.125075f, 0.125835f, 0.126596f, 0.127357f, 0.128118f,
	0.128878f, 0.129639f, 0.130399f, 0.131160f, 0.131920f, 0.132680f, 0.133441f, 0.134201f,
	0.134961f, 0.135721f, 0.136480f, 0.137240f, 0.138000f, 0.138760f, 0.139519f, 0.140279f,
	0.141038f, 0.141797f, 0.142556f, 0.143316f, 0.144075f, 0.144833f, 0.145592f, 0.146351f,
	0.147110f, 0.147868f, 0.148627f, 0.149385f, 0.150144f, 0.150902f, 0.151660f, 0.152418f,
	0.153176f, 0.153934f, 0.154692f, 0.155450f, 0.156207f, 0.156965f, 0.157722f, 0.158480f,
	0.159237f, 0.159994f, 0.160751f, 0.161508f, 0.162265f, 0.163022f, 0.163778f, 0.164535f,
	0.165291f, 0.166048f, 0.166804f, 0.167560f, 0.168316f, 0.169072f, 0.169828f, 0.170584f,
	0.171340f, 0.172095f, 0.172851f, 0.173606f, 0.174362f, 0.175117f, 0.175872f, 0.176627f,
	0.177382f, 0.178136f, 0.178891f, 0.179646f, 0.180400f, 0.181154f, 0.181909f, 0.182663f,
	0.183417f, 0.184171f, 0.184925f, 0.185678f, 0.186432f, 0.187185f, 0.187939f, 0.188692f,
	0.189445f, 0.190198f, 0.190951f, 0.191704f, 0.192457f, 0.193209f, 0.193962f, 0.194714f,
	0.195466f, 0.196219f, 0.196971f, 0.197722f, 0.198474f, 0.199226f, 0.199978f, 0.200729f,
	0.201480f, 0.202231f, 0.202983f, 0.203734f, 0.204484f, 0.205235f, 0.205986f, 0.206736f,
	0.207487f, 0.208237f, 0.208987f, 0.209737f, 0.210487f, 0.211236f, 0.211986f, 0.212736f,
	0.213485f, 0.214234f, 0.214983f, 0.215732f, 0.216481f, 0.217230f, 0.217979f, 0.218727f,
	0.219475f, 0.220224f, 0.220972f, 0.221720f, 0.222468f, 0.223215f, 0.223963f, 0.224710f,
	0.225458f, 0.226205f, 0.226952f, 0.227699f, 0.228445f, 0.229192f, 0.229939f, 0.230685f,
	0.231431f, 0.232177f, 0.232923f, 0.233669f, 0.234415f, 0.235160f, 0.235906f, 0.236651f,
	0.237396f, 0.238141f, 0.238886f, 0.239631f, 0.240375f, 0.241120f, 0.241864f, 0.242608f,
	0.243352f, 0.244096f, 0.244840f, 0.245583f, 0.246327f, 0.247070f, 0.247813f, 0.248556f,
	0.249299f, 0.250042f, 0.250784f, 0.251527f, 0.252269f, 0.253011f, 0.253753f, 0.254495f,
	0.255236f, 0.255978f, 0.256719f, 0.257461f, 0.258202f, 0.258943f, 0.259683f, 0.260424f,
	0.261164f, 0.261905f, 0.262645f, 0.263385f, 0.264125f, 0.264864f, 0.265604f, 0.266343f,
	0.267082f, 0.267821f, 0.268560f, 0.269299f, 0.270038f, 0.270776f, 0.271514f, 0.272252f,
	0.272990f, 0.273728f, 0.274466f, 0.275203f, 0.275940f, 0.276678f, 0.277415f, 0.278151f,
	0.278888f, 0.279624f, 0.280361f, 0.281097f, 0.281833f, 0.282569f, 0.283304f, 0.284040f,
	0.284775f, 0.285510f, 0.286245f, 0.286980f, 0.287715f, 0.288449f, 0.289184f, 0.289918f,
	0.290652f, 0.291385f, 0.292119f, 0.292853f, 0.293586f, 0.294319f, 0.295052f, 0.295785f,
	0.296517f, 0.297250f, 0.297982f, 0.298714f, 0.299446f, 0.300177f, 0.300909f, 0.301640f,
	0.302372f, 0.303103f, 0.303833f, 0.304564f, 0.305294f, 0.306025f, 0.306755f, 0.307485f,
	0.308214f, 0.308944f, 0.309673f, 0.310403f, 0.311132f, 0.311860f, 0.312589f, 0.313318f,
	0.314046f, 0.314774f, 0.315502f, 0.316230f, 0.316957f, 0.317684f, 0.318412f, 0.319139f,
	0.319865f, 0.320592f, 0.321318f, 0.322045f, 0.322771f, 0.323497f, 0.324222f, 0.324948f,
	0.325673f, 0.326398f, 0.327123f, 0.327848f, 0.328572f, 0.329296f, 0.330020f, 0.330744f,
	0.331468f, 0.332192f, 0.332915f, 0.333638f, 0.334361f, 0.335084f, 0.335806f, 0.336529f,
	0.337251f, 0.337973f, 0.338695f, 0.339416f, 0.340138f, 0.340859f, 0.341580f, 0.342300f,
	0.343021f, 0.343741f, 0.344462f, 0.345181f, 0.345901f, 0.346621f, 0.347340f, 0.348059f,
	0.348778f, 0.349497f, 0.350215f, 0.350934f, 0.351652f, 0.352370f, 0.353087f, 0.353805f,
	0.354522f, 0.355239f, 0.355956f, 0.356673f, 0.357389f, 0.358105f, 0.358821f, 0.359537f,
	0.360253f, 0.360968f, 0.361683f, 0.362398f, 0.363113f, 0.363828f, 0.364542f, 0.365256f,
	0.365970f, 0.366684f, 0.367397f, 0.368110f, 0.368823f, 0.369536f, 0.370249f, 0.370961f,
	0.371673f, 0.372385f, 0.373097f, 0.373808f, 0.374520f, 0.375231f, 0.375942f, 0.376652f,
	0.377363f, 0.378073f, 0.378783f, 0.379492f, 0.380202f, 0.380911f, 0.381620f, 0.382329f,
	0.383038f, 0.383746f, 0.384454f, 0.385162f, 0.385870f, 0.386577f, 0.387285f, 0.387992f,
	0.388698f, 0.389405f, 0.390111f, 0.390817f, 0.391523f, 0.392229f, 0.392934f, 0.393640f,
	0.394344f, 0.395049f, 0.395754f, 0.396458f, 0.397162f, 0.397866f, 0.398569f, 0.399273f,
	0.399976f, 0.400679f, 0.401381f, 0.402084f, 0.402786f, 0.403488f, 0.404189f, 0.404891f,
	0.405592f, 0.406293f, 0.406994f, 0.407694f, 0.408394f, 0.409094f, 0.409794f, 0.410494f,
	0.411193f, 0.411892f, 0.412591f, 0.413289f, 0.413987f, 0.414685f, 0.415383f, 0.416081f,
	0.416778f, 0.417475f, 0.418172f, 0.418869f, 0.419565f, 0.420261f, 0.420957f, 0.421653f,
	0.422348f, 0.423043f, 0.423738f, 0.424432f, 0.425127f, 0.425821f, 0.426515f, 0.427208f,
	0.427902f, 0.428595f, 0.429288f, 0.429980f, 0.430673f, 0.431365f, 0.432057f, 0.432748f,
	0.433439f, 0.434131f, 0.434821f, 0.435512f, 0.436202f, 0.436892f, 0.437582f, 0.438272f,
	0.438961f, 0.439650f, 0.440339f, 0.441027f, 0.441715f, 0.442403f, 0.443091f, 0.443779f,
	0.444466f, 0.445153f, 0.445839f, 0.446526f, 0.447212f, 0.447898f, 0.448583f, 0.449269f,
	0.449954f, 0.450639f, 0.451323f, 0.452008f, 0.452692f, 0.453375f, 0.454059f, 0.454742f,
	0.455425f, 0.456108f, 0.456790f, 0.457472f, 0.458154f, 0.458836f, 0.459517f, 0.460198f,
	0.460879f, 0.461560f, 0.462240f, 0.462920f, 0.463600f, 0.464279f, 0.464958f, 0.465637f,
	0.466316f, 0.466994f, 0.467672f, 0.468350f, 0.469028f, 0.469705f, 0.470382f, 0.471058f,
	0.471735f, 0.472411f, 0.473087f, 0.473763f, 0.474438f, 0.475113f, 0.475788f, 0.476462f,
	0.477136f, 0.477810f, 0.478484f, 0.479157f, 0.479830f, 0.480503f, 0.481176f, 0.481848f,
	0.482520f, 0.483191f, 0.483863f, 0.484534f, 0.485205f, 0.485875f, 0.486545f, 0.487215f,
	0.487885f, 0.488554f, 0.489223f, 0.489892f, 0.490561f, 0.491229f, 0.491897f, 0.492564f,
	0.493232f, 0.493899f, 0.494566f, 0.495232f, 0.495898f, 0.496564f, 0.497230f, 0.497895f,
	0.498560f, 0.499225f, 0.499889f, 0.500553f, 0.501217f, 0.501881f, 0.502544f, 0.503207f,
	0.503870f, 0.504532f, 0.505194f, 0.505856f, 0.506517f, 0.507179f, 0.507839f, 0.508500f,
	0.509160f, 0.509820f, 0.510480f, 0.511139f, 0.511798f, 0.512457f, 0.513116f, 0.513774f,
	0.514432f, 0.515089f, 0.515746f, 0.516403f, 0.517060f, 0.517716f, 0.518372f, 0.519028f,
	0.519684f, 0.520339f, 0.520994f, 0.521648f, 0.522302f, 0.522956f, 0.523610f, 0.524263f,
	0.524916f, 0.525569f, 0.526221f, 0.526873f, 0.527525f, 0.528176f, 0.528827f, 0.529478f,
	0.530129f, 0.530779f, 0.531429f, 0.532078f, 0.532728f, 0.533377f, 0.534025f, 0.534674f,
	0.535322f, 0.535969f, 0.536617f, 0.537264f, 0.537910f, 0.538557f, 0.539203f, 0.539849f,
	0.540494f, 0.541139f, 0.541784f, 0.542429f, 0.543073f, 0.543717f, 0.544360f, 0.545004f,
	0.545646f, 0.546289f, 0.546931f, 0.547573f, 0.548215f, 0.548856f, 0.549497f, 0.550138f,
	0.550778f, 0.551418f, 0.552058f, 0.552697f, 0.553336f, 0.553975f, 0.554613f, 0.555251f,
	0.555889f, 0.556526f, 0.557164f, 0.557800f, 0.558437f, 0.559073f, 0.559709f, 0.560344f,
	0.560979f, 0.561614f, 0.562248f, 0.562882f, 0.563516f, 0.564150f, 0.564783f, 0.565416f,
	0.566048f, 0.566680f, 0.567312f, 0.567943f, 0.568574f, 0.569205f, 0.569836f, 0.570466f,
	0.571096f, 0.571725f, 0.572354f, 0.572983f, 0.573611f, 0.574239f, 0.574867f, 0.575495f,
	0.576122f, 0.576748f, 0.577375f, 0.578001f, 0.578627f, 0.579252f, 0.579877f, 0.580502f,
	0.581126f, 0.581750f, 0.582374f, 0.582997f, 0.583620f, 0.584243f, 0.584865f, 0.585487f,
	0.586109f, 0.586730f, 0.587351f, 0.587971f, 0.588592f, 0.589212f, 0.589831f, 0.590450f,
	0.591069f, 0.591688f, 0.592306f, 0.592924f, 0.593541f, 0.594158f, 0.594775f, 0.595391f,
	0.596007f, 0.596623f, 0.597238f, 0.597853f, 0.598468f, 0.599082f, 0.599696f, 0.600310f,
	0.600923f, 0.601536f, 0.602148f, 0.602761f, 0.603372f, 0.603984f, 0.604595f, 0.605206f,
	0.605816f, 0.606426f, 0.607036f, 0.607645f, 0.608254f, 0.608863f, 0.609471f, 0.610079f,
	0.610687f, 0.611294f, 0.611901f, 0.612507f, 0.613113f, 0.613719f, 0.614324f, 0.614929f,
	0.615534f, 0.616138f, 0.616742f, 0.617346f, 0.617949f, 0.618552f, 0.619154f, 0.619756f,
	0.620358f, 0.620959f, 0.621560f, 0.622161f, 0.622761f, 0.623361f, 0.623961f, 0.624560f,
	0.625159f, 0.625757f, 0.626355f, 0.626953f, 0.627550f, 0.628147f, 0.628744f, 0.629340f,
	0.629936f, 0.630532f, 0.631127f, 0.631721f, 0.632316f, 0.632910f, 0.633503f, 0.634097f,
	0.634690f, 0.635282f, 0.635874f, 0.636466f, 0.637057f, 0.637649f, 0.638239f, 0.638829f,
	0.639419f, 0.640009f, 0.640598f, 0.641187f, 0.641775f, 0.642363f, 0.642951f, 0.643538f,
	0.644125f, 0.644711f, 0.645298f, 0.645883f, 0.646469f, 0.647054f, 0.647638f, 0.648222f,
	0.648806f, 0.649390f, 0.649973f, 0.650555f, 0.651138f, 0.651720f, 0.652301f, 0.652882f,
	0.653463f, 0.654044f, 0.654624f, 0.655203f, 0.655782f, 0.656361f, 0.656940f, 0.657518f,
	0.658095f, 0.658673f, 0.659250f, 0.659826f, 0.660402f, 0.660978f, 0.661554f, 0.662128f,
	0.662703f, 0.663277f, 0.663851f, 0.664424f, 0.664997f, 0.665570f, 0.666142f, 0.666714f,
	0.667286f, 0.667857f, 0.668427f, 0.668998f, 0.669567f, 0.670137f, 0.670706f, 0.671275f,
	0.671843f, 0.672411f, 0.672978f, 0.673546f, 0.674112f, 0.674679f, 0.675245f, 0.675810f,
	0.676375f, 0.676940f, 0.677504f, 0.678068f, 0.678632f, 0.679195f, 0.679758f, 0.680320f,
	0.680882f, 0.681443f, 0.682005f, 0.682565f, 0.683126f, 0.683686f, 0.684245f, 0.684804f,
	0.685363f, 0.685921f, 0.686479f, 0.687037f, 0.687594f, 0.688151f, 0.688707f, 0.689263f,
	0.689818f, 0.690373f, 0.690928f, 0.691482f, 0.692036f, 0.692590f, 0.693143f, 0.693695f,
	0.694247f, 0.694799f, 0.695351f, 0.695902f, 0.696452f, 0.697003f, 0.697552f, 0.698102f,
	0.698651f, 0.699199f, 0.699747f, 0.700295f, 0.700842f, 0.701389f, 0.701936f, 0.702482f,
	0.703028f, 0.703573f, 0.704118f, 0.704662f, 0.705206f, 0.705750f, 0.706293f, 0.706836f,
	0.707378f, 0.707920f, 0.708461f, 0.709002f, 0.709543f, 0.710083f, 0.710623f, 0.711163f,
	0.711702f, 0.712240f, 0.712778f, 0.713316f, 0.713853f, 0.714390f, 0.714927f, 0.715463f,
	0.715999f, 0.716534f, 0.717069f, 0.717603f, 0.718137f, 0.718671f, 0.719204f, 0.719736f,
	0.720269f, 0.720800f, 0.721332f, 0.721863f, 0.722393f, 0.722924f, 0.723453f, 0.723983f,
	0.724512f, 0.725040f, 0.725568f, 0.726095f, 0.726623f, 0.727149f, 0.727676f, 0.728202f,
	0.728727f, 0.729252f, 0.729777f, 0.730301f, 0.730825f, 0.731348f, 0.731871f, 0.732393f,
	0.732915f, 0.733437f, 0.733958f, 0.734479f, 0.734999f, 0.735519f, 0.736038f, 0.736557f,
	0.737076f, 0.737594f, 0.738112f, 0.738629f, 0.739146f, 0.739662f, 0.740178f, 0.740694f,
	0.741209f, 0.741723f, 0.742237f, 0.742751f, 0.743265f, 0.743777f, 0.744290f, 0.744802f,
	0.745314f, 0.745825f, 0.746335f, 0.746846f, 0.747355f, 0.747865f, 0.748374f, 0.748882f,
	0.749390f, 0.749898f, 0.750405f, 0.750912f, 0.751418f, 0.751924f, 0.752429f, 0.752934f,
	0.753439f, 0.753943f, 0.754447f, 0.754950f, 0.755453f, 0.755955f, 0.756457f, 0.756958f,
	0.757459f, 0.757960f, 0.758460f, 0.758960f, 0.759459f, 0.759957f, 0.760456f, 0.760954f,
	0.761451f, 0.761948f, 0.762444f, 0.762941f, 0.763436f, 0.763931f, 0.764426f, 0.764920f,
	0.765414f, 0.765907f, 0.766400f, 0.766893f, 0.767385f, 0.767876f, 0.768368f, 0.768858f,
	0.769348f, 0.769838f, 0.770327f, 0.770816f, 0.771305f, 0.771793f, 0.772280f, 0.772767f,
	0.773254f, 0.773740f, 0.774225f, 0.774711f, 0.775195f, 0.775680f, 0.776164f, 0.776647f,
	0.777130f, 0.777612f, 0.778094f, 0.778576f, 0.779057f, 0.779538f, 0.780018f, 0.780498f,
	0.780977f, 0.781456f, 0.781934f, 0.782412f, 0.782889f, 0.783366f, 0.783843f, 0.784319f,
	0.784794f, 0.785269f, 0.785744f, 0.786218f, 0.786692f, 0.787165f, 0.787638f, 0.788110f,
	0.788582f, 0.789054f, 0.789525f, 0.789995f, 0.790465f, 0.790935f, 0.791404f, 0.791873f,
	0.792341f, 0.792808f, 0.793275f, 0.793742f, 0.794209f, 0.794674f, 0.795140f, 0.795605f,
	0.796069f, 0.796533f, 0.796996f, 0.797459f, 0.797922f, 0.798384f, 0.798846f, 0.799307f,
	0.799768f, 0.800228f, 0.800687f, 0.801147f, 0.801605f, 0.802064f, 0.802522f, 0.802979f,
	0.803436f, 0.803892f, 0.804348f, 0.804804f, 0.805259f, 0.805713f, 0.806167f, 0.806621f,
	0.807074f, 0.807527f, 0.807979f, 0.808430f, 0.808882f, 0.809332f, 0.809783f, 0.810233f,
	0.810682f, 0.811131f, 0.811579f, 0.812027f, 0.812474f, 0.812921f, 0.813368f, 0.813814f,
	0.814259f, 0.814704f, 0.815149f, 0.815593f, 0.816036f, 0.816479f, 0.816922f, 0.817364f,
	0.817806f, 0.818247f, 0.818687f, 0.819128f, 0.819567f, 0.820007f, 0.820445f, 0.820884f,
	0.821321f, 0.821759f, 0.822195f, 0.822632f, 0.823068f, 0.823503f, 0.823938f, 0.824372f,
	0.824806f, 0.825240f, 0.825673f, 0.826105f, 0.826537f, 0.826968f, 0.827399f, 0.827830f,
	0.828260f, 0.828690f, 0.829119f, 0.829547f, 0.829975f, 0.830403f, 0.830830f, 0.831256f,
	0.831683f, 0.832108f, 0.832533f, 0.832958f, 0.833382f, 0.833806f, 0.834229f, 0.834652f,
	0.835074f, 0.835496f, 0.835917f, 0.836338f, 0.836758f, 0.837178f, 0.837597f, 0.838015f,
	0.838434f, 0.838852f, 0.839269f, 0.839686f, 0.840102f, 0.840518f, 0.840933f, 0.841348f,
	0.841762f, 0.842176f, 0.842589f, 0.843002f, 0.843414f, 0.843826f, 0.844237f, 0.844648f,
	0.845059f, 0.845469f, 0.845878f, 0.846287f, 0.846695f, 0.847103f, 0.847510f, 0.847917f,
	0.848323f, 0.848729f, 0.849135f, 0.849540f, 0.849944f, 0.850348f, 0.850751f, 0.851154f,
	0.851556f, 0.851958f, 0.852360f, 0.852760f, 0.853161f, 0.853561f, 0.853960f, 0.854359f,
	0.854757f, 0.855155f, 0.855552f, 0.855949f, 0.856345f, 0.856741f, 0.857137f, 0.857531f,
	0.857926f, 0.858320f, 0.858713f, 0.859106f, 0.859498f, 0.859890f, 0.860281f, 0.860672f,
	0.861062f, 0.861452f, 0.861841f, 0.862230f, 0.862618f, 0.863006f, 0.863393f, 0.863780f,
	0.864166f, 0.864552f, 0.864937f, 0.865321f, 0.865706f, 0.866089f, 0.866472f, 0.866855f,
	0.867237f, 0.867619f, 0.868000f, 0.868381f, 0.868761f, 0.869140f, 0.869519f, 0.869898f,
	0.870276f, 0.870654f, 0.871031f, 0.871407f, 0.871783f, 0.872159f, 0.872534f, 0.872908f,
	0.873282f, 0.873655f, 0.874028f, 0.874401f, 0.874773f, 0.875144f, 0.875515f, 0.875885f,
	0.876255f, 0.876624f, 0.876993f, 0.877361f, 0.877729f, 0.878096f, 0.878463f, 0.878829f,
	0.879195f, 0.879560f, 0.879925f, 0.880289f, 0.880653f, 0.881016f, 0.881378f, 0.881740f,
	0.882102f, 0.882463f, 0.882824f, 0.883184f, 0.883543f, 0.883902f, 0.884260f, 0.884618f,
	0.884976f, 0.885333f, 0.885689f, 0.886045f, 0.886400f, 0.886755f, 0.887109f, 0.887463f,
	0.887816f, 0.888169f, 0.888521f, 0.888873f, 0.889224f, 0.889574f, 0.889925f, 0.890274f,
	0.890623f, 0.890972f, 0.891320f, 0.891667f, 0.892014f, 0.892361f, 0.892706f, 0.893052f,
	0.893397f, 0.893741f, 0.894085f, 0.894428f, 0.894771f, 0.895113f, 0.895455f, 0.895796f,
	0.896137f, 0.896477f, 0.896816f, 0.897155f, 0.897494f, 0.897832f, 0.898169f, 0.898506f,
	0.898843f, 0.899179f, 0.899514f, 0.899849f, 0.900183f, 0.900517f, 0.900850f, 0.901183f,
	0.901515f, 0.901847f, 0.902178f, 0.902508f, 0.902838f, 0.903168f, 0.903497f, 0.903825f,
	0.904153f, 0.904481f, 0.904807f, 0.905134f, 0.905460f, 0.905785f, 0.906110f, 0.906434f,
	0.906757f, 0.907081f, 0.907403f, 0.907725f, 0.908047f, 0.908368f, 0.908688f, 0.909008f,
	0.909328f, 0.909647f, 0.909965f, 0.910283f, 0.910600f, 0.910917f, 0.911233f, 0.911548f,
	0.911864f, 0.912178f, 0.912492f, 0.912806f, 0.913119f, 0.913431f, 0.913743f, 0.914054f,
	0.914365f, 0.914675f, 0.914985f, 0.915294f, 0.915603f, 0.915911f, 0.916219f, 0.916526f,
	0.916832f, 0.917138f, 0.917444f, 0.917749f, 0.918053f, 0.918357f, 0.918660f, 0.918963f,
	0.919265f, 0.919567f, 0.919868f, 0.920168f, 0.920468f, 0.920768f, 0.921067f, 0.921365f,
	0.921663f, 0.921960f, 0.922257f, 0.922553f, 0.922849f, 0.923144f, 0.923439f, 0.923733f,
	0.924026f, 0.924319f, 0.924612f, 0.924904f, 0.925195f, 0.925486f, 0.925776f, 0.926066f,
	0.926355f, 0.926643f, 0.926931f, 0.927219f, 0.927506f, 0.927792f, 0.928078f, 0.928364f,
	0.928648f, 0.928933f, 0.929216f, 0.929500f, 0.929782f, 0.930064f, 0.930346f, 0.930627f,
	0.930907f, 0.931187f, 0.931466f, 0.931745f, 0.932023f, 0.932301f, 0.932578f, 0.932855f,
	0.933131f, 0.933406f, 0.933681f, 0.933956f, 0.934229f, 0.934503f, 0.934775f, 0.935048f,
	0.935319f, 0.935590f, 0.935861f, 0.936131f, 0.936400f, 0.936669f, 0.936938f, 0.937205f,
	0.937473f, 0.937739f, 0.938005f, 0.938271f, 0.938536f, 0.938800f, 0.939064f, 0.939328f,
	0.939591f, 0.939853f, 0.940115f, 0.940376f, 0.940636f, 0.940896f, 0.941156f, 0.941415f,
	0.941673f, 0.941931f, 0.942188f, 0.942445f, 0.942701f, 0.942957f, 0.943212f, 0.943466f,
	0.943720f, 0.943974f, 0.944227f, 0.944479f, 0.944731f, 0.944982f, 0.945232f, 0.945483f,
	0.945732f, 0.945981f, 0.946229f, 0.946477f, 0.946724f, 0.946971f, 0.947217f, 0.947463f,
	0.947708f, 0.947953f, 0.948196f, 0.948440f, 0.948683f, 0.948925f, 0.949167f, 0.949408f,
	0.949648f, 0.949888f, 0.950128f, 0.950367f, 0.950605f, 0.950843f, 0.951080f, 0.951317f,
	0.951553f, 0.951789f, 0.952024f, 0.952258f, 0.952492f, 0.952725f, 0.952958f, 0.953190f,
	0.953422f, 0.953653f, 0.953883f, 0.954113f, 0.954343f, 0.954572f, 0.954800f, 0.955028f,
	0.955255f, 0.955481f, 0.955707f, 0.955933f, 0.956158f, 0.956382f, 0.956606f, 0.956829f,
	0.957052f, 0.957274f, 0.957495f, 0.957716f, 0.957937f, 0.958156f, 0.958376f, 0.958594f,
	0.958812f, 0.959030f, 0.959247f, 0.959463f, 0.959679f, 0.959895f, 0.960109f, 0.960324f,
	0.960537f, 0.960750f, 0.960963f, 0.961175f, 0.961386f, 0.961597f, 0.961807f, 0.962017f,
	0.962226f, 0.962434f, 0.962642f, 0.962850f, 0.963057f, 0.963263f, 0.963469f, 0.963674f,
	0.963878f, 0.964082f, 0.964286f, 0.964489f, 0.964691f, 0.964893f, 0.965094f, 0.965294f,
	0.965494f, 0.965694f, 0.965893f, 0.966091f, 0.966289f, 0.966486f, 0.966683f, 0.966879f,
	0.967074f, 0.967269f, 0.967463f, 0.967657f, 0.967850f, 0.968043f, 0.968235f, 0.968427f,
	0.968617f, 0.968808f, 0.968998f, 0.969187f, 0.969375f, 0.969564f, 0.969751f, 0.969938f,
	0.970124f, 0.970310f, 0.970495f, 0.970680f, 0.970864f, 0.971048f, 0.971231f, 0.971413f,
	0.971595f, 0.971776f, 0.971957f, 0.972137f, 0.972316f, 0.972495f, 0.972673f, 0.972851f,
	0.973028f, 0.973205f, 0.973381f, 0.973557f, 0.973732f, 0.973906f, 0.974080f, 0.974253f,
	0.974426f, 0.974598f, 0.974769f, 0.974940f, 0.975110f, 0.975280f, 0.975449f, 0.975618f,
	0.975786f, 0.975954f, 0.976120f, 0.976287f, 0.976453f, 0.976618f, 0.976782f, 0.976946f,
	0.977110f, 0.977273f, 0.977435f, 0.977597f, 0.977758f, 0.977918f, 0.978078f, 0.978238f,
	0.978397f, 0.978555f, 0.978713f, 0.978870f, 0.979026f, 0.979182f, 0.979338f, 0.979493f,
	0.979647f, 0.979800f, 0.979954f, 0.980106f, 0.980258f, 0.980409f, 0.980560f, 0.980710f,
	0.980860f, 0.981009f, 0.981158f, 0.981305f, 0.981453f, 0.981600f, 0.981746f, 0.981891f,
	0.982036f, 0.982181f, 0.982325f, 0.982468f, 0.982611f, 0.982753f, 0.982894f, 0.983035f,
	0.983176f, 0.983315f, 0.983455f, 0.983593f, 0.983731f, 0.983869f, 0.984006f, 0.984142f,
	0.984278f, 0.984413f, 0.984548f, 0.984682f, 0.984815f, 0.984948f, 0.985080f, 0.985212f,
	0.985343f, 0.985474f, 0.985604f, 0.985733f, 0.985862f, 0.985990f, 0.986118f, 0.986245f,
	0.986371f, 0.986497f, 0.986623f, 0.986747f, 0.986871f, 0.986995f, 0.987118f, 0.987240f,
	0.987362f, 0.987484f, 0.987604f, 0.987724f, 0.987844f, 0.987963f, 0.988081f, 0.988199f,
	0.988316f, 0.988433f, 0.988549f, 0.988664f, 0.988779f, 0.988893f, 0.989007f, 0.989120f,
	0.989233f, 0.989345f, 0.989456f, 0.989567f, 0.989677f, 0.989787f, 0.989896f, 0.990004f,
	0.990112f, 0.990219f, 0.990326f, 0.990432f, 0.990538f, 0.990643f, 0.990747f, 0.990851f,
	0.990954f, 0.991057f, 0.991159f, 0.991260f, 0.991361f, 0.991462f, 0.991561f, 0.991660f,
	0.991759f, 0.991857f, 0.991954f, 0.992051f, 0.992147f, 0.992243f, 0.992338f, 0.992433f,
	0.992526f, 0.992620f, 0.992712f, 0.992805f, 0.992896f, 0.992987f, 0.993077f, 0.993167f,
	0.993256f, 0.993345f, 0.993433f, 0.993521f, 0.993608f, 0.993694f, 0.993779f, 0.993865f,
	0.993949f, 0.994033f, 0.994116f, 0.994199f, 0.994281f, 0.994363f, 0.994444f, 0.994525f,
	0.994604f, 0.994684f, 0.994762f, 0.994841f, 0.994918f, 0.994995f, 0.995071f, 0.995147f,
	0.995222f, 0.995297f, 0.995371f, 0.995444f, 0.995517f, 0.995589f, 0.995661f, 0.995732f,
	0.995803f, 0.995872f, 0.995942f, 0.996011f, 0.996079f, 0.996146f, 0.996213f, 0.996280f,
	0.996345f, 0.996411f, 0.996475f, 0.996539f, 0.996603f, 0.996666f, 0.996728f, 0.996790f,
	0.996851f, 0.996911f, 0.996971f, 0.997031f, 0.997089f, 0.997148f, 0.997205f, 0.997262f,
	0.997319f, 0.997374f, 0.997430f, 0.997484f, 0.997538f, 0.997592f, 0.997645f, 0.997697f,
	0.997749f, 0.997800f, 0.997851f, 0.997901f, 0.997950f, 0.997999f, 0.998047f, 0.998094f,
	0.998142f, 0.998188f, 0.998234f, 0.998279f, 0.998324f, 0.998368f, 0.998411f, 0.998454f,
	0.998497f, 0.998538f, 0.998580f, 0.998620f, 0.998660f, 0.998700f, 0.998738f, 0.998777f,
	0.998814f, 0.998851f, 0.998888f, 0.998924f, 0.998959f, 0.998994f, 0.999028f, 0.999061f,
	0.999094f, 0.999126f, 0.999158f, 0.999189f, 0.999220f, 0.999250f, 0.999279f, 0.999308f,
	0.999336f, 0.999364f, 0.999391f, 0.999418f, 0.999443f, 0.999469f, 0.999493f, 0.999518f,
	0.999541f, 0.999564f, 0.999586f, 0.999608f, 0.999629f, 0.999650f, 0.999670f, 0.999689f,
	0.999708f, 0.999726f, 0.999744f, 0.999761f, 0.999778f, 0.999793f, 0.999809f, 0.999823f,
	0.999838f, 0.999851f, 0.999864f, 0.999876f, 0.999888f, 0.999899f, 0.999910f, 0.999920f,
	0.999929f, 0.999938f, 0.999946f, 0.999954f, 0.999961f, 0.999968f, 0.999973f, 0.999979f,
	0.999983f, 0.999988f, 0.999991f, 0.999994f, 0.999996f, 0.999998f, 0.999999f, 1.000000f
};

static const float sineWindow4096[4096] = {
	0.000192f, 0.000575f, 0.000959f, 0.001342f, 0.001726f, 0.002109f, 0.002493f, 0.002876f,
	0.003260f, 0.003643f, 0.004027f, 0.004410f, 0.004794f, 0.005177f, 0.005561f, 0.005944f,
	0.006328f, 0.006711f, 0.007095f, 0.007478f, 0.007862f, 0.008245f, 0.008629f, 0.009012f,
	0.009395f, 0.009779f, 0.010162f, 0.010546f, 0.010929f, 0.011313f, 0.011696f, 0.012080f,
	0.012463f, 0.012847f, 0.013230f, 0.013614f, 0.013997f, 0.014381f, 0.014764f, 0.015147f,
	0.015531f, 0.015914f, 0.016298f, 0.016681f, 0.017065f, 0.017448f, 0.017832f, 0.018215f,
	0.018598f, 0.018982f, 0.019365f, 0.019749f, 0.020132f, 0.020516f, 0.020899f, 0.021282f,
	0.021666f, 0.022049f, 0.022433f, 0.022816f, 0.023199f, 0.023583f, 0.023966f, 0.024350f,
	0.024733f, 0.025116f, 0.025500f, 0.025883f, 0.026266f, 0.026650f, 0.027033f, 0.027416f,
	0.027800f, 0.028183f, 0.028567f, 0.028950f, 0.029333f, 0.029717f, 0.030100f, 0.030483f,
	0.030866f, 0.031250f, 0.031633f, 0.032016f, 0.032400f, 0.032783f, 0.033166f, 0.033550f,
	0.033933f, 0.034316f, 0.034699f, 0.035083f, 0.035466f, 0.035849f, 0.036232f, 0.036616f,
	0.036999f, 0.037382f, 0.037765f, 0.038149f, 0.038532f, 0.038915f, 0.039298f, 0.039681f,
	0.040065f, 0.040448f, 0.040831f, 0.041214f, 0.041597f, 0.041980f, 0.042364f, 0.042747f,
	0.043130f, 0.043513f, 0.043896f, 0.044279f, 0.044662f, 0.045045f, 0.045429f, 0.045812f,
	0.046195f, 0.046578f, 0.046961f, 0.047344f, 0.047727f, 0.048110f, 0.048493f, 0.048876f,
	0.049259f, 0.049642f, 0.050025f, 0.050408f, 0.050791f, 0.051174f, 0.051557f, 0.051940f,
	0.052323f, 0.052706f, 0.053089f, 0.053472f, 0.053855f, 0.054238f, 0.054621f, 0.055004f,
	0.055387f, 0.055770f, 0.056152f, 0.056535f, 0.056918f, 0.057301f, 0.057684f, 0.058067f,
	0.058450f, 0.058833f, 0.059215f, 0.059598f, 0.059981f, 0.060364f, 0.060747f, 0.061129f,
	0.061512f, 0.061895f, 0.062278f, 0.062660f, 0.063043f, 0.063426f, 0.063809f, 0.064191f,
	0.064574f, 0.064957f, 0.065339f, 0.065722f, 0.066105f, 0.066487f, 0.066870f, 0.067253f,
	0.067635f, 0.068018f, 0.068400f, 0.068783f, 0.069166f, 0.069548f, 0.069931f, 0.070313f,
	0.070696f, 0.071078f, 0.071461f, 0.071843f, 0.072226f, 0.072608f, 0.072991f, 0.073373f,
	0.073756f, 0.074138f, 0.074521f, 0.074903f, 0.075286f, 0.075668f, 0.076050f, 0.076433f,
	0.076815f, 0.077197f, 0.077580f, 0.077962f, 0.078344f, 0.078727f, 0.079109f, 0.079491f,
	0.079874f, 0.080256f, 0.080638f, 0.081020f, 0.081403f, 0.081785f, 0.082167f, 0.082549f,
	0.082931f, 0.083314f, 0.083696f, 0.084078f, 0.084460f, 0.084842f, 0.085224f, 0.085606f,
	0.085988f, 0.086370f, 0.086752f, 0.087135f, 0.087517f, 0.087899f, 0.088281f, 0.088663f,
	0.089045f, 0.089427f, 0.089808f, 0.090190f, 0.090572f, 0.090954f, 0.091336f, 0.091718f,
	0.092100f, 0.092482f, 0.092864f, 0.093245f, 0.093627f, 0.094009f, 0.094391f, 0.094773f,
	0.095154f, 0.095536f, 0.095918f, 0.096300f, 0.096681f, 0.097063f, 0.097445f, 0.097826f,
	0.098208f, 0.098590f, 0.098971f, 0.099353f, 0.099734f, 0.100116f, 0.100498f, 0.100879f,
	0.101261f, 0.101642f, 0.102024f, 0.102405f, 0.102787f, 0.103168f, 0.103550f, 0.103931f,
	0.104312f, 0.104694f, 0.105075f, 0.105456f, 0.105838f, 0.106219f, 0.106600f, 0.106982f,
	0.107363f, 0.107744f, 0.108126f, 0.108507f, 0.108888f, 0.109269f, 0.109650f, 0.110032f,
	0.110413f, 0.110794f, 0.111175f, 0.111556f, 0.111937f, 0.112318f, 0.112699f, 0.113080f,
	0.113461f, 0.113842f, 0.114223f, 0.114604f, 0.114985f, 0.115366f, 0.115747f, 0.116128f,
	0.116509f, 0.116890f, 0.117271f, 0.117652f, 0.118032f, 0.118413f, 0.118794f, 0.119175f,
	0.119556f, 0.119936f, 0.120317f, 0.120698f, 0.121078f, 0.121459f, 0.121840f, 0.122220f,
	0.122601f, 0.122982f, 0.123362f, 0.123743f, 0.124123f, 0.124504f, 0.124884f, 0.125265f,
	0.125645f, 0.126026f, 0.126406f, 0.126787f, 0.127167f, 0.127547f, 0.127928f, 0.128308f,
	0.128688f, 0.129069f, 0.129449f, 0.129829f, 0.130209f, 0.130590f, 0.130970f, 0.131350f,
	0.131730f, 0.132110f, 0.132490f, 0.132870f, 0.133251f, 0.133631f, 0.134011f, 0.134391f,
	0.134771f, 0.135151f, 0.135531f, 0.135911f, 0.136291f, 0.136670f, 0.137050f, 0.137430f,
	0.137810f, 0.138190f, 0.138570f, 0.138949f, 0.139329f, 0.139709f, 0.140089f, 0.140468f,
	0.140848f, 0.141228f, 0.141607f, 0.141987f, 0.142367f, 0.142746f, 0.143126f, 0.143505f,
	0.143885f, 0.144264f, 0.144644f, 0.145023f, 0.145403f, 0.145782f, 0.146161f, 0.146541f,
	0.146920f, 0.147299f, 0.147679f, 0.148058f, 0.148437f, 0.148817f, 0.149196f, 0.149575f,
	0.149954f, 0.150333f, 0.150712f, 0.151091f, 0.151471f, 0.151850f, 0.152229f, 0.152608f,
	0.152987f, 0.153366f, 0.153745f, 0.154124f, 0.154502f, 0.154881f, 0.155260f, 0.155639f,
	0.156018f, 0.156397f, 0.156775f, 0.157154f, 0.157533f, 0.157912f, 0.158290f, 0.158669f,
	0.159047f, 0.159426f, 0.159805f, 0.160183f, 0.160562f, 0.160940f, 0.161319f, 0.161697f,
	0.162076f, 0.162454f, 0.162832f, 0.163211f, 0.163589f, 0.163967f, 0.164346f, 0.164724f,
	0.165102f, 0.165480f, 0.165859f, 0.166237f, 0.166615f, 0.166993f, 0.167371f, 0.167749f,
	0.168127f, 0.168505f, 0.168883f, 0.169261f, 0.169639f, 0.170017f, 0.170395f, 0.170773f,
	0.171151f, 0.171529f, 0.171906f, 0.172284f, 0.172662f, 0.173040f, 0.173417f, 0.173795f,
	0.174173f, 0.174550f, 0.174928f, 0.175305f, 0.175683f, 0.176061f, 0.176438f, 0.176815f,
	0.177193f, 0.177570f, 0.177948f, 0.178325f, 0.178702f, 0.179080f, 0.179457f, 0.179834f,
	0.180212f, 0.180589f, 0.180966f, 0.181343f, 0.181720f, 0.182097f, 0.182474f, 0.182851f,
	0.183228f, 0.183605f, 0.183982f, 0.184359f, 0.184736f, 0.185113f, 0.185490f, 0.185867f,
	0.186244f, 0.186620f, 0.186997f, 0.187374f, 0.187750f, 0.188127f, 0.188504f, 0.188880f,
	0.189257f, 0.189634f, 0.190010f, 0.190387f, 0.190763f, 0.191139f, 0.191516f, 0.191892f,
	0.192269f, 0.192645f, 0.193021f, 0.193397f, 0.193774f, 0.194150f, 0.194526f, 0.194902f,
	0.195278f, 0.195654f, 0.196031f, 0.196407f, 0.196783f, 0.197159f, 0.197535f, 0.197910f,
	0.198286f, 0.198662f, 0.199038f, 0.199414f, 0.199790f, 0.200165f, 0.200541f, 0.200917f,
	0.201292f, 0.201668f, 0.202044f, 0.202419f, 0.202795f, 0.203170f, 0.203546f, 0.203921f,
	0.204297f, 0.204672f, 0.205047f, 0.205423f, 0.205798f, 0.206173f, 0.206549f, 0.206924f,
	0.207299f, 0.207674f, 0.208049f, 0.208424f, 0.208799f, 0.209174f, 0.209549f, 0.209924f,
	0.210299f, 0.210674f, 0.211049f, 0.211424f, 0.211799f, 0.212174f, 0.212548f, 0.212923f,
	0.213298f, 0.213672f, 0.214047f, 0.214422f, 0.214796f, 0.215171f, 0.215545f, 0.215920f,
	0.216294f, 0.216668f, 0.217043f, 0.217417f, 0.217791f, 0.218166f, 0.218540f, 0.218914f,
	0.219288f, 0.219662f, 0.220037f, 0.220411f, 0.220785f, 0.221159f, 0.221533f, 0.221907f,
	0.222281f, 0.222654f, 0.223028f, 0.223402f, 0.223776f, 0.224150f, 0.224523f, 0.224897f,
	0.225271f, 0.225644f, 0.226018f, 0.226392f, 0.226765f, 0.227139f, 0.227512f, 0.227885f,
	0.228259f, 0.228632f, 0.229005f, 0.229379f, 0.229752f, 0.230125f, 0.230498f, 0.230872f,
	0.231245f, 0.231618f, 0.231991f, 0.232364f, 0.232737f, 0.233110f, 0.233483f, 0.233856f,
	0.234228f, 0.234601f, 0.234974f, 0.235347f, 0.235719f, 0.236092f, 0.236465f, 0.236837f,
	0.237210f, 0.237582f, 0.237955f, 0.238327f, 0.238700f, 0.239072f, 0.239445f, 0.239817f,
	0.240189f, 0.240561f, 0.240934f, 0.241306f, 0.241678f, 0.242050f, 0.242422f, 0.242794f,
	0.243166f, 0.243538f, 0.243910f, 0.244282f, 0.244654f, 0.245026f, 0.245397f, 0.245769f,
	0.246141f, 0.246513f, 0.246884f, 0.247256f, 0.247627f, 0.247999f, 0.248370f, 0.248742f,
	0.249113f, 0.249485f, 0.249856f, 0.250227f, 0.250599f, 0.250970f, 0.251341f, 0.251712f,
	0.252083f, 0.252454f, 0.252826f, 0.253197f, 0.253568f, 0.253938f, 0.254309f, 0.254680f,
	0.255051f, 0.255422f, 0.255793f, 0.256163f, 0.256534f, 0.256905f, 0.257275f, 0.257646f,
	0.258016f, 0.258387f, 0.258757f, 0.259128f, 0.259498f, 0.259868f, 0.260239f, 0.260609f,
	0.260979f, 0.261349f, 0.261720f, 0.262090f, 0.262460f, 0.262830f, 0.263200f, 0.263570f,
	0.263940f, 0.264310f, 0.264679f, 0.265049f, 0.265419f, 0.265789f, 0.266158f, 0.266528f,
	0.266898f, 0.267267f, 0.267637f, 0.268006f, 0.268376f, 0.268745f, 0.269114f, 0.269484f,
	0.269853f, 0.270222f, 0.270591f, 0.270961f, 0.271330f, 0.271699f, 0.272068f, 0.272437f,
	0.272806f, 0.273175f, 0.273544f, 0.273913f, 0.274281f, 0.274650f, 0.275019f, 0.275387f,
	0.275756f, 0.276125f, 0.276493f, 0.276862f, 0.277230f, 0.277599f, 0.277967f, 0.278336f,
	0.278704f, 0.279072f, 0.279440f, 0.279809f, 0.280177f, 0.280545f, 0.280913f, 0.281281f,
	0.281649f, 0.282017f, 0.282385f, 0.282753f, 0.283120f, 0.283488f, 0.283856f, 0.284224f,
	0.284591f, 0.284959f, 0.285327f, 0.285694f, 0.286062f, 0.286429f, 0.286796f, 0.287164f,
	0.287531f, 0.287898f, 0.288266f, 0.288633f, 0.289000f, 0.289367f, 0.289734f, 0.290101f,
	0.290468f, 0.290835f, 0.291202f, 0.291569f, 0.291936f, 0.292302f, 0.292669f, 0.293036f,
	0.293402f, 0.293769f, 0.294136f, 0.294502f, 0.294869f, 0.295235f, 0.295601f, 0.295968f,
	0.296334f, 0.296700f, 0.297066f, 0.297433f, 0.297799f, 0.298165f, 0.298531f, 0.298897f,
	0.299263f, 0.299629f, 0.299995f, 0.300360f, 0.300726f, 0.301092f, 0.301458f, 0.301823f,
	0.302189f, 0.302554f, 0.302920f, 0.303285f, 0.303651f, 0.304016f, 0.304381f, 0.304747f,
	0.305112f, 0.305477f, 0.305842f, 0.306207f, 0.306572f, 0.306937f, 0.307302f, 0.307667f,
	0.308032f, 0.308397f, 0.308762f, 0.309126f, 0.309491f, 0.309856f, 0.310220f, 0.310585f,
	0.310949f, 0.311314f, 0.311678f, 0.312043f, 0.312407f, 0.312771f, 0.313135f, 0.313500f,
	0.313864f, 0.314228f, 0.314592f, 0.314956f, 0.315320f, 0.315684f, 0.316048f, 0.316411f,
	0.316775f, 0.317139f, 0.317503f, 0.317866f, 0.318230f, 0.318593f, 0.318957f, 0.319320f,
	0.319684f, 0.320047f, 0.320410f, 0.320774f, 0.321137f, 0.321500f, 0.321863f, 0.322226f,
	0.322589f, 0.322952f, 0.323315f, 0.323678f, 0.324041f, 0.324404f, 0.324766f, 0.325129f,
	0.325492f, 0.325854f, 0.326217f, 0.326579f, 0.326942f, 0.327304f, 0.327666f, 0.328029f,
	0.328391f, 0.328753f, 0.329115f, 0.329477f, 0.329839f, 0.330202f, 0.330563f, 0.330925f,
	0.331287f, 0.331649f, 0.332011f, 0.332373f, 0.332734f, 0.333096f, 0.333457f, 0.333819f,
	0.334180f, 0.334542f, 0.334903f, 0.335265f, 0.335626f, 0.335987f, 0.336348f, 0.336709f,
	0.337070f, 0.337431f, 0.337792f, 0.338153f, 0.338514f, 0.338875f, 0.339236f, 0.339597f,
	0.339957f, 0.340318f, 0.340678f, 0.341039f, 0.341399f, 0.341760f, 0.342120f, 0.342481f,
	0.342841f, 0.343201f, 0.343561f, 0.343921f, 0.344281f, 0.344642f, 0.345001f, 0.345361f,
	0.345721f, 0.346081f, 0.346441f, 0.346801f, 0.347160f, 0.347520f, 0.347879f, 0.348239f,
	0.348598f, 0.348958f, 0.349317f, 0.349676f, 0.350036f, 0.350395f, 0.350754f, 0.351113f,
	0.351472f, 0.351831f, 0.352190f, 0.352549f, 0.352908f, 0.353267f, 0.353626f, 0.353984f,
	0.354343f, 0.354701f, 0.355060f, 0.355418f, 0.355777f, 0.356135f, 0.356494f, 0.356852f,
	0.357210f, 0.357568f, 0.357926f, 0.358284f, 0.358642f, 0.359000f, 0.359358f, 0.359716f,
	0.360074f, 0.360432f, 0.360789f, 0.361147f, 0.361505f, 0.361862f, 0.362220f, 0.362577f,
	0.362934f, 0.363292f, 0.363649f, 0.364006f, 0.364363f, 0.364720f, 0.365077f, 0.365434f,
	0.365791f, 0.366148f, 0.366505f, 0.366862f, 0.367219f, 0.367575f, 0.367932f, 0.368289f,
	0.368645f, 0.369002f, 0.369358f, 0.369714f, 0.370071f, 0.370427f, 0.370783f, 0.371139f,
	0.371495f, 0.371851f, 0.372207f, 0.372563f, 0.372919f, 0.373275f, 0.373631f, 0.373986f,
	0.374342f, 0.374697f, 0.375053f, 0.375408f, 0.375764f, 0.376119f, 0.376475f, 0.376830f,
	0.377185f, 0.377540f, 0.377895f, 0.378250f, 0.378605f, 0.378960f, 0.379315f, 0.379670f,
	0.380025f, 0.380379f, 0.380734f, 0.381088f, 0.381443f, 0.381797f, 0.382152f, 0.382506f,
	0.382861f, 0.383215f, 0.383569f, 0.383923f, 0.384277f, 0.384631f, 0.384985f, 0.385339f,
	0.385693f, 0.386047f, 0.386400f, 0.386754f, 0.387108f, 0.387461f, 0.387815f, 0.388168f,
	0.388522f, 0.388875f, 0.389228f, 0.389582f, 0.389935f, 0.390288f, 0.390641f, 0.390994f,
	0.391347f, 0.391700f, 0.392053f, 0.392405f, 0.392758f, 0.393111f, 0.393463f, 0.393816f,
	0.394168f, 0.394521f, 0.394873f, 0.395225f, 0.395578f, 0.395930f, 0.396282f, 0.396634f,
	0.396986f, 0.397338f, 0.397690f, 0.398042f, 0.398393f, 0.398745f, 0.399097f, 0.399448f,
	0.399800f, 0.400151f, 0.400503f, 0.400854f, 0.401206f, 0.401557f, 0.401908f, 0.402259f,
	0.402610f, 0.402961f, 0.403312f, 0.403663f, 0.404014f, 0.404365f, 0.404715f, 0.405066f,
	0.405417f, 0.405767f, 0.406118f, 0.406468f, 0.406818f, 0.407169f, 0.407519f, 0.407869f,
	0.408219f, 0.408569f, 0.408919f, 0.409269f, 0.409619f, 0.409969f, 0.410319f, 0.410668f,
	0.411018f, 0.411368f, 0.411717f, 0.412067f, 0.412416f, 0.412765f, 0.413115f, 0.413464f,
	0.413813f, 0.414162f, 0.414511f, 0.414860f, 0.415209f, 0.415558f, 0.415906f, 0.416255f,
	0.416604f, 0.416952f, 0.417301f, 0.417650f, 0.417998f, 0.418346f, 0.418695f, 0.419043f,
	0.419391f, 0.419739f, 0.420087f, 0.420435f, 0.420783f, 0.421131f, 0.421479f, 0.421826f,
	0.422174f, 0.422522f, 0.422869f, 0.423217f, 0.423564f, 0.423912f, 0.424259f, 0.424606f,
	0.424953f, 0.425300f, 0.425647f, 0.425994f, 0.426341f, 0.426688f, 0.427035f, 0.427382f,
	0.427728f, 0.428075f, 0.428422f, 0.428768f, 0.429114f, 0.429461f, 0.429807f, 0.430153f,
	0.430500f, 0.430846f, 0.431192f, 0.431538f, 0.431884f, 0.432229f, 0.432575f, 0.432921f,
	0.433267f, 0.433612f, 0.433958f, 0.434303f, 0.434649f, 0.434994f, 0.435339f, 0.435685f,
	0.436030f, 0.436375f, 0.436720f, 0.437065f, 0.437410f, 0.437754f, 0.438099f, 0.438444f,
	0.438789f, 0.439133f, 0.439478f, 0.439822f, 0.440166f, 0.440511f, 0.440855f, 0.441199f,
	0.441543f, 0.441887f, 0.442231f, 0.442575f, 0.442919f, 0.443263f, 0.443607f, 0.443950f,
	0.444294f, 0.444637f, 0.444981f, 0.445324f, 0.445668f, 0.446011f, 0.446354f, 0.446697f,
	0.447040f, 0.447383f, 0.447726f, 0.448069f, 0.448412f, 0.448755f, 0.449097f, 0.449440f,
	0.449783f, 0.450125f, 0.450467f, 0.450810f, 0.451152f, 0.451494f, 0.451836f, 0.452179f,
	0.452521f, 0.452863f, 0.453204f, 0.453546f, 0.453888f, 0.454230f, 0.454571f, 0.454913f,
	0.455254f, 0.455596f, 0.455937f, 0.456278f, 0.456620f, 0.456961f, 0.457302f, 0.457643f,
	0.457984f, 0.458325f, 0.458665f, 0.459006f, 0.459347f, 0.459688f, 0.460028f, 0.460368f,
	0.460709f, 0.461049f, 0.461390f, 0.461730f, 0.462070f, 0.462410f, 0.462750f, 0.463090f,
	0.463430f, 0.463769f, 0.464109f, 0.464449f, 0.464788f, 0.465128f, 0.465467f, 0.465807f,
	0.466146f, 0.466485f, 0.466825f, 0.467164f, 0.467503f, 0.467842f, 0.468181f, 0.468519f,
	0.468858f, 0.469197f, 0.469535f, 0.469874f, 0.470213f, 0.470551f, 0.470889f, 0.471228f,
	0.471566f, 0.471904f, 0.472242f, 0.472580f, 0.472918f, 0.473256f, 0.473594f, 0.473931f,
	0.474269f, 0.474607f, 0.474944f, 0.475282f, 0.475619f, 0.475956f, 0.476294f, 0.476631f,
	0.476968f, 0.477305f, 0.477642f, 0.477979f, 0.478315f, 0.478652f, 0.478989f, 0.479325f,
	0.479662f, 0.479998f, 0.480335f, 0.480671f, 0.481007f, 0.481344f, 0.481680f, 0.482016f,
	0.482352f, 0.482688f, 0.483023f, 0.483359f, 0.483695f, 0.484031f, 0.484366f, 0.484702f,
	0.485037f, 0.485372f, 0.485708f, 0.486043f, 0.486378f, 0.486713f, 0.487048f, 0.487383f,
	0.487718f, 0.488052f, 0.488387f, 0.488722f, 0.489056f, 0.489391f, 0.489725f, 0.490059f,
	0.490394f, 0.490728f, 0.491062f, 0.491396f, 0.491730f, 0.492064f, 0.492398f, 0.492731f,
	0.493065f, 0.493399f, 0.493732f, 0.494066f, 0.494399f, 0.494732f, 0.495066f, 0.495399f,
	0.495732f, 0.496065f, 0.496398f, 0.496731f, 0.497063f, 0.497396f, 0.497729f, 0.498061f,
	0.498394f, 0.498726f, 0.499059f, 0.499391f, 0.499723f, 0.500055f, 0.500387f, 0.500719f,
	0.501051f, 0.501383f, 0.501715f, 0.502047f, 0.502378f, 0.502710f, 0.503041f, 0.503373f,
	0.503704f, 0.504035f, 0.504366f, 0.504698f, 0.505029f, 0.505360f, 0.505690f, 0.506021f,
	0.506352f, 0.506683f, 0.507013f, 0.507344f, 0.507674f, 0.508005f, 0.508335f, 0.508665f,
	0.508995f, 0.509325f, 0.509655f, 0.509985f, 0.510315f, 0.510645f, 0.510974f, 0.511304f,
	0.511634f, 0.511963f, 0.512292f, 0.512622f, 0.512951f, 0.513280f, 0.513609f, 0.513938f,
	0.514267f, 0.514596f, 0.514925f, 0.515254f, 0.515582f, 0.515911f, 0.516239f, 0.516568f,
	0.516896f, 0.517224f, 0.517552f, 0.517880f, 0.518209f, 0.518536f, 0.518864f, 0.519192f,
	0.519520f, 0.519848f, 0.520175f, 0.520503f, 0.520830f, 0.521157f, 0.521485f, 0.521812f,
	0.522139f, 0.522466f, 0.522793f, 0.523120f, 0.523447f, 0.523773f, 0.524100f, 0.524426f,
	0.524753f, 0.525079f, 0.525406f, 0.525732f, 0.526058f, 0.526384f, 0.526710f, 0.527036f,
	0.527362f, 0.527688f, 0.528014f, 0.528339f, 0.528665f, 0.528990f, 0.529316f, 0.529641f,
	0.529966f, 0.530291f, 0.530616f, 0.530941f, 0.531266f, 0.531591f, 0.531916f, 0.532241f,
	0.532565f, 0.532890f, 0.533214f, 0.533539f, 0.533863f, 0.534187f, 0.534512f, 0.534836f,
	0.535160f, 0.535484f, 0.535807f, 0.536131f, 0.536455f, 0.536778f, 0.537102f, 0.537425f,
	0.537749f, 0.538072f, 0.538395f, 0.538718f, 0.539041f, 0.539364f, 0.539687f, 0.540010f,
	0.540333f, 0.540655f, 0.540978f, 0.541301f, 0.541623f, 0.541945f, 0.542268f, 0.542590f,
	0.542912f, 0.543234f, 0.543556f, 0.543878f, 0.544199f, 0.544521f, 0.544843f, 0.545164f,
	0.545486f, 0.545807f, 0.546128f, 0.546450f, 0.546771f, 0.547092f, 0.547413f, 0.547734f,
	0.548054f, 0.548375f, 0.548696f, 0.549016f, 0.549337f, 0.549657f, 0.549978f, 0.550298f,
	0.550618f, 0.550938f, 0.551258f, 0.551578f, 0.551898f, 0.552218f, 0.552537f, 0.552857f,
	0.553176f, 0.553496f, 0.553815f, 0.554134f, 0.554454f, 0.554773f, 0.555092f, 0.555411f,
	0.555730f, 0.556048f, 0.556367f, 0.556686f, 0.557004f, 0.557323f, 0.557641f, 0.557959f,
	0.558278f, 0.558596f, 0.558914f, 0.559232f, 0.559550f, 0.559867f, 0.560185f, 0.560503f,
	0.560820f, 0.561138f, 0.561455f, 0.561773f, 0.562090f, 0.562407f, 0.562724f, 0.563041f,
	0.563358f, 0.563675f, 0.563991f, 0.564308f, 0.564624f, 0.564941f, 0.565257f, 0.565574f,
	0.565890f, 0.566206f, 0.566522f, 0.566838f, 0.567154f, 0.567470f, 0.567786f, 0.568101f,
	0.568417f, 0.568732f, 0.569048f, 0.569363f, 0.569678f, 0.569993f, 0.570308f, 0.570623f,
	0.570938f, 0.571253f, 0.571568f, 0.571882f, 0.572197f, 0.572511f, 0.572826f, 0.573140f,
	0.573454f, 0.573768f, 0.574082f, 0.574396f, 0.574710f, 0.575024f, 0.575338f, 0.575651f,
	0.575965f, 0.576278f, 0.576592f, 0.576905f, 0.577218f, 0.577531f, 0.577844f, 0.578157f,
	0.578470f, 0.578783f, 0.579096f, 0.579408f, 0.579721f, 0.580033f, 0.580346f, 0.580658f,
	0.580970f, 0.581282f, 0.581594f, 0.581906f, 0.582218f, 0.582530f, 0.582841f, 0.583153f,
	0.583464f, 0.583776f, 0.584087f, 0.584398f, 0.584710f, 0.585021f, 0.585332f, 0.585642f,
	0.585953f, 0.586264f, 0.586575f, 0.586885f, 0.587196f, 0.587506f, 0.587816f, 0.588126f,
	0.588437f, 0.588747f, 0.589057f, 0.589366f, 0.589676f, 0.589986f, 0.590295f, 0.590605f,
	0.590914f, 0.591224f, 0.591533f, 0.591842f, 0.592151f, 0.592460f, 0.592769f, 0.593078f,
	0.593387f, 0.593695f, 0.594004f, 0.594312f, 0.594621f, 0.594929f, 0.595237f, 0.595545f,
	0.595853f, 0.596161f, 0.596469f, 0.596777f, 0.597085f, 0.597392f, 0.597700f, 0.598007f,
	0.598314f, 0.598622f, 0.598929f, 0.599236f, 0.599543f, 0.599850f, 0.600156f, 0.600463f,
	0.600770f, 0.601076f, 0.601383f, 0.601689f, 0.601995f, 0.602302f, 0.602608f, 0.602914f,
	0.603220f, 0.603525f, 0.603831f, 0.604137f, 0.604442f, 0.604748f, 0.605053f, 0.605358f,
	0.605664f, 0.605969f, 0.606274f, 0.606579f, 0.606884f, 0.607188f, 0.607493f, 0.607798f,
	0.608102f, 0.608406f, 0.608711f, 0.609015f, 0.609319f, 0.609623f, 0.609927f, 0.610231f,
	0.610535f, 0.610838f, 0.611142f, 0.611445f, 0.611749f, 0.612052f, 0.612355f, 0.612659f,
	0.612962f, 0.613265f, 0.613567f, 0.613870f, 0.614173f, 0.614475f, 0.614778f, 0.615080f,
	0.615383f, 0.615685f, 0.615987f, 0.616289f, 0.616591f, 0.616893f, 0.617195f, 0.617496f,
	0.617798f, 0.618100f, 0.618401f, 0.618702f, 0.619004f, 0.619305f, 0.619606f, 0.619907f,
	0.620208f, 0.620508f, 0.620809f, 0.621110f, 0.621410f, 0.621711f, 0.622011f, 0.622311f,
	0.622611f, 0.622911f, 0.623211f, 0.623511f, 0.623811f, 0.624111f, 0.624410f, 0.624710f,
	0.625009f, 0.625309f, 0.625608f, 0.625907f, 0.626206f, 0.626505f, 0.626804f, 0.627102f,
	0.627401f, 0.627700f, 0.627998f, 0.628297f, 0.628595f, 0.628893f, 0.629191f, 0.629489f,
	0.629787f, 0.630085f, 0.630383f, 0.630680f, 0.630978f, 0.631275f, 0.631573f, 0.631870f,
	0.632167f, 0.632464f, 0.632761f, 0.633058f, 0.633355f, 0.633652f, 0.633949f, 0.634245f,
	0.634541f, 0.634838f, 0.635134f, 0.635430f, 0.635726f, 0.636022f, 0.636318f, 0.636614f,
	0.636910f, 0.637205f, 0.637501f, 0.637796f, 0.638092f, 0.638387f, 0.638682f, 0.638977f,
	0.639272f, 0.639567f, 0.639862f, 0.640156f, 0.640451f, 0.640745f, 0.641040f, 0.641334f,
	0.641628f, 0.641922f, 0.642216f, 0.642510f, 0.642804f, 0.643098f, 0.643391f, 0.643685f,
	0.643978f, 0.644272f, 0.644565f, 0.644858f, 0.645151f, 0.645444f, 0.645737f, 0.646030f,
	0.646322f, 0.646615f, 0.646907f, 0.647200f, 0.647492f, 0.647784f, 0.648076f, 0.648368f,
	0.648660f, 0.648952f, 0.649244f, 0.649536f, 0.649827f, 0.650118f, 0.650410f, 0.650701f,
	0.650992f, 0.651283f, 0.651574f, 0.651865f, 0.652156f, 0.652447f, 0.652737f, 0.653028f,
	0.653318f, 0.653608f, 0.653898f, 0.654189f, 0.654479f, 0.654769f, 0.655058f, 0.655348f,
	0.655638f, 0.655927f, 0.656217f, 0.656506f, 0.656795f, 0.657084f, 0.657373f, 0.657662f,
	0.657951f, 0.658240f, 0.658529f, 0.658817f, 0.659106f, 0.659394f, 0.659682f, 0.659970f,
	0.660258f, 0.660546f, 0.660834f, 0.661122f, 0.661410f, 0.661697f, 0.661985f, 0.662272f,
	0.662559f, 0.662847f, 0.663134f, 0.663421f, 0.663708f, 0.663994f, 0.664281f, 0.664568f,
	0.664854f, 0.665141f, 0.665427f, 0.665713f, 0.665999f, 0.666285f, 0.666571f, 0.666857f,
	0.667143f, 0.667428f, 0.667714f, 0.667999f, 0.668285f, 0.668570f, 0.668855f, 0.669140f,
	0.669425f, 0.669710f, 0.669995f, 0.670279f, 0.670564f, 0.670848f, 0.671133f, 0.671417f,
	0.671701f, 0.671985f, 0.672269f, 0.672553f, 0.672837f, 0.673120f, 0.673404f, 0.673687f,
	0.673971f, 0.674254f, 0.674537f, 0.674820f, 0.675103f, 0.675386f, 0.675669f, 0.675951f,
	0.676234f, 0.676516f, 0.676799f, 0.677081f, 0.677363f, 0.677645f, 0.677927f, 0.678209f,
	0.678491f, 0.678773f, 0.679054f, 0.679336f, 0.679617f, 0.679898f, 0.680179f, 0.680460f,
	0.680741f, 0.681022f, 0.681303f, 0.681584f, 0.681864f, 0.682145f, 0.682425f, 0.682705f,
	0.682986f, 0.683266f, 0.683546f, 0.683825f, 0.684105f, 0.684385f, 0.684664f, 0.684944f,
	0.685223f, 0.685503f, 0.685782f, 0.686061f, 0.686340f, 0.686619f, 0.686897f, 0.687176f,
	0.687455f, 0.687733f, 0.688011f, 0.688290f, 0.688568f, 0.688846f, 0.689124f, 0.689402f,
	0.689679f, 0.689957f, 0.690235f, 0.690512f, 0.690789f, 0.691067f, 0.691344f, 0.691621f,
	0.691898f, 0.692175f, 0.692451f, 0.692728f, 0.693004f, 0.693281f, 0.693557f, 0.693833f,
	0.694109f, 0.694386f, 0.694661f, 0.694937f, 0.695213f, 0.695489f, 0.695764f, 0.696039f,
	0.696315f, 0.696590f, 0.696865f, 0.697140f, 0.697415f, 0.697690f, 0.697964f, 0.698239f,
	0.698513f, 0.698788f, 0.699062f, 0.699336f, 0.699610f, 0.699884f, 0.700158f, 0.700432f,
	0.700706f, 0.700979f, 0.701253f, 0.701526f, 0.701799f, 0.702072f, 0.702345f, 0.702618f,
	0.702891f, 0.703164f, 0.703436f, 0.703709f, 0.703981f, 0.704254f, 0.704526f, 0.704798f,
	0.705070f, 0.705342f, 0.705614f, 0.705885f, 0.706157f, 0.706429f, 0.706700f, 0.706971f,
	0.707242f, 0.707513f, 0.707784f, 0.708055f, 0.708326f, 0.708597f, 0.708867f, 0.709138f,
	0.709408f, 0.709678f, 0.709948f, 0.710218f, 0.710488f, 0.710758f, 0.711028f, 0.711297f,
	0.711567f, 0.711836f, 0.712106f, 0.712375f, 0.712644f, 0.712913f, 0.713182f, 0.713450f,
	0.713719f, 0.713988f, 0.714256f, 0.714525f, 0.714793f, 0.715061f, 0.715329f, 0.715597f,
	0.715865f, 0.716132f, 0.716400f, 0.716668f, 0.716935f, 0.717202f, 0.717469f, 0.717737f,
	0.718004f, 0.718270f, 0.718537f, 0.718804f, 0.719070f, 0.719337f, 0.719603f, 0.719869f,
	0.720136f, 0.720402f, 0.720667f, 0.720933f, 0.721199f, 0.721465f, 0.721730f, 0.721996f,
	0.722261f, 0.722526f, 0.722791f, 0.723056f, 0.723321f, 0.723586f, 0.723850f, 0.724115f,
	0.724379f, 0.724644f, 0.724908f, 0.725172f, 0.725436f, 0.725700f, 0.725964f, 0.726227f,
	0.726491f, 0.726754f, 0.727018f, 0.727281f, 0.727544f, 0.727807f, 0.728070f, 0.728333f,
	0.728596f, 0.728858f, 0.729121f, 0.729383f, 0.729646f, 0.729908f, 0.730170f, 0.730432f,
	0.730694f, 0.730955f, 0.731217f, 0.731479f, 0.731740f, 0.732001f, 0.732263f, 0.732524f,
	0.732785f, 0.733046f, 0.733306f, 0.733567f, 0.733828f, 0.734088f, 0.734349f, 0.734609f,
	0.734869f, 0.735129f, 0.735389f, 0.735649f, 0.735908f, 0.736168f, 0.736428f, 0.736687f,
	0.736946f, 0.737205f, 0.737464f, 0.737723f, 0.737982f, 0.738241f, 0.738500f, 0.738758f,
	0.739016f, 0.739275f, 0.739533f, 0.739791f, 0.740049f, 0.740307f, 0.740565f, 0.740822f,
	0.741080f, 0.741337f, 0.741595f, 0.741852f, 0.742109f, 0.742366f, 0.742623f, 0.742880f,
	0.743136f, 0.743393f, 0.743649f, 0.743906f, 0.744162f, 0.744418f, 0.744674f, 0.744930f,
	0.745186f, 0.745441f, 0.745697f, 0.745952f, 0.746208f, 0.746463f, 0.746718f, 0.746973f,
	0.747228f, 0.747483f, 0.747738f, 0.747992f, 0.748247f, 0.748501f, 0.748755f, 0.749009f,
	0.749263f, 0.749517f, 0.749771f, 0.750025f, 0.750278f, 0.750532f, 0.750785f, 0.751039f,
	0.751292f, 0.751545f, 0.751798f, 0.752050f, 0.752303f, 0.752556f, 0.752808f, 0.753061f,
	0.753313f, 0.753565f, 0.753817f, 0.754069f, 0.754321f, 0.754573f, 0.754824f, 0.755076f,
	0.755327f, 0.755578f, 0.755830f, 0.756081f, 0.756331f, 0.756582f, 0.756833f, 0.757084f,
	0.757334f, 0.757584f, 0.757835f, 0.758085f, 0.758335f, 0.758585f, 0.758835f, 0.759084f,
	0.759334f, 0.759583f, 0.759833f, 0.760082f, 0.760331f, 0.760580f, 0.760829f, 0.761078f,
	0.761327f, 0.761575f, 0.761824f, 0.762072f, 0.762320f, 0.762569f, 0.762817f, 0.763065f,
	0.763312f, 0.763560f, 0.763808f, 0.764055f, 0.764302f, 0.764550f, 0.764797f, 0.765044f,
	0.765291f, 0.765538f, 0.765784f, 0.766031f, 0.766277f, 0.766524f, 0.766770f, 0.767016f,
	0.767262f, 0.767508f, 0.767754f, 0.767999f, 0.768245f, 0.768490f, 0.768736f, 0.768981f,
	0.769226f, 0.769471f, 0.769716f, 0.769960f, 0.770205f, 0.770450f, 0.770694f, 0.770938f,
	0.771183f, 0.771427f, 0.771671f, 0.771915f, 0.772158f, 0.772402f, 0.772645f, 0.772889f,
	0.773132f, 0.773375f, 0.773618f, 0.773861f, 0.774104f, 0.774347f, 0.774589f, 0.774832f,
	0.775074f, 0.775317f, 0.775559f, 0.775801f, 0.776043f, 0.776284f, 0.776526f, 0.776768f,
	0.777009f, 0.777251f, 0.777492f, 0.777733f, 0.777974f, 0.778215f, 0.778456f, 0.778696f,
	0.778937f, 0.779177f, 0.779418f, 0.779658f, 0.779898f, 0.780138f, 0.780378f, 0.780617f,
	0.780857f, 0.781097f, 0.781336f, 0.781575f, 0.781814f, 0.782053f, 0.782292f, 0.782531f,
	0.782770f, 0.783009f, 0.783247f, 0.783485f, 0.783724f, 0.783962f, 0.784200f, 0.784438f,
	0.784675f, 0.784913f, 0.785151f, 0.785388f, 0.785625f, 0.785863f, 0.786100f, 0.786337f,
	0.786574f, 0.786810f, 0.787047f, 0.787284f, 0.787520f, 0.787756f, 0.787992f, 0.788228f,
	0.788464f, 0.788700f, 0.788936f, 0.789172f, 0.789407f, 0.789642f, 0.789878f, 0.790113f,
	0.790348f, 0.790583f, 0.790817f, 0.791052f, 0.791287f, 0.791521f, 0.791755f, 0.791990f,
	0.792224f, 0.792458f, 0.792691f, 0.792925f, 0.793159f, 0.793392f, 0.793626f, 0.793859f,
	0.794092f, 0.794325f, 0.794558f, 0.794791f, 0.795023f, 0.795256f, 0.795488f, 0.795721f,
	0.795953f, 0.796185f, 0.796417f, 0.796649f, 0.796881f, 0.797112f, 0.797344f, 0.797575f,
	0.797806f, 0.798038f, 0.798269f, 0.798500f, 0.798730f, 0.798961f, 0.799192f, 0.799422f,
	0.799652f, 0.799883f, 0.800113f, 0.800343f, 0.800573f, 0.800802f, 0.801032f, 0.801261f,
	0.801491f, 0.801720f, 0.801949f, 0.802178f, 0.802407f, 0.802636f, 0.802865f, 0.803093f,
	0.803322f, 0.803550f, 0.803778f, 0.804006f, 0.804234f, 0.804462f, 0.804690f, 0.804918f,
	0.805145f, 0.805372f, 0.805600f, 0.805827f, 0.806054f, 0.806281f, 0.806508f, 0.806734f,
	0.806961f, 0.807187f, 0.807414f, 0.807640f, 0.807866f, 0.808092f, 0.808318f, 0.808543f,
	0.808769f, 0.808994f, 0.809220f, 0.809445f, 0.809670f, 0.809895f, 0.810120f, 0.810345f,
	0.810570f, 0.810794f, 0.811018f, 0.811243f, 0.811467f, 0.811691f, 0.811915f, 0.812139f,
	0.812362f, 0.812586f, 0.812809f, 0.813033f, 0.813256f, 0.813479f, 0.813702f, 0.813925f,
	0.814148f, 0.814370f, 0.814593f, 0.814815f, 0.815037f, 0.815260f, 0.815482f, 0.815704f,
	0.815925f, 0.816147f, 0.816369f, 0.816590f, 0.816811f, 0.817032f, 0.817253f, 0.817474f,
	0.817695f, 0.817916f, 0.818136f, 0.818357f, 0.818577f, 0.818797f, 0.819018f, 0.819238f,
	0.819457f, 0.819677f, 0.819897f, 0.820116f, 0.820336f, 0.820555f, 0.820774f, 0.820993f,
	0.821212f, 0.821431f, 0.821649f, 0.821868f, 0.822086f, 0.822305f, 0.822523f, 0.822741f,
	0.822959f, 0.823177f, 0.823394f, 0.823612f, 0.823829f, 0.824047f, 0.824264f, 0.824481f,
	0.824698f, 0.824915f, 0.825131f, 0.825348f, 0.825564f, 0.825781f, 0.825997f, 0.826213f,
	0.826429f, 0.826645f, 0.826861f, 0.827076f, 0.827292f, 0.827507f, 0.827722f, 0.827938f,
	0.828153f, 0.828367f, 0.828582f, 0.828797f, 0.829011f, 0.829226f, 0.829440f, 0.829654f,
	0.829868f, 0.830082f, 0.830296f, 0.830510f, 0.830723f, 0.830937f, 0.831150f, 0.831363f,
	0.831576f, 0.831789f, 0.832002f, 0.832215f, 0.832427f, 0.832640f, 0.832852f, 0.833064f,
	0.833276f, 0.833488f, 0.833700f, 0.833912f, 0.834123f, 0.834335f, 0.834546f, 0.834757f,
	0.834968f, 0.835179f, 0.835390f, 0.835601f, 0.835812f, 0.836022f, 0.836232f, 0.836443f,
	0.836653f, 0.836863f, 0.837073f, 0.837282f, 0.837492f, 0.837701f, 0.837911f, 0.838120f,
	0.838329f, 0.838538f, 0.838747f, 0.838956f, 0.839165f, 0.839373f, 0.839581f, 0.839790f,
	0.839998f, 0.840206f, 0.840414f, 0.840621f, 0.840829f, 0.841037f, 0.841244f, 0.841451f,
	0.841659f, 0.841866f, 0.842072f, 0.842279f, 0.842486f, 0.842692f, 0.842899f, 0.843105f,
	0.843311f, 0.843517f, 0.843723f, 0.843929f, 0.844135f, 0.844340f, 0.844546f, 0.844751f,
	0.844956f, 0.845161f, 0.845366f, 0.845571f, 0.845776f, 0.845980f, 0.846185f, 0.846389f,
	0.846593f, 0.846797f, 0.847001f, 0.847205f, 0.847408f, 0.847612f, 0.847815f, 0.848019f,
	0.848222f, 0.848425f, 0.848628f, 0.848831f, 0.849033f, 0.849236f, 0.849438f, 0.849641f,
	0.849843f, 0.850045f, 0.850247f, 0.850449f, 0.850650f, 0.850852f, 0.851053f, 0.851255f,
	0.851456f, 0.851657f, 0.851858f, 0.852059f, 0.852259f, 0.852460f, 0.852660f, 0.852860f,
	0.853061f, 0.853261f, 0.853461f, 0.853660f, 0.853860f, 0.854060f, 0.854259f, 0.854458f,
	0.854658f, 0.854857f, 0.855056f, 0.855254f, 0.855453f, 0.855651f, 0.855850f, 0.856048f,
	0.856246f, 0.856444f, 0.856642f, 0.856840f, 0.857038f, 0.857235f, 0.857433f, 0.857630f,
	0.857827f, 0.858024f, 0.858221f, 0.858418f, 0.858615f, 0.858811f, 0.859007f, 0.859204f,
	0.859400f, 0.859596f, 0.859792f, 0.859988f, 0.860183f, 0.860379f, 0.860574f, 0.860769f,
	0.860965f, 0.861160f, 0.861354f, 0.861549f, 0.861744f, 0.861938f, 0.862133f, 0.862327f,
	0.862521f, 0.862715f, 0.862909f, 0.863103f, 0.863296f, 0.863490f, 0.863683f, 0.863876f,
	0.864069f, 0.864262f, 0.864455f, 0.864648f, 0.864841f, 0.865033f, 0.865225f, 0.865418f,
	0.865610f, 0.865802f, 0.865993f, 0.866185f, 0.866377f, 0.866568f, 0.866760f, 0.866951f,
	0.867142f, 0.867333f, 0.867524f, 0.867714f, 0.867905f, 0.868095f, 0.868285f, 0.868476f,
	0.868666f, 0.868856f, 0.869045f, 0.869235f, 0.869425f, 0.869614f, 0.869803f, 0.869992f,
	0.870181f, 0.870370f, 0.870559f, 0.870748f, 0.870936f, 0.871125f, 0.871313f, 0.871501f,
	0.871689f, 0.871877f, 0.872065f, 0.872252f, 0.872440f, 0.872627f, 0.872814f, 0.873001f,
	0.873188f, 0.873375f, 0.873562f, 0.873749f, 0.873935f, 0.874121f, 0.874308f, 0.874494f,
	0.874680f, 0.874865f, 0.875051f, 0.875237f, 0.875422f, 0.875607f, 0.875793f, 0.875978f,
	0.876163f, 0.876347f, 0.876532f, 0.876716f, 0.876901f, 0.877085f, 0.877269f, 0.877453f,
	0.877637f, 0.877821f, 0.878005f, 0.878188f, 0.878371f, 0.878555f, 0.878738f, 0.878921f,
	0.879104f, 0.879286f, 0.879469f, 0.879651f, 0.879834f, 0.880016f, 0.880198f, 0.880380f,
	0.880562f, 0.880744f, 0.880925f, 0.881106f, 0.881288f, 0.881469f, 0.881650f, 0.881831f,
	0.882012f, 0.882192f, 0.882373f, 0.882553f, 0.882733f, 0.882914f, 0.883094f, 0.883273f,
	0.883453f, 0.883633f, 0.883812f, 0.883992f, 0.884171f, 0.884350f, 0.884529f, 0.884708f,
	0.884886f, 0.885065f, 0.885243f, 0.885422f, 0.885600f, 0.885778f, 0.885956f, 0.886134f,
	0.886311f, 0.886489f, 0.886666f, 0.886844f, 0.887021f, 0.887198f, 0.887375f, 0.887551f,
	0.887728f, 0.887904f, 0.888081f, 0.888257f, 0.888433f, 0.888609f, 0.888785f, 0.888961f,
	0.889136f, 0.889312f, 0.889487f, 0.889662f, 0.889837f, 0.890012f, 0.890187f, 0.890361f,
	0.890536f, 0.890710f, 0.890885f, 0.891059f, 0.891233f, 0.891407f, 0.891580f, 0.891754f,
	0.891927f, 0.892101f, 0.892274f, 0.892447f, 0.892620f, 0.892793f, 0.892966f, 0.893138f,
	0.893310f, 0.893483f, 0.893655f, 0.893827f, 0.893999f, 0.894171f, 0.894342f, 0.894514f,
	0.894685f, 0.894856f, 0.895028f, 0.895198f, 0.895369f, 0.895540f, 0.895711f, 0.895881f,
	0.896051f, 0.896222f, 0.896392f, 0.896562f, 0.896731f, 0.896901f, 0.897071f, 0.897240f,
	0.897409f, 0.897578f, 0.897747f, 0.897916f, 0.898085f, 0.898254f, 0.898422f, 0.898590f,
	0.898759f, 0.898927f, 0.899095f, 0.899262f, 0.899430f, 0.899598f, 0.899765f, 0.899932f,
	0.900099f, 0.900266f, 0.900433f, 0.900600f, 0.900767f, 0.900933f, 0.901100f, 0.901266f,
	0.901432f, 0.901598f, 0.901764f, 0.901929f, 0.902095f, 0.902260f, 0.902426f, 0.902591f,
	0.902756f, 0.902921f, 0.903086f, 0.903250f, 0.903415f, 0.903579f, 0.903743f, 0.903907f,
	0.904071f, 0.904235f, 0.904399f, 0.904562f, 0.904726f, 0.904889f, 0.905052f, 0.905215f,
	0.905378f, 0.905541f, 0.905704f, 0.905866f, 0.906029f, 0.906191f, 0.906353f, 0.906515f,
	0.906677f, 0.906838f, 0.907000f, 0.907161f, 0.907323f, 0.907484f, 0.907645f, 0.907806f,
	0.907966f, 0.908127f, 0.908288f, 0.908448f, 0.908608f, 0.908768f, 0.908928f, 0.909088f,
	0.909248f, 0.909407f, 0.909567f, 0.909726f, 0.909885f, 0.910044f, 0.910203f, 0.910362f,
	0.910521f, 0.910679f, 0.910837f, 0.910996f, 0.911154f, 0.911312f, 0.911470f, 0.911627f,
	0.911785f, 0.911942f, 0.912099f, 0.912257f, 0.912414f, 0.912571f, 0.912727f, 0.912884f,
	0.913040f, 0.913197f, 0.913353f, 0.913509f, 0.913665f, 0.913821f, 0.913976f, 0.914132f,
	0.914287f, 0.914443f, 0.914598f, 0.914753f, 0.914908f, 0.915062f, 0.915217f, 0.915372f,
	0.915526f, 0.915680f, 0.915834f, 0.915988f, 0.916142f, 0.916296f, 0.916449f, 0.916602f,
	0.916756f, 0.916909f, 0.917062f, 0.917215f, 0.917367f, 0.917520f, 0.917672f, 0.917825f,
	0.917977f, 0.918129f, 0.918281f, 0.918433f, 0.918584f, 0.918736f, 0.918887f, 0.919038f,
	0.919189f, 0.919340f, 0.919491f, 0.919642f, 0.919792f, 0.919943f, 0.920093f, 0.920243f,
	0.920393f, 0.920543f, 0.920693f, 0.920843f, 0.920992f, 0.921141f, 0.921291f, 0.921440f,
	0.921588f, 0.921737f, 0.921886f, 0.922035f, 0.922183f, 0.922331f, 0.922479f, 0.922627f,
	0.922775f, 0.922923f, 0.923070f, 0.923218f, 0.923365f, 0.923512f, 0.923659f, 0.923806f,
	0.923953f, 0.924100f, 0.924246f, 0.924392f, 0.924539f, 0.924685f, 0.924831f, 0.924976f,
	0.925122f, 0.925268f, 0.925413f, 0.925558f, 0.925703f, 0.925848f, 0.925993f, 0.926138f,
	0.926283f, 0.926427f, 0.926571f, 0.926715f, 0.926859f, 0.927003f, 0.927147f, 0.927291f,
	0.927434f, 0.927578f, 0.927721f, 0.927864f, 0.928007f, 0.928150f, 0.928292f, 0.928435f,
	0.928577f, 0.928720f, 0.928862f, 0.929004f, 0.929146f, 0.929287f, 0.929429f, 0.929570f,
	0.929712f, 0.929853f, 0.929994f, 0.930135f, 0.930275f, 0.930416f, 0.930557f, 0.930697f,
	0.930837f, 0.930977f, 0.931117f, 0.931257f, 0.931397f, 0.931536f, 0.931675f, 0.931815f,
	0.931954f, 0.932093f, 0.932232f, 0.932370f, 0.932509f, 0.932647f, 0.932786f, 0.932924f,
	0.933062f, 0.933200f, 0.933337f, 0.933475f, 0.933613f, 0.933750f, 0.933887f, 0.934024f,
	0.934161f, 0.934298f, 0.934434f, 0.934571f, 0.934707f, 0.934844f, 0.934980f, 0.935116f,
	0.935251f, 0.935387f, 0.935523f, 0.935658f, 0.935793f, 0.935928f, 0.936063f, 0.936198f,
	0.936333f, 0.936468f, 0.936602f, 0.936736f, 0.936871f, 0.937005f, 0.937138f, 0.937272f,
	0.937406f, 0.937539f, 0.937673f, 0.937806f, 0.937939f, 0.938072f, 0.938205f, 0.938337f,
	0.938470f, 0.938602f, 0.938734f, 0.938866f, 0.938998f, 0.939130f, 0.939262f, 0.939394f,
	0.939525f, 0.939656f, 0.939787f, 0.939918f, 0.940049f, 0.940180f, 0.940310f, 0.940441f,
	0.940571f, 0.940701f, 0.940831f, 0.940961f, 0.941091f, 0.941221f, 0.941350f, 0.941479f,
	0.941609f, 0.941738f, 0.941867f, 0.941995f, 0.942124f, 0.942253f, 0.942381f, 0.942509f,
	0.942637f, 0.942765f, 0.942893f, 0.943021f, 0.943148f, 0.943276f, 0.943403f, 0.943530f,
	0.943657f, 0.943784f, 0.943910f, 0.944037f, 0.944163f, 0.944290f, 0.944416f, 0.944542f,
	0.944668f, 0.944794f, 0.944919f, 0.945045f, 0.945170f, 0.945295f, 0.945420f, 0.945545f,
	0.945670f, 0.945794f, 0.945919f, 0.946043f, 0.946167f, 0.946291f, 0.946415f, 0.946539f,
	0.946663f, 0.946786f, 0.946910f, 0.947033f, 0.947156f, 0.947279f, 0.947402f, 0.947524f,
	0.947647f, 0.947769f, 0.947891f, 0.948014f, 0.948136f, 0.948257f, 0.948379f, 0.948501f,
	0.948622f, 0.948743f, 0.948864f, 0.948985f, 0.949106f, 0.949227f, 0.949348f, 0.949468f,
	0.949588f, 0.949709f, 0.949829f, 0.949948f, 0.950068f, 0.950188f, 0.950307f, 0.950427f,
	0.950546f, 0.950665f, 0.950784f, 0.950902f, 0.951021f, 0.951139f, 0.951258f, 0.951376f,
	0.951494f, 0.951612f, 0.951730f, 0.951847f, 0.951965f, 0.952082f, 0.952199f, 0.952317f,
	0.952433f, 0.952550f, 0.952667f, 0.952783f, 0.952900f, 0.953016f, 0.953132f, 0.953248f,
	0.953364f, 0.953480f, 0.953595f, 0.953710f, 0.953826f, 0.953941f, 0.954056f, 0.954171f,
	0.954285f, 0.954400f, 0.954514f, 0.954629f, 0.954743f, 0.954857f, 0.954971f, 0.955084f,
	0.955198f, 0.955311f, 0.955425f, 0.955538f, 0.955651f, 0.955764f, 0.955876f, 0.955989f,
	0.956101f, 0.956214f, 0.956326f, 0.956438f, 0.956550f, 0.956662f, 0.956773f, 0.956885f,
	0.956996f, 0.957107f, 0.957218f, 0.957329f, 0.957440f, 0.957550f, 0.957661f, 0.957771f,
	0.957882f, 0.957992f, 0.958101f, 0.958211f, 0.958321f, 0.958430f, 0.958540f, 0.958649f,
	0.958758f, 0.958867f, 0.958976f, 0.959084f, 0.959193f, 0.959301f, 0.959409f, 0.959518f,
	0.959625f, 0.959733f, 0.959841f, 0.959948f, 0.960056f, 0.960163f, 0.960270f, 0.960377f,
	0.960484f, 0.960591f, 0.960697f, 0.960804f, 0.960910f, 0.961016f, 0.961122f, 0.961228f,
	0.961333f, 0.961439f, 0.961544f, 0.961650f, 0.961755f, 0.961860f, 0.961964f, 0.962069f,
	0.962174f, 0.962278f, 0.962382f, 0.962486f, 0.962590f, 0.962694f, 0.962798f, 0.962902f,
	0.963005f, 0.963108f, 0.963211f, 0.963314f, 0.963417f, 0.963520f, 0.963623f, 0.963725f,
	0.963827f, 0.963929f, 0.964031f, 0.964133f, 0.964235f, 0.964337f, 0.964438f, 0.964539f,
	0.964640f, 0.964741f, 0.964842f, 0.964943f, 0.965043f, 0.965144f, 0.965244f, 0.965344f,
	0.965444f, 0.965544f, 0.965644f, 0.965744f, 0.965843f, 0.965942f, 0.966042f, 0.966141f,
	0.966239f, 0.966338f, 0.966437f, 0.966535f, 0.966633f, 0.966732f, 0.966830f, 0.966928f,
	0.967025f, 0.967123f, 0.967220f, 0.967318f, 0.967415f, 0.967512f, 0.967609f, 0.967705f,
	0.967802f, 0.967899f, 0.967995f, 0.968091f, 0.968187f, 0.968283f, 0.968379f, 0.968474f,
	0.968570f, 0.968665f, 0.968760f, 0.968855f, 0.968950f, 0.969045f, 0.969140f, 0.969234f,
	0.969328f, 0.969423f, 0.969517f, 0.969611f, 0.969704f, 0.969798f, 0.969891f, 0.969985f,
	0.970078f, 0.970171f, 0.970264f, 0.970357f, 0.970449f, 0.970542f, 0.970634f, 0.970726f,
	0.970818f, 0.970910f, 0.971002f, 0.971093f, 0.971185f, 0.971276f, 0.971367f, 0.971458f,
	0.971549f, 0.971640f, 0.971731f, 0.971821f, 0.971911f, 0.972002f, 0.972092f, 0.972182f,
	0.972271f, 0.972361f, 0.972450f, 0.972540f, 0.972629f, 0.972718f, 0.972807f, 0.972896f,
	0.972984f, 0.973073f, 0.973161f, 0.973249f, 0.973337f, 0.973425f, 0.973513f, 0.973601f,
	0.973688f, 0.973775f, 0.973862f, 0.973949f, 0.974036f, 0.974123f, 0.974210f, 0.974296f,
	0.974383f, 0.974469f, 0.974555f, 0.974641f, 0.974726f, 0.974812f, 0.974897f, 0.974983f,
	0.975068f, 0.975153f, 0.975238f, 0.975323f, 0.975407f, 0.975492f, 0.975576f, 0.975660f,
	0.975744f, 0.975828f, 0.975912f, 0.975995f, 0.976079f, 0.976162f, 0.976245f, 0.976328f,
	0.976411f, 0.976494f, 0.976576f, 0.976659f, 0.976741f, 0.976823f, 0.976905f, 0.976987f,
	0.977069f, 0.977151f, 0.977232f, 0.977313f, 0.977394f, 0.977475f, 0.977556f, 0.977637f,
	0.977718f, 0.977798f, 0.977878f, 0.977959f, 0.978038f, 0.978118f, 0.978198f, 0.978278f,
	0.978357f, 0.978436f, 0.978516f, 0.978594f, 0.978673f, 0.978752f, 0.978831f, 0.978909f,
	0.978987f, 0.979065f, 0.979143f, 0.979221f, 0.979299f, 0.979376f, 0.979454f, 0.979531f,
	0.979608f, 0.979685f, 0.979762f, 0.979839f, 0.979915f, 0.979992f, 0.980068f, 0.980144f,
	0.980220f, 0.980296f, 0.980372f, 0.980447f, 0.980523f, 0.980598f, 0.980673f, 0.980748f,
	0.980823f, 0.980897f, 0.980972f, 0.981046f, 0.981121f, 0.981195f, 0.981269f, 0.981342f,
	0.981416f, 0.981490f, 0.981563f, 0.981636f, 0.981709f, 0.981782f, 0.981855f, 0.981928f,
	0.982000f, 0.982072f, 0.982145f, 0.982217f, 0.982289f, 0.982360f, 0.982432f, 0.982504f,
	0.982575f, 0.982646f, 0.982717f, 0.982788f, 0.982859f, 0.982930f, 0.983000f, 0.983070f,
	0.983141f, 0.983211f, 0.983281f, 0.983350f, 0.983420f, 0.983489f, 0.983559f, 0.983628f,
	0.983697f, 0.983766f, 0.983835f, 0.983903f, 0.983972f, 0.984040f, 0.984108f, 0.984176f,
	0.984244f, 0.984312f, 0.984379f, 0.984447f, 0.984514f, 0.984581f, 0.984648f, 0.984715f,
	0.984782f, 0.984848f, 0.984915f, 0.984981f, 0.985047f, 0.985113f, 0.985179f, 0.985245f,
	0.985310f, 0.985376f, 0.985441f, 0.985506f, 0.985571f, 0.985636f, 0.985701f, 0.985765f,
	0.985830f, 0.985894f, 0.985958f, 0.986022f, 0.986086f, 0.986150f, 0.986213f, 0.986276f,
	0.986340f, 0.986403f, 0.986466f, 0.986529f, 0.986591f, 0.986654f, 0.986716f, 0.986778f,
	0.986840f, 0.986902f, 0.986964f, 0.987026f, 0.987087f, 0.987149f, 0.987210f, 0.987271f,
	0.987332f, 0.987393f, 0.987453f, 0.987514f, 0.987574f, 0.987634f, 0.987694f, 0.987754f,
	0.987814f, 0.987874f, 0.987933f, 0.987992f, 0.988052f, 0.988111f, 0.988169f, 0.988228f,
	0.988287f, 0.988345f, 0.988404f, 0.988462f, 0.988520f, 0.988578f, 0.988635f, 0.988693f,
	0.988750f, 0.988808f, 0.988865f, 0.988922f, 0.988979f, 0.989035f, 0.989092f, 0.989148f,
	0.989205f, 0.989261f, 0.989317f, 0.989373f, 0.989428f, 0.989484f, 0.989539f, 0.989594f,
	0.989650f, 0.989705f, 0.989759f, 0.989814f, 0.989869f, 0.989923f, 0.989977f, 0.990031f,
	0.990085f, 0.990139f, 0.990193f, 0.990246f, 0.990299f, 0.990353f, 0.990406f, 0.990459f,
	0.990511f, 0.990564f, 0.990617f, 0.990669f, 0.990721f, 0.990773f, 0.990825f, 0.990877f,
	0.990928f, 0.990980f, 0.991031f, 0.991082f, 0.991133f, 0.991184f, 0.991235f, 0.991286f,
	0.991336f, 0.991386f, 0.991437f, 0.991487f, 0.991536f, 0.991586f, 0.991636f, 0.991685f,
	0.991734f, 0.991783f, 0.991832f, 0.991881f, 0.991930f, 0.991979f, 0.992027f, 0.992075f,
	0.992123f, 0.992171f, 0.992219f, 0.992267f, 0.992314f, 0.992362f, 0.992409f, 0.992456f,
	0.992503f, 0.992550f, 0.992596f, 0.992643f, 0.992689f, 0.992736f, 0.992782f, 0.992828f,
	0.992873f, 0.992919f, 0.992964f, 0.993010f, 0.993055f, 0.993100f, 0.993145f, 0.993190f,
	0.993234f, 0.993279f, 0.993323f, 0.993367f, 0.993411f, 0.993455f, 0.993499f, 0.993542f,
	0.993586f, 0.993629f, 0.993672f, 0.993715f, 0.993758f, 0.993801f, 0.993843f, 0.993886f,
	0.993928f, 0.993970f, 0.994012f, 0.994054f, 0.994096f, 0.994137f, 0.994179f, 0.994220f,
	0.994261f, 0.994302f, 0.994343f, 0.994383f, 0.994424f, 0.994464f, 0.994505f, 0.994545f,
	0.994585f, 0.994624f, 0.994664f, 0.994703f, 0.994743f, 0.994782f, 0.994821f, 0.994860f,
	0.994899f, 0.994937f, 0.994976f, 0.995014f, 0.995052f, 0.995090f, 0.995128f, 0.995166f,
	0.995203f, 0.995241f, 0.995278f, 0.995315f, 0.995352f, 0.995389f, 0.995426f, 0.995463f,
	0.995499f, 0.995535f, 0.995571f, 0.995607f, 0.995643f, 0.995679f, 0.995714f, 0.995750f,
	0.995785f, 0.995820f, 0.995855f, 0.995890f, 0.995925f, 0.995959f, 0.995993f, 0.996028f,
	0.996062f, 0.996096f, 0.996129f, 0.996163f, 0.996197f, 0.996230f, 0.996263f, 0.996296f,
	0.996329f, 0.996362f, 0.996394f, 0.996427f, 0.996459f, 0.996491f, 0.996523f, 0.996555f,
	0.996587f, 0.996619f, 0.996650f, 0.996681f, 0.996712f, 0.996743f, 0.996774f, 0.996805f,
	0.996836f, 0.996866f, 0.996896f, 0.996926f, 0.996956f, 0.996986f, 0.997016f, 0.997045f,
	0.997075f, 0.997104f, 0.997133f, 0.997162f, 0.997191f, 0.997219f, 0.997248f, 0.997276f,
	0.997305f, 0.997333f, 0.997361f, 0.997388f, 0.997416f, 0.997443f, 0.997471f, 0.997498f,
	0.997525f, 0.997552f, 0.997579f, 0.997605f, 0.997632f, 0.997658f, 0.997684f, 0.997710f,
	0.997736f, 0.997762f, 0.997787f, 0.997813f, 0.997838f, 0.997863f, 0.997888f, 0.997913f,
	0.997938f, 0.997962f, 0.997987f, 0.998011f, 0.998035f, 0.998059f, 0.998083f, 0.998106f,
	0.998130f, 0.998153f, 0.998176f, 0.998200f, 0.998222f, 0.998245f, 0.998268f, 0.998290f,
	0.998313f, 0.998335f, 0.998357f, 0.998379f, 0.998401f, 0.998422f, 0.998444f, 0.998465f,
	0.998486f, 0.998507f, 0.998528f, 0.998549f, 0.998569f, 0.998590f, 0.998610f, 0.998630f,
	0.998650f, 0.998670f, 0.998690f, 0.998709f, 0.998729f, 0.998748f, 0.998767f, 0.998786f,
	0.998805f, 0.998824f, 0.998842f, 0.998860f, 0.998879f, 0.998897f, 0.998915f, 0.998932f,
	0.998950f, 0.998968f, 0.998985f, 0.999002f, 0.999019f, 0.999036f, 0.999053f, 0.999069f,
	0.999086f, 0.999102f, 0.999118f, 0.999134f, 0.999150f, 0.999166f, 0.999182f, 0.999197f,
	0.999212f, 0.999228f, 0.999243f, 0.999257f, 0.999272f, 0.999287f, 0.999301f, 0.999315f,
	0.999329f, 0.999343f, 0.999357f, 0.999371f, 0.999384f, 0.999398f, 0.999411f, 0.999424f,
	0.999437f, 0.999450f, 0.999462f, 0.999475f, 0.999487f, 0.999500f, 0.999512f, 0.999524f,
	0.999535f, 0.999547f, 0.999558f, 0.999570f, 0.999581f, 0.999592f, 0.999603f, 0.999614f,
	0.999624f, 0.999635f, 0.999645f, 0.999655f, 0.999665f, 0.999675f, 0.999685f, 0.999694f,
	0.999704f, 0.999713f, 0.999722f, 0.999731f, 0.999740f, 0.999748f, 0.999757f, 0.999765f,
	0.999774f, 0.999782f, 0.999790f, 0.999797f, 0.999805f, 0.999812f, 0.999820f, 0.999827f,
	0.999834f, 0.999841f, 0.999848f, 0.999854f, 0.999861f, 0.999867f, 0.999873f, 0.999879f,
	0.999885f, 0.999891f, 0.999897f, 0.999902f, 0.999907f, 0.999913f, 0.999917f, 0.999922f,
	0.999927f, 0.999932f, 0.999936f, 0.999940f, 0.999944f, 0.999948f, 0.999952f, 0.999956f,
	0.999959f, 0.999963f, 0.999966f, 0.999969f, 0.999972f, 0.999975f, 0.999977f, 0.999980f,
	0.999982f, 0.999985f, 0.999987f, 0.999988f, 0.999990f, 0.999992f, 0.999993f, 0.999995f,
	0.999996f, 0.999997f, 0.999998f, 0.999999f, 0.999999f, 1.000000f, 1.000000f, 1.000000f
};

static const float *sineWindows[13] = {
	nullptr             , nullptr             , nullptr             , nullptr            , nullptr            ,
	sineWindow32  , sineWindow64  , sineWindow128 , sineWindow256, sineWindow512,
	sineWindow1024, sineWindow2048, sineWindow4096
};

const float *getSineWindow(int bits) {
	assert((bits >= 5) && (bits <= 12));

	return sineWindows[bits];
}

} // End of namespace Math
