//===-- SPIRVInstPrinter.h - Output SPIR-V MCInsts as ASM -------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This class prints a SPIR-V MCInst to a .s file.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_SPIRV_INSTPRINTER_SPIRVINSTPRINTER_H
#define LLVM_LIB_TARGET_SPIRV_INSTPRINTER_SPIRVINSTPRINTER_H

#include "MCTargetDesc/SPIRVBaseInfo.h"
#include "llvm/ADT/DenseSet.h"
#include "llvm/MC/MCInstPrinter.h"

namespace llvm {
class SPIRVInstPrinter : public MCInstPrinter {
private:
  SmallDenseMap<unsigned, SPIRV::InstructionSet::InstructionSet> ExtInstSetIDs;
  void recordOpExtInstImport(const MCInst *MI);

public:
  using MCInstPrinter::MCInstPrinter;

  void printInst(const MCInst *MI, uint64_t Address, StringRef Annot,
                 const MCSubtargetInfo &STI, raw_ostream &OS) override;
  void printOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O,
                    const char *Modifier = nullptr);

  void printStringImm(const MCInst *MI, unsigned OpNo, raw_ostream &O);

  void printOpDecorate(const MCInst *MI, raw_ostream &O);
  void printOpExtInst(const MCInst *MI, raw_ostream &O);
  void printRemainingVariableOps(const MCInst *MI, unsigned StartIndex,
                                 raw_ostream &O, bool SkipFirstSpace = false,
                                 bool SkipImmediates = false);
  void printOpConstantVarOps(const MCInst *MI, unsigned StartIndex,
                             raw_ostream &O);

  void printExtension(const MCInst *MI, unsigned OpNo, raw_ostream &O);
  template <SPIRV::OperandCategory::OperandCategory category>
  void printSymbolicOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O);

  // Autogenerated by tblgen.
  std::pair<const char *, uint64_t> getMnemonic(const MCInst *MI) override;
  void printInstruction(const MCInst *MI, uint64_t Address, raw_ostream &O);
  static const char *getRegisterName(unsigned RegNo);
};
} // namespace llvm

#endif // LLVM_LIB_TARGET_SPIRV_INSTPRINTER_SPIRVINSTPRINTER_H
