/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef GRUBVERIFY_H
#define GRUBVERIFY_H

#include <QDialog>
#include <QLineEdit>
#include <QLabel>
#include <QHBoxLayout>
#include <QPushButton>
#include <QEvent>
#include <QKeyEvent>

class GrubVerify : public QDialog
{
    Q_OBJECT
public:
    explicit GrubVerify(QWidget *parent = nullptr);
    ~GrubVerify();

private:

    QVBoxLayout * mainVerLayout;
    QVBoxLayout * contentVerLayout;
    QHBoxLayout * userHorLayout;
    QHBoxLayout * newPwdHorLayout;
    QHBoxLayout * surePwdHorLayout;
    QHBoxLayout * bottomBtnsHorLayout;
    QHBoxLayout *newTipHorLayout;
    QHBoxLayout *sureTipHorLayout;
    QString newPwdTip;
    QString surePwdTip;

    QPushButton *cancelBtn;
    QPushButton *confirmBtn;

    QLabel *userLabel;
    QLabel *curTipLabel;
    QLabel *newPwdLabel;
    QLabel *newTipLabel;
    QLabel *surePwdLabel;
    QLabel *sureTipLabel;

    QLabel * usernameLabel;
    QLineEdit * newPwdLineEdit;
    QLineEdit * surePwdLineEdit;

    QPushButton *currentPwdEyeBtn;
    QPushButton *newPwdEyeBtn;
    QPushButton *surePwdEyeBtn;

private:
    void initUI();
    void setupConnect();
    bool setTextDynamicInPwd(QLabel * label, QString string);
    void checkPwdLegality();
    void updateTipLableInfo(QLabel *Label,QString info);
    void refreshConfirmBtnStatus();

protected:
    bool eventFilter(QObject *target, QEvent *event);

signals:


};

#endif // GRUBVERIFY_H
